/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManagerImpl;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.facet.impl.FacetModelBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FacetModelImpl
extends FacetModelBase
implements ModifiableFacetModel {
    private static final Logger LOG = Logger.getInstance(FacetModelImpl.class);
    private final List<Facet<?>> myFacets;
    private final Map<Facet<?>, String> myFacet2NewName;
    private final FacetManagerImpl myManager;
    private final List<ModifiableFacetModel.Listener> myListeners;

    public FacetModelImpl(@NotNull FacetManagerImpl manager) {
        if (manager == null) {
            FacetModelImpl.$$$reportNull$$$0(0);
        }
        this.myFacets = new ArrayList();
        this.myFacet2NewName = new HashMap();
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myManager = manager;
    }

    public void addFacetsFromManager() {
        for (Facet<?> facet : this.myManager.getAllFacets()) {
            this.addFacet(facet);
        }
    }

    @Override
    public void addFacet(Facet<?> facet) {
        if (this.myFacets.contains(facet)) {
            LOG.error("Facet " + facet + " [" + facet.getTypeId() + "] is already added");
        }
        this.myFacets.add(facet);
        this.facetsChanged();
    }

    @Override
    public void addFacet(Facet<?> facet, @Nullable ProjectModelExternalSource externalSource) {
        this.addFacet(facet);
        FacetManagerImpl.setExternalSource(facet, externalSource);
    }

    @Override
    public void removeFacet(Facet<?> facet) {
        if (!this.myFacets.remove(facet)) {
            LOG.error("Facet " + facet + " [" + facet.getTypeId() + "] not found");
        }
        this.myFacet2NewName.remove(facet);
        this.facetsChanged();
    }

    @Override
    public void replaceFacet(@NotNull Facet<?> original, @NotNull Facet<?> replacement) {
        int index;
        if (original == null) {
            FacetModelImpl.$$$reportNull$$$0(1);
        }
        if (replacement == null) {
            FacetModelImpl.$$$reportNull$$$0(2);
        }
        if ((index = this.myFacets.indexOf(original)) != -1) {
            this.myFacets.set(index, replacement);
            this.facetsChanged();
        }
    }

    @Override
    public void rename(Facet<?> facet, String newName) {
        if (!newName.equals(facet.getName())) {
            this.myFacet2NewName.put(facet, newName);
        } else {
            this.myFacet2NewName.remove(facet);
        }
        this.facetsChanged();
    }

    @Override
    @Nullable
    public String getNewName(Facet<?> facet) {
        return this.myFacet2NewName.get(facet);
    }

    @Override
    public void commit() {
        this.myManager.commit(this);
    }

    @Override
    public boolean isModified() {
        return !new HashSet(this.myFacets).equals(ContainerUtil.set(this.myManager.getAllFacets())) || !this.myFacet2NewName.isEmpty();
    }

    @Override
    public boolean isNewFacet(Facet<?> facet) {
        return this.myFacets.contains(facet) && ArrayUtil.find(this.myManager.getAllFacets(), facet) == -1;
    }

    @Override
    public Facet<?> @NotNull [] getAllFacets() {
        Facet[] facetArray = this.myFacets.toArray(Facet.EMPTY_ARRAY);
        if (facetArray == null) {
            FacetModelImpl.$$$reportNull$$$0(3);
        }
        return facetArray;
    }

    @Override
    @NotNull
    public String getFacetName(@NotNull Facet<?> facet) {
        if (facet == null) {
            FacetModelImpl.$$$reportNull$$$0(4);
        }
        String string = this.myFacet2NewName.containsKey(facet) ? this.myFacet2NewName.get(facet) : facet.getName();
        if (string == null) {
            FacetModelImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public void addListener(@NotNull ModifiableFacetModel.Listener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            FacetModelImpl.$$$reportNull$$$0(6);
        }
        if (parentDisposable == null) {
            FacetModelImpl.$$$reportNull$$$0(7);
        }
        this.myListeners.add(listener2);
        Disposer.register(parentDisposable, () -> this.myListeners.remove(listener2));
    }

    @Override
    protected void facetsChanged() {
        super.facetsChanged();
        for (ModifiableFacetModel.Listener each : this.myListeners) {
            each.onChanged();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/facet/impl/FacetModelImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/facet/impl/FacetModelImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFacets";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacetName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "replaceFacet";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFacetName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

