/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl;

import com.intellij.configurationStore.ComponentSerializationUtil;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import java.util.Arrays;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacetUtil {
    public static <F extends Facet> F addFacet(Module module2, FacetType<F, ?> type) {
        ModifiableFacetModel model = FacetManager.getInstance(module2).createModifiableModel();
        Object facet = FacetUtil.createFacet(module2, type);
        ApplicationManager.getApplication().runWriteAction(() -> {
            model.addFacet((Facet<?>)facet);
            model.commit();
        });
        return facet;
    }

    private static <F extends Facet, C extends FacetConfiguration> F createFacet(Module module2, FacetType<F, C> type) {
        return FacetManager.getInstance(module2).createFacet(type, type.getPresentableName(), type.createDefaultConfiguration(), (Facet<?>)null);
    }

    public static void deleteFacet(Facet facet) {
        WriteAction.runAndWait(() -> {
            if (!FacetUtil.isRegistered(facet)) {
                return;
            }
            ModifiableFacetModel model = FacetManager.getInstance(facet.getModule()).createModifiableModel();
            model.removeFacet(facet);
            model.commit();
        });
    }

    public static boolean isRegistered(Facet facet) {
        return Arrays.asList(FacetManager.getInstance(facet.getModule()).getAllFacets()).contains(facet);
    }

    public static void loadFacetConfiguration(@NotNull FacetConfiguration configuration, @Nullable Element config2) throws InvalidDataException {
        if (configuration == null) {
            FacetUtil.$$$reportNull$$$0(0);
        }
        if (config2 != null) {
            if (configuration instanceof PersistentStateComponent) {
                ComponentSerializationUtil.loadComponentState((PersistentStateComponent)((Object)configuration), config2);
            } else {
                configuration.readExternal(config2);
            }
        }
    }

    @NotNull
    public static Element saveFacetConfiguration(@NotNull FacetConfiguration configuration) {
        if (configuration == null) {
            FacetUtil.$$$reportNull$$$0(1);
        }
        if (configuration instanceof PersistentStateComponent) {
            Object state = ((PersistentStateComponent)((Object)configuration)).getState();
            if (state instanceof Element) {
                Element element2 = (Element)state;
                if (element2 == null) {
                    FacetUtil.$$$reportNull$$$0(2);
                }
                return element2;
            }
            Element result2 = XmlSerializer.serialize(state);
            Element element3 = result2 == null ? new Element("configuration") : result2;
            if (element3 == null) {
                FacetUtil.$$$reportNull$$$0(3);
            }
            return element3;
        }
        Element config2 = new Element("configuration");
        configuration.writeExternal(config2);
        Element element4 = config2;
        if (element4 == null) {
            FacetUtil.$$$reportNull$$$0(4);
        }
        return element4;
    }

    @ApiStatus.Internal
    @Nullable
    public static Element saveFacetConfiguration(Facet<?> facet) {
        Element config2;
        try {
            Object configuration = facet.getConfiguration();
            config2 = FacetUtil.saveFacetConfiguration(configuration);
            if (facet instanceof JDOMExternalizable) {
                ((JDOMExternalizable)((Object)facet)).writeExternal(config2);
            }
        }
        catch (WriteExternalException e) {
            return null;
        }
        return config2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/facet/impl/FacetUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/facet/impl/FacetUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "saveFacetConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadFacetConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "saveFacetConfiguration";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

