/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl;

import com.intellij.ProjectTopics;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerAdapter;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.ProjectWideFacetListener;
import com.intellij.facet.ProjectWideFacetListenersRegistry;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class ProjectWideFacetListenersRegistryImpl
extends ProjectWideFacetListenersRegistry {
    private final Map<FacetTypeId<?>, EventDispatcher<ProjectWideFacetListener>> myDispatchers;
    private final Map<FacetTypeId<?>, Map<Facet<?>, Boolean>> myFacetsByType;
    private final Map<Module, MessageBusConnection> myModule2Connection;
    private final FacetManagerAdapter myFacetListener;
    private final EventDispatcher<ProjectWideFacetListener> myAllFacetsListener;

    public ProjectWideFacetListenersRegistryImpl(@NotNull Project project2) {
        if (project2 == null) {
            ProjectWideFacetListenersRegistryImpl.$$$reportNull$$$0(0);
        }
        this.myDispatchers = new HashMap();
        this.myFacetsByType = new HashMap();
        this.myModule2Connection = new HashMap<Module, MessageBusConnection>();
        this.myAllFacetsListener = EventDispatcher.create(ProjectWideFacetListener.class);
        this.myFacetListener = new MyFacetManagerAdapter();
        project2.getMessageBus().connect().subscribe(ProjectTopics.MODULES, new ModuleListener(){

            @Override
            public void moduleAdded(@NotNull Project project2, @NotNull Module module2) {
                if (project2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (module2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                ProjectWideFacetListenersRegistryImpl.this.onModuleAdded(module2);
            }

            @Override
            public void beforeModuleRemoved(@NotNull Project project2, @NotNull Module module2) {
                Facet<?>[] allFacets;
                if (project2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (module2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                for (Facet<?> facet : allFacets = FacetManager.getInstance(module2).getAllFacets()) {
                    ProjectWideFacetListenersRegistryImpl.this.onFacetRemoved(facet, true);
                }
            }

            @Override
            public void moduleRemoved(@NotNull Project project2, @NotNull Module module2) {
                if (project2 == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (module2 == null) {
                    1.$$$reportNull$$$0(5);
                }
                ProjectWideFacetListenersRegistryImpl.this.onModuleRemoved(module2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "module";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/facet/impl/ProjectWideFacetListenersRegistryImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "moduleAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeModuleRemoved";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "moduleRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        for (Module module2 : ModuleManager.getInstance(project2).getModules()) {
            this.onModuleAdded(module2);
        }
    }

    private void onModuleRemoved(Module module2) {
        Facet<?>[] facets2;
        MessageBusConnection connection = this.myModule2Connection.remove(module2);
        if (connection != null) {
            connection.disconnect();
        }
        FacetManager facetManager = FacetManager.getInstance(module2);
        for (Facet<?> facet : facets2 = facetManager.getAllFacets()) {
            this.onFacetRemoved(facet, false);
        }
    }

    private void onModuleAdded(Module module2) {
        Facet<?>[] facets2;
        FacetManager facetManager = FacetManager.getInstance(module2);
        for (Facet<?> facet : facets2 = facetManager.getAllFacets()) {
            this.onFacetAdded(facet);
        }
        MessageBusConnection connection = module2.getMessageBus().connect();
        this.myModule2Connection.put(module2, connection);
        connection.subscribe(FacetManager.FACETS_TOPIC, this.myFacetListener);
    }

    private void onFacetRemoved(@NotNull Facet<?> facet, boolean before) {
        EventDispatcher<ProjectWideFacetListener> dispatcher;
        boolean lastFacet;
        FacetTypeId typeId;
        Map<Facet<?>, Boolean> facets2;
        if (facet == null) {
            ProjectWideFacetListenersRegistryImpl.$$$reportNull$$$0(1);
        }
        if ((facets2 = this.myFacetsByType.get(typeId = facet.getTypeId())) != null) {
            facets2.remove(facet);
            lastFacet = facets2.isEmpty();
            if (lastFacet) {
                this.myFacetsByType.remove(typeId);
            }
        } else {
            lastFacet = true;
        }
        if ((dispatcher = this.myDispatchers.get(typeId)) != null) {
            if (before) {
                dispatcher.getMulticaster().beforeFacetRemoved(facet);
            } else {
                dispatcher.getMulticaster().facetRemoved(facet);
                if (lastFacet) {
                    dispatcher.getMulticaster().allFacetsRemoved();
                }
            }
        }
        if (before) {
            this.getAllFacetsMulticaster().beforeFacetRemoved(facet);
        } else {
            this.getAllFacetsMulticaster().facetRemoved(facet);
            if (this.myFacetsByType.isEmpty()) {
                this.getAllFacetsMulticaster().allFacetsRemoved();
            }
        }
    }

    private ProjectWideFacetListener<Facet<?>> getAllFacetsMulticaster() {
        return this.myAllFacetsListener.getMulticaster();
    }

    private void onFacetAdded(@NotNull Facet<?> facet) {
        if (facet == null) {
            ProjectWideFacetListenersRegistryImpl.$$$reportNull$$$0(2);
        }
        boolean firstFacet = this.myFacetsByType.isEmpty();
        FacetTypeId typeId = facet.getTypeId();
        Map<Facet<Object>, Boolean> facets2 = this.myFacetsByType.get(typeId);
        if (facets2 == null) {
            facets2 = ContainerUtil.createWeakMap();
            this.myFacetsByType.put(typeId, facets2);
        }
        boolean firstFacetOfType = facets2.isEmpty();
        facets2.put(facet, true);
        if (firstFacet) {
            this.getAllFacetsMulticaster().firstFacetAdded();
        }
        this.getAllFacetsMulticaster().facetAdded(facet);
        EventDispatcher<ProjectWideFacetListener> dispatcher = this.myDispatchers.get(typeId);
        if (dispatcher != null) {
            if (firstFacetOfType) {
                dispatcher.getMulticaster().firstFacetAdded();
            }
            dispatcher.getMulticaster().facetAdded(facet);
        }
    }

    private void onFacetChanged(@NotNull Facet<?> facet) {
        EventDispatcher<ProjectWideFacetListener> dispatcher;
        if (facet == null) {
            ProjectWideFacetListenersRegistryImpl.$$$reportNull$$$0(3);
        }
        if ((dispatcher = this.myDispatchers.get(facet.getTypeId())) != null) {
            dispatcher.getMulticaster().facetConfigurationChanged(facet);
        }
        this.getAllFacetsMulticaster().facetConfigurationChanged(facet);
    }

    @Override
    public <F extends Facet<?>> void registerListener(@NotNull FacetTypeId<F> typeId, @NotNull ProjectWideFacetListener<? extends F> listener2) {
        EventDispatcher<ProjectWideFacetListener> dispatcher;
        if (typeId == null) {
            ProjectWideFacetListenersRegistryImpl.$$$reportNull$$$0(4);
        }
        if (listener2 == null) {
            ProjectWideFacetListenersRegistryImpl.$$$reportNull$$$0(5);
        }
        if ((dispatcher = this.myDispatchers.get(typeId)) == null) {
            dispatcher = EventDispatcher.create(ProjectWideFacetListener.class);
            this.myDispatchers.put(typeId, dispatcher);
        }
        dispatcher.addListener(listener2);
    }

    @Override
    public <F extends Facet<?>> void unregisterListener(@NotNull FacetTypeId<F> typeId, @NotNull ProjectWideFacetListener<? extends F> listener2) {
        EventDispatcher<ProjectWideFacetListener> dispatcher;
        if (typeId == null) {
            ProjectWideFacetListenersRegistryImpl.$$$reportNull$$$0(6);
        }
        if (listener2 == null) {
            ProjectWideFacetListenersRegistryImpl.$$$reportNull$$$0(7);
        }
        if ((dispatcher = this.myDispatchers.get(typeId)) != null) {
            dispatcher.removeListener(listener2);
        }
    }

    @Override
    public <F extends Facet<?>> void registerListener(final @NotNull FacetTypeId<F> typeId, final @NotNull ProjectWideFacetListener<? extends F> listener2, @NotNull Disposable parentDisposable) {
        if (typeId == null) {
            ProjectWideFacetListenersRegistryImpl.$$$reportNull$$$0(8);
        }
        if (listener2 == null) {
            ProjectWideFacetListenersRegistryImpl.$$$reportNull$$$0(9);
        }
        if (parentDisposable == null) {
            ProjectWideFacetListenersRegistryImpl.$$$reportNull$$$0(10);
        }
        this.registerListener(typeId, listener2);
        Disposer.register(parentDisposable, new Disposable(){

            @Override
            public void dispose() {
                ProjectWideFacetListenersRegistryImpl.this.unregisterListener(typeId, listener2);
            }
        });
    }

    @Override
    public void registerListener(@NotNull ProjectWideFacetListener<Facet> listener2) {
        if (listener2 == null) {
            ProjectWideFacetListenersRegistryImpl.$$$reportNull$$$0(11);
        }
        this.myAllFacetsListener.addListener(listener2);
    }

    @Override
    public void unregisterListener(@NotNull ProjectWideFacetListener<Facet> listener2) {
        if (listener2 == null) {
            ProjectWideFacetListenersRegistryImpl.$$$reportNull$$$0(12);
        }
        this.myAllFacetsListener.removeListener(listener2);
    }

    @Override
    public void registerListener(@NotNull ProjectWideFacetListener<Facet> listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            ProjectWideFacetListenersRegistryImpl.$$$reportNull$$$0(13);
        }
        if (parentDisposable == null) {
            ProjectWideFacetListenersRegistryImpl.$$$reportNull$$$0(14);
        }
        this.myAllFacetsListener.addListener(listener2, parentDisposable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeId";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/facet/impl/ProjectWideFacetListenersRegistryImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "onFacetRemoved";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "onFacetAdded";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "onFacetChanged";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "registerListener";
                break;
            }
            case 6: 
            case 7: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "unregisterListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyFacetManagerAdapter
    extends FacetManagerAdapter {
        private MyFacetManagerAdapter() {
        }

        @Override
        public void facetAdded(@NotNull Facet facet) {
            if (facet == null) {
                MyFacetManagerAdapter.$$$reportNull$$$0(0);
            }
            ProjectWideFacetListenersRegistryImpl.this.onFacetAdded(facet);
        }

        @Override
        public void beforeFacetRemoved(@NotNull Facet facet) {
            if (facet == null) {
                MyFacetManagerAdapter.$$$reportNull$$$0(1);
            }
            ProjectWideFacetListenersRegistryImpl.this.onFacetRemoved(facet, true);
        }

        @Override
        public void facetRemoved(@NotNull Facet facet) {
            if (facet == null) {
                MyFacetManagerAdapter.$$$reportNull$$$0(2);
            }
            ProjectWideFacetListenersRegistryImpl.this.onFacetRemoved(facet, false);
        }

        @Override
        public void facetConfigurationChanged(@NotNull Facet facet) {
            if (facet == null) {
                MyFacetManagerAdapter.$$$reportNull$$$0(3);
            }
            ProjectWideFacetListenersRegistryImpl.this.onFacetChanged(facet);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "facet";
            objectArray2[1] = "com/intellij/facet/impl/ProjectWideFacetListenersRegistryImpl$MyFacetManagerAdapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "facetAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeFacetRemoved";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "facetRemoved";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "facetConfigurationChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

