/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.pointers;

import com.intellij.ProjectTopics;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerAdapter;
import com.intellij.facet.impl.FacetUtil;
import com.intellij.facet.impl.pointers.FacetPointerImpl;
import com.intellij.facet.pointers.FacetPointer;
import com.intellij.facet.pointers.FacetPointerListener;
import com.intellij.facet.pointers.FacetPointersManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Function;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class FacetPointersManagerImpl
extends FacetPointersManager {
    private final Map<String, FacetPointerImpl> myPointers;
    private final Map<Class<? extends Facet>, EventDispatcher<FacetPointerListener>> myDispatchers;
    @NotNull
    private final Project myProject;

    public FacetPointersManagerImpl(@NotNull Project project2) {
        if (project2 == null) {
            FacetPointersManagerImpl.$$$reportNull$$$0(0);
        }
        this.myPointers = new HashMap<String, FacetPointerImpl>();
        this.myDispatchers = new HashMap<Class<? extends Facet>, EventDispatcher<FacetPointerListener>>();
        this.myProject = project2;
        this.initComponent();
    }

    @Override
    public <F extends Facet> FacetPointer<F> create(F facet) {
        String id2 = FacetPointersManagerImpl.constructId(facet);
        FacetPointerImpl<F> pointer = this.myPointers.get(id2);
        if (pointer == null) {
            if (!FacetUtil.isRegistered(facet)) {
                return this.create(id2);
            }
            pointer = new FacetPointerImpl<F>(this, facet);
            this.myPointers.put(id2, pointer);
        }
        return pointer;
    }

    @Override
    public <F extends Facet> FacetPointer<F> create(String id2) {
        FacetPointerImpl pointer = this.myPointers.get(id2);
        if (pointer == null) {
            pointer = new FacetPointerImpl(this, id2);
            this.myPointers.put(id2, pointer);
        }
        return pointer;
    }

    <F extends Facet> void dispose(FacetPointer<F> pointer) {
        this.myPointers.remove(pointer.getId());
    }

    private void initComponent() {
        MessageBusConnection connection = this.myProject.getMessageBus().connect();
        connection.subscribe(ProjectTopics.MODULES, new ModuleListener(){

            @Override
            public void moduleAdded(@NotNull Project project2, @NotNull Module module2) {
                if (project2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (module2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                FacetPointersManagerImpl.this.refreshPointers(module2);
            }

            @Override
            public void modulesRenamed(@NotNull Project project2, @NotNull List<Module> modules, @NotNull Function<Module, String> oldNameProvider) {
                if (project2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (modules == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (oldNameProvider == null) {
                    1.$$$reportNull$$$0(4);
                }
                for (Module module2 : modules) {
                    FacetPointersManagerImpl.this.refreshPointers(module2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "module";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "modules";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "oldNameProvider";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/facet/impl/pointers/FacetPointersManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "moduleAdded";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "modulesRenamed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(FacetManager.FACETS_TOPIC, new FacetManagerAdapter(){

            @Override
            public void facetAdded(@NotNull Facet facet) {
                if (facet == null) {
                    2.$$$reportNull$$$0(0);
                }
                FacetPointersManagerImpl.this.refreshPointers(facet.getModule());
            }

            @Override
            public void beforeFacetRenamed(@NotNull Facet facet) {
                FacetPointerImpl pointer;
                if (facet == null) {
                    2.$$$reportNull$$$0(1);
                }
                if ((pointer = (FacetPointerImpl)FacetPointersManagerImpl.this.myPointers.get(FacetPointersManager.constructId(facet))) != null) {
                    pointer.refresh();
                }
            }

            @Override
            public void facetRenamed(@NotNull Facet facet, @NotNull String oldName) {
                if (facet == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (oldName == null) {
                    2.$$$reportNull$$$0(3);
                }
                FacetPointersManagerImpl.this.refreshPointers(facet.getModule());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "facet";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "oldName";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/facet/impl/pointers/FacetPointersManagerImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeFacetRenamed";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetRenamed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        for (Module module2 : ModuleManager.getInstance(this.myProject).getModules()) {
            this.refreshPointers(module2);
        }
    }

    private void refreshPointers(@NotNull Module module2) {
        if (module2 == null) {
            FacetPointersManagerImpl.$$$reportNull$$$0(1);
        }
        ArrayList<Pair<FacetPointerImpl, String>> changed2 = new ArrayList<Pair<FacetPointerImpl, String>>();
        for (FacetPointerImpl facetPointerImpl : this.myPointers.values()) {
            String oldId = facetPointerImpl.getId();
            facetPointerImpl.refresh();
            if (oldId.equals(facetPointerImpl.getId())) continue;
            changed2.add(Pair.create(facetPointerImpl, oldId));
        }
        for (Pair pair : changed2) {
            Class facetClass;
            FacetPointerImpl pointer = (FacetPointerImpl)pair.getFirst();
            Object facet = pointer.getFacet();
            Class clazz = facetClass = facet != null ? facet.getClass() : Facet.class;
            while (facetClass != Object.class) {
                EventDispatcher<FacetPointerListener> dispatcher = this.myDispatchers.get(facetClass);
                if (dispatcher != null) {
                    dispatcher.getMulticaster().pointerIdChanged(pointer, (String)pair.getSecond());
                }
                facetClass = facetClass.getSuperclass();
            }
        }
    }

    public boolean isRegistered(FacetPointer<?> pointer) {
        return this.myPointers.containsKey(pointer.getId());
    }

    @Override
    public void addListener(FacetPointerListener<Facet> listener2) {
        this.addListener(Facet.class, listener2);
    }

    @Override
    public void removeListener(FacetPointerListener<Facet> listener2) {
        this.removeListener(Facet.class, listener2);
    }

    @Override
    public void addListener(FacetPointerListener<Facet> listener2, Disposable parentDisposable) {
        this.addListener(Facet.class, listener2, parentDisposable);
    }

    @Override
    public <F extends Facet> void addListener(final Class<F> facetClass, final FacetPointerListener<F> listener2, Disposable parentDisposable) {
        this.addListener(facetClass, listener2);
        Disposer.register(parentDisposable, new Disposable(){

            @Override
            public void dispose() {
                FacetPointersManagerImpl.this.removeListener(facetClass, listener2);
            }
        });
    }

    @Override
    public <F extends Facet> void addListener(Class<F> facetClass, FacetPointerListener<F> listener2) {
        EventDispatcher<FacetPointerListener> dispatcher = this.myDispatchers.get(facetClass);
        if (dispatcher == null) {
            dispatcher = EventDispatcher.create(FacetPointerListener.class);
            this.myDispatchers.put(facetClass, dispatcher);
        }
        dispatcher.addListener(listener2);
    }

    @Override
    public <F extends Facet> void removeListener(Class<F> facetClass, FacetPointerListener<F> listener2) {
        EventDispatcher<FacetPointerListener> dispatcher = this.myDispatchers.get(facetClass);
        if (dispatcher != null) {
            dispatcher.removeListener(listener2);
        }
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            FacetPointersManagerImpl.$$$reportNull$$$0(2);
        }
        return project2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/facet/impl/pointers/FacetPointersManagerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/facet/impl/pointers/FacetPointersManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "refreshPointers";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

