/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.ui.libraries;

import com.intellij.facet.ui.libraries.RemoteRepositoryInfo;
import com.intellij.openapi.util.Comparing;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryDownloadInfo {
    @Nullable
    private final RemoteRepositoryInfo myRemoteRepository;
    private final String myRelativeDownloadUrl;
    private final String myFileNamePrefix;
    private final String myFileNameSuffix;
    @Nullable
    private final String myPresentableUrl;

    public LibraryDownloadInfo(@NotNull RemoteRepositoryInfo remoteRepository, @NotNull @NonNls String relativeDownloadUrl, @NotNull @NonNls String fileNamePrefix, @NotNull @NonNls String fileNameSuffix) {
        if (remoteRepository == null) {
            LibraryDownloadInfo.$$$reportNull$$$0(0);
        }
        if (relativeDownloadUrl == null) {
            LibraryDownloadInfo.$$$reportNull$$$0(1);
        }
        if (fileNamePrefix == null) {
            LibraryDownloadInfo.$$$reportNull$$$0(2);
        }
        if (fileNameSuffix == null) {
            LibraryDownloadInfo.$$$reportNull$$$0(3);
        }
        this.myRemoteRepository = remoteRepository;
        this.myRelativeDownloadUrl = relativeDownloadUrl;
        this.myFileNamePrefix = fileNamePrefix;
        this.myFileNameSuffix = fileNameSuffix;
        this.myPresentableUrl = null;
    }

    public LibraryDownloadInfo(@NotNull String downloadUrl, @Nullable String presentableUrl, @NotNull @NonNls String fileNamePrefix, @NotNull @NonNls String fileNameSuffix) {
        if (downloadUrl == null) {
            LibraryDownloadInfo.$$$reportNull$$$0(4);
        }
        if (fileNamePrefix == null) {
            LibraryDownloadInfo.$$$reportNull$$$0(5);
        }
        if (fileNameSuffix == null) {
            LibraryDownloadInfo.$$$reportNull$$$0(6);
        }
        this.myRemoteRepository = null;
        this.myRelativeDownloadUrl = downloadUrl;
        this.myFileNamePrefix = fileNamePrefix;
        this.myFileNameSuffix = fileNameSuffix;
        this.myPresentableUrl = presentableUrl != null ? presentableUrl : downloadUrl;
    }

    public LibraryDownloadInfo(@NotNull String downloadUrl, @Nullable String presentableUrl, @NotNull @NonNls String fileNamePrefix) {
        if (downloadUrl == null) {
            LibraryDownloadInfo.$$$reportNull$$$0(7);
        }
        if (fileNamePrefix == null) {
            LibraryDownloadInfo.$$$reportNull$$$0(8);
        }
        this(downloadUrl, presentableUrl, fileNamePrefix, ".jar");
    }

    public LibraryDownloadInfo(@NotNull String downloadUrl, @NotNull @NonNls String fileNamePrefix) {
        if (downloadUrl == null) {
            LibraryDownloadInfo.$$$reportNull$$$0(9);
        }
        if (fileNamePrefix == null) {
            LibraryDownloadInfo.$$$reportNull$$$0(10);
        }
        this(downloadUrl, null, fileNamePrefix);
    }

    @NotNull
    public String getDownloadUrl() {
        String string = this.myRemoteRepository != null ? this.getDownloadUrl(this.myRemoteRepository.getDefaultMirror()) : this.myRelativeDownloadUrl;
        if (string == null) {
            LibraryDownloadInfo.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public String getDownloadUrl(String mirror) {
        String string = mirror + this.myRelativeDownloadUrl;
        if (string == null) {
            LibraryDownloadInfo.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Nullable
    public RemoteRepositoryInfo getRemoteRepository() {
        return this.myRemoteRepository;
    }

    @NotNull
    public String getFileNamePrefix() {
        String string = this.myFileNamePrefix;
        if (string == null) {
            LibraryDownloadInfo.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public String getFileNameSuffix() {
        String string = this.myFileNameSuffix;
        if (string == null) {
            LibraryDownloadInfo.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public String getFileName() {
        String string = this.myFileNamePrefix + this.myFileNameSuffix;
        if (string == null) {
            LibraryDownloadInfo.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public String getPresentableUrl() {
        String string = this.myPresentableUrl != null ? this.myPresentableUrl : (this.myRemoteRepository != null ? this.myRemoteRepository.getDefaultMirror() : this.myRelativeDownloadUrl);
        if (string == null) {
            LibraryDownloadInfo.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public String getPresentableUrl(String mirror) {
        String string = this.myPresentableUrl != null ? this.myPresentableUrl : mirror;
        if (string == null) {
            LibraryDownloadInfo.$$$reportNull$$$0(17);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LibraryDownloadInfo that = (LibraryDownloadInfo)o;
        if (!this.myFileNamePrefix.equals(that.myFileNamePrefix)) {
            return false;
        }
        if (!this.myFileNameSuffix.equals(that.myFileNameSuffix)) {
            return false;
        }
        if (!Comparing.equal(this.myPresentableUrl, that.myPresentableUrl)) {
            return false;
        }
        if (!this.myRelativeDownloadUrl.equals(that.myRelativeDownloadUrl)) {
            return false;
        }
        return Comparing.equal(this.myRemoteRepository, that.myRemoteRepository);
    }

    public int hashCode() {
        int result2 = this.myRemoteRepository != null ? this.myRemoteRepository.hashCode() : 0;
        result2 = 31 * result2 + (this.myRelativeDownloadUrl != null ? this.myRelativeDownloadUrl.hashCode() : 0);
        result2 = 31 * result2 + (this.myFileNamePrefix != null ? this.myFileNamePrefix.hashCode() : 0);
        result2 = 31 * result2 + (this.myFileNameSuffix != null ? this.myFileNameSuffix.hashCode() : 0);
        result2 = 31 * result2 + (this.myPresentableUrl != null ? this.myPresentableUrl.hashCode() : 0);
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteRepository";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeDownloadUrl";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNamePrefix";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNameSuffix";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloadUrl";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/facet/ui/libraries/LibraryDownloadInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/facet/ui/libraries/LibraryDownloadInfo";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDownloadUrl";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNamePrefix";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNameSuffix";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

