/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.featureStatistics;

import com.intellij.featureStatistics.FeatureStatisticsBundle;
import com.intellij.featureStatistics.GroupDescriptor;
import com.intellij.featureStatistics.ProductivityFeaturesProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FeatureDescriptor {
    @NotNull
    private String myId;
    private String myGroupId;
    @NotNull
    private String myTipFileName;
    @NotNull
    private String myDisplayName;
    private int myDaysBeforeFirstShowUp;
    private int myDaysBetweenSuccessiveShowUps;
    private Set<String> myDependencies;
    private int myMinUsageCount;
    private int myUsageCount;
    private long myLastTimeShown;
    private long myLastTimeUsed;
    private int myShownCount;
    private ProductivityFeaturesProvider myProvider;
    @NonNls
    private static final String ATTRIBUTE_COUNT = "count";
    @NonNls
    private static final String ATTRIBUTE_LAST_SHOWN = "last-shown";
    @NonNls
    private static final String ATTRIBUTE_LAST_USED = "last-used";
    @NonNls
    private static final String ATTRIBUTE_SHOWN_COUNT = "shown-count";
    @NonNls
    private static final String ATTRIBUTE_ID = "id";
    @NonNls
    private static final String ATTRIBUTE_TIP_FILE = "tip-file";
    @NonNls
    private static final String ATTRIBUTE_FIRST_SHOW = "first-show";
    @NonNls
    private static final String ATTRIBUTE_SUCCESSIVE_SHOW = "successive-show";
    @NonNls
    private static final String ATTRIBUTE_MIN_USAGE_COUNT = "min-usage-count";
    @NonNls
    private static final String ELEMENT_DEPENDENCY = "dependency";

    FeatureDescriptor(GroupDescriptor group) {
        this.myGroupId = group.getId();
    }

    FeatureDescriptor(String id2) {
        this.myId = id2;
    }

    FeatureDescriptor(String id2, @NonNls String tipFileName, String displayName) {
        this.myId = id2;
        this.myTipFileName = tipFileName;
        this.myDisplayName = displayName;
    }

    public FeatureDescriptor(@NonNls String id2, @NonNls String groupId2, @NonNls String tipFileName, String displayName, int daysBeforeFirstShowUp, int daysBetweenSuccessiveShowUps, Set<String> dependencies, int minUsageCount, ProductivityFeaturesProvider provider) {
        this.myId = id2;
        this.myGroupId = groupId2;
        this.myTipFileName = tipFileName;
        this.myDisplayName = displayName;
        this.myDaysBeforeFirstShowUp = daysBeforeFirstShowUp;
        this.myDaysBetweenSuccessiveShowUps = daysBetweenSuccessiveShowUps;
        this.myDependencies = dependencies;
        this.myMinUsageCount = minUsageCount;
        this.myProvider = provider;
    }

    void readExternal(Element element2) {
        this.myId = element2.getAttributeValue(ATTRIBUTE_ID);
        this.myTipFileName = element2.getAttributeValue(ATTRIBUTE_TIP_FILE);
        this.myDisplayName = FeatureStatisticsBundle.message(this.myId, new Object[0]);
        this.myDaysBeforeFirstShowUp = StringUtil.parseInt(element2.getAttributeValue(ATTRIBUTE_FIRST_SHOW), 1);
        this.myDaysBetweenSuccessiveShowUps = StringUtil.parseInt(element2.getAttributeValue(ATTRIBUTE_SUCCESSIVE_SHOW), 3);
        String minUsageCount = element2.getAttributeValue(ATTRIBUTE_MIN_USAGE_COUNT);
        this.myMinUsageCount = minUsageCount == null ? 1 : Integer.parseInt(minUsageCount);
        List<Element> dependencies = element2.getChildren(ELEMENT_DEPENDENCY);
        if (dependencies != null && !dependencies.isEmpty()) {
            this.myDependencies = new HashSet<String>();
            Iterator<Element> iterator2 = dependencies.iterator();
            while (iterator2.hasNext()) {
                Element dependency;
                Element dependencyElement = dependency = iterator2.next();
                this.myDependencies.add(dependencyElement.getAttributeValue(ATTRIBUTE_ID));
            }
        }
    }

    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            FeatureDescriptor.$$$reportNull$$$0(0);
        }
        return string;
    }

    public String getGroupId() {
        return this.myGroupId;
    }

    @NotNull
    public String getTipFileName() {
        String string = this.myTipFileName;
        if (string == null) {
            FeatureDescriptor.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = this.myDisplayName;
        if (string == null) {
            FeatureDescriptor.$$$reportNull$$$0(2);
        }
        return string;
    }

    public int getUsageCount() {
        return this.myUsageCount;
    }

    public Class<? extends ProductivityFeaturesProvider> getProvider() {
        if (this.myProvider == null) {
            return null;
        }
        return this.myProvider.getClass();
    }

    void triggerUsed() {
        long current2 = System.currentTimeMillis();
        long delta = this.myUsageCount > 0 ? current2 - Math.max(this.myLastTimeUsed, ApplicationManager.getApplication().getStartTime()) : 0L;
        this.myLastTimeUsed = current2;
        ++this.myUsageCount;
    }

    public boolean isUnused() {
        return this.myUsageCount < this.myMinUsageCount;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("id = [");
        buffer.append(this.myId);
        buffer.append("], displayName = [");
        buffer.append(this.myDisplayName);
        buffer.append("], groupId = [");
        buffer.append(this.myGroupId);
        buffer.append("], usageCount = [");
        buffer.append(this.myUsageCount);
        buffer.append("]");
        return buffer.toString();
    }

    public int getDaysBeforeFirstShowUp() {
        return this.myDaysBeforeFirstShowUp;
    }

    public int getDaysBetweenSuccessiveShowUps() {
        return this.myDaysBetweenSuccessiveShowUps;
    }

    public int getMinUsageCount() {
        return this.myMinUsageCount;
    }

    public long getLastTimeShown() {
        return this.myLastTimeShown;
    }

    public String[] getDependencyFeatures() {
        if (this.myDependencies == null) {
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        return ArrayUtilRt.toStringArray(this.myDependencies);
    }

    void triggerShown() {
        this.myLastTimeShown = System.currentTimeMillis();
        ++this.myShownCount;
    }

    public long getLastTimeUsed() {
        return this.myLastTimeUsed;
    }

    public int getShownCount() {
        return this.myShownCount;
    }

    void copyStatistics(FeatureDescriptor statistics) {
        this.myUsageCount = statistics.getUsageCount();
        this.myLastTimeShown = statistics.getLastTimeShown();
        this.myLastTimeUsed = statistics.getLastTimeUsed();
        this.myShownCount = statistics.getShownCount();
    }

    void readStatistics(Element element2) {
        String count = element2.getAttributeValue(ATTRIBUTE_COUNT);
        String lastShown = element2.getAttributeValue(ATTRIBUTE_LAST_SHOWN);
        String lastUsed = element2.getAttributeValue(ATTRIBUTE_LAST_USED);
        String shownCount = element2.getAttributeValue(ATTRIBUTE_SHOWN_COUNT);
        this.myUsageCount = count == null ? 0 : Integer.parseInt(count);
        this.myLastTimeShown = lastShown == null ? 0L : Long.parseLong(lastShown);
        this.myLastTimeUsed = lastUsed == null ? 0L : Long.parseLong(lastUsed);
        this.myShownCount = shownCount == null ? 0 : Integer.parseInt(shownCount);
    }

    void writeStatistics(Element element2) {
        element2.setAttribute(ATTRIBUTE_COUNT, String.valueOf(this.getUsageCount()));
        element2.setAttribute(ATTRIBUTE_LAST_SHOWN, String.valueOf(this.getLastTimeShown()));
        element2.setAttribute(ATTRIBUTE_LAST_USED, String.valueOf(this.getLastTimeUsed()));
        element2.setAttribute(ATTRIBUTE_SHOWN_COUNT, String.valueOf(this.getShownCount()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/featureStatistics/FeatureDescriptor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTipFileName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

