/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.featureStatistics;

import com.intellij.featureStatistics.ApplicabilityFilter;
import com.intellij.featureStatistics.FeatureDescriptor;
import com.intellij.featureStatistics.FeatureStatisticsBundle;
import com.intellij.featureStatistics.GroupDescriptor;
import com.intellij.featureStatistics.ProductivityFeaturesProvider;
import com.intellij.featureStatistics.ProductivityFeaturesRegistry;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ProductivityFeaturesRegistryImpl
extends ProductivityFeaturesRegistry {
    private static final Logger LOG = Logger.getInstance(ProductivityFeaturesRegistry.class);
    private final Map<String, FeatureDescriptor> myFeatures = new HashMap<String, FeatureDescriptor>();
    private final Map<String, GroupDescriptor> myGroups = new HashMap<String, GroupDescriptor>();
    private final List<Pair<String, ApplicabilityFilter>> myApplicabilityFilters = new ArrayList<Pair<String, ApplicabilityFilter>>();
    private boolean myAdditionalFeaturesLoaded = false;
    @NonNls
    public static final String WELCOME = "features.welcome";
    @NonNls
    private static final String TAG_FILTER = "filter";
    @NonNls
    private static final String TAG_GROUP = "group";
    @NonNls
    private static final String TAG_FEATURE = "feature";
    @NonNls
    private static final String TODO_HTML_MARKER = "todo.html";
    @NonNls
    private static final String CLASS_ATTR = "class";
    @NonNls
    private static final String PREFIX_ATTR = "prefix";

    public ProductivityFeaturesRegistryImpl() {
        this.reloadFromXml();
    }

    private void reloadFromXml() {
        try {
            this.readFromXml("/ProductivityFeaturesRegistry.xml");
        }
        catch (FileNotFoundException e) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.error(e);
            }
        }
        catch (Throwable e) {
            LOG.error(e);
        }
        try {
            this.readFromXml("/IdeSpecificFeatures.xml");
        }
        catch (FileNotFoundException e) {
        }
        catch (Throwable e) {
            LOG.error(e);
        }
    }

    private void readFromXml(@NotNull String path2) throws JDOMException, IOException {
        if (path2 == null) {
            ProductivityFeaturesRegistryImpl.$$$reportNull$$$0(0);
        }
        this.readFromXml(path2, ProductivityFeaturesRegistryImpl.class);
    }

    private void readFromXml(@NotNull String path2, @NotNull Class<?> clazz) throws JDOMException, IOException {
        if (path2 == null) {
            ProductivityFeaturesRegistryImpl.$$$reportNull$$$0(1);
        }
        if (clazz == null) {
            ProductivityFeaturesRegistryImpl.$$$reportNull$$$0(2);
        }
        Element root = JDOMUtil.load(clazz, path2);
        for (Element groupElement : root.getChildren(TAG_GROUP)) {
            this.readGroup(groupElement);
        }
        this.readFilters(root);
    }

    private void lazyLoadFromPluginsFeaturesProviders() {
        if (this.myAdditionalFeaturesLoaded) {
            return;
        }
        this.myAdditionalFeaturesLoaded = true;
        this.loadFeaturesFromProviders(ProductivityFeaturesProvider.EP_NAME.getExtensionList());
    }

    private void loadFeaturesFromProviders(@NotNull List<ProductivityFeaturesProvider> providers) {
        if (providers == null) {
            ProductivityFeaturesRegistryImpl.$$$reportNull$$$0(3);
        }
        for (ProductivityFeaturesProvider provider : providers) {
            ApplicabilityFilter[] applicabilityFilters;
            FeatureDescriptor[] featureDescriptorArray;
            for (String string : provider.getXmlFilesUrls()) {
                try {
                    this.readFromXml(string, provider.getClass());
                }
                catch (Exception e) {
                    LOG.error("Error while reading " + string + " from " + provider + ": " + e.getMessage());
                }
            }
            GroupDescriptor[] groupDescriptors = provider.getGroupDescriptors();
            if (groupDescriptors != null) {
                for (GroupDescriptor groupDescriptor : groupDescriptors) {
                    this.myGroups.put(groupDescriptor.getId(), groupDescriptor);
                }
            }
            if ((featureDescriptorArray = provider.getFeatureDescriptors()) != null) {
                for (FeatureDescriptor featureDescriptor : featureDescriptorArray) {
                    FeatureDescriptor featureLoadedStatistics = this.myFeatures.get(featureDescriptor.getId());
                    if (featureLoadedStatistics != null) {
                        featureDescriptor.copyStatistics(featureLoadedStatistics);
                    }
                    this.myFeatures.put(featureDescriptor.getId(), featureDescriptor);
                }
            }
            if ((applicabilityFilters = provider.getApplicabilityFilters()) == null) continue;
            for (ApplicabilityFilter applicabilityFilter : applicabilityFilters) {
                this.myApplicabilityFilters.add(Pair.create(applicabilityFilter.getPrefix(), applicabilityFilter));
            }
        }
    }

    private void readFilters(Element element2) {
        for (Element filterElement : element2.getChildren(TAG_FILTER)) {
            String className = filterElement.getAttributeValue(CLASS_ATTR);
            try {
                Class<?> klass = Class.forName(className);
                if (!ApplicabilityFilter.class.isAssignableFrom(klass)) {
                    LOG.error("filter class must implement com.intellij.featureStatistics.ApplicabilityFilter");
                    continue;
                }
                ApplicabilityFilter filter2 = (ApplicabilityFilter)klass.newInstance();
                this.myApplicabilityFilters.add(Pair.create(filterElement.getAttributeValue(PREFIX_ATTR), filter2));
            }
            catch (Exception e) {
                LOG.error("Cannot instantiate filter " + className, e);
            }
        }
    }

    private void readGroup(Element groupElement) {
        GroupDescriptor groupDescriptor = new GroupDescriptor();
        groupDescriptor.readExternal(groupElement);
        String groupId2 = groupDescriptor.getId();
        this.myGroups.put(groupId2, groupDescriptor);
        this.readFeatures(groupElement, groupDescriptor);
    }

    private void readFeatures(Element groupElement, GroupDescriptor groupDescriptor) {
        for (Element featureElement : groupElement.getChildren(TAG_FEATURE)) {
            FeatureDescriptor featureDescriptor = new FeatureDescriptor(groupDescriptor);
            featureDescriptor.readExternal(featureElement);
            if (TODO_HTML_MARKER.equals(featureDescriptor.getTipFileName())) continue;
            this.myFeatures.put(featureDescriptor.getId(), featureDescriptor);
        }
    }

    @Override
    @NotNull
    public Set<String> getFeatureIds() {
        this.lazyLoadFromPluginsFeaturesProviders();
        Set<String> set = this.myFeatures.keySet();
        if (set == null) {
            ProductivityFeaturesRegistryImpl.$$$reportNull$$$0(4);
        }
        return set;
    }

    @Override
    public FeatureDescriptor getFeatureDescriptor(@NotNull String id2) {
        if (id2 == null) {
            ProductivityFeaturesRegistryImpl.$$$reportNull$$$0(5);
        }
        this.lazyLoadFromPluginsFeaturesProviders();
        return this.getFeatureDescriptorEx(id2);
    }

    public FeatureDescriptor getFeatureDescriptorEx(@NotNull String id2) {
        if (id2 == null) {
            ProductivityFeaturesRegistryImpl.$$$reportNull$$$0(6);
        }
        if (WELCOME.equals(id2)) {
            return new FeatureDescriptor(WELCOME, "AdaptiveWelcome.html", FeatureStatisticsBundle.message("feature.statistics.welcome.tip.name", new Object[0]));
        }
        return this.myFeatures.get(id2);
    }

    @Override
    public GroupDescriptor getGroupDescriptor(@NotNull String id2) {
        if (id2 == null) {
            ProductivityFeaturesRegistryImpl.$$$reportNull$$$0(7);
        }
        this.lazyLoadFromPluginsFeaturesProviders();
        return this.myGroups.get(id2);
    }

    @Override
    public ApplicabilityFilter @NotNull [] getMatchingFilters(@NotNull String featureId) {
        if (featureId == null) {
            ProductivityFeaturesRegistryImpl.$$$reportNull$$$0(8);
        }
        this.lazyLoadFromPluginsFeaturesProviders();
        ArrayList<ApplicabilityFilter> filters = new ArrayList<ApplicabilityFilter>();
        for (Pair<String, ApplicabilityFilter> pair : this.myApplicabilityFilters) {
            if (!featureId.startsWith(pair.getFirst())) continue;
            filters.add(pair.getSecond());
        }
        ApplicabilityFilter[] applicabilityFilterArray = filters.toArray(new ApplicabilityFilter[0]);
        if (applicabilityFilterArray == null) {
            ProductivityFeaturesRegistryImpl.$$$reportNull$$$0(9);
        }
        return applicabilityFilterArray;
    }

    public String toString() {
        return super.toString() + "; myAdditionalFeaturesLoaded=" + this.myAdditionalFeaturesLoaded;
    }

    public void prepareForTest() {
        this.myAdditionalFeaturesLoaded = false;
        this.myFeatures.clear();
        this.myApplicabilityFilters.clear();
        this.myGroups.clear();
        this.reloadFromXml();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/featureStatistics/ProductivityFeaturesRegistryImpl";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/featureStatistics/ProductivityFeaturesRegistryImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFeatureIds";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getMatchingFilters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readFromXml";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadFeaturesFromProviders";
                break;
            }
            case 4: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFeatureDescriptor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFeatureDescriptorEx";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getGroupDescriptor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getMatchingFilters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

