/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.featureStatistics.fusCollectors;

import com.intellij.idea.Main;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.LicensingFacade;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EAPUsageCollector
extends ApplicationUsagesCollector {
    @NotNull
    public String getGroupId() {
        return "user.advanced.info";
    }

    public int getVersion() {
        return 3;
    }

    @NotNull
    public Set<MetricEvent> getMetrics() {
        return EAPUsageCollector.collectMetrics();
    }

    @NotNull
    private static Set<MetricEvent> collectMetrics() {
        block10: {
            HashSet<MetricEvent> hashSet;
            try {
                if (Main.isHeadless()) break block10;
                HashSet<MetricEvent> result2 = new HashSet<MetricEvent>();
                if (ApplicationInfoEx.getInstanceEx().isEAP()) {
                    result2.add(MetricEventFactoryKt.newMetric((String)"eap"));
                    result2.add(EAPUsageCollector.newBuildMetric("eap"));
                } else {
                    result2.add(MetricEventFactoryKt.newMetric((String)"release"));
                    result2.add(EAPUsageCollector.newBuildMetric("release"));
                }
                LicensingFacade facade = LicensingFacade.getInstance();
                if (facade != null) {
                    if (facade.isEvaluationLicense()) {
                        result2.add(MetricEventFactoryKt.newMetric((String)"evaluation"));
                        result2.add(EAPUsageCollector.newLicencingMetric("evaluation", facade.metadata));
                    } else if (!StringUtil.isEmpty(facade.getLicensedToMessage())) {
                        result2.add(MetricEventFactoryKt.newMetric((String)"license"));
                        result2.add(EAPUsageCollector.newLicencingMetric("license", facade.metadata));
                    }
                }
                hashSet = result2;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (hashSet == null) {
                EAPUsageCollector.$$$reportNull$$$0(0);
            }
            return hashSet;
        }
        Set<MetricEvent> set = Collections.emptySet();
        if (set == null) {
            EAPUsageCollector.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    private static MetricEvent newLicencingMetric(@NotNull String value2, @Nullable String metadata) {
        if (value2 == null) {
            EAPUsageCollector.$$$reportNull$$$0(2);
        }
        FeatureUsageData data2 = new FeatureUsageData();
        if (StringUtil.isNotEmpty(metadata)) {
            data2.addData("metadata", metadata);
        }
        MetricEvent metricEvent = MetricEventFactoryKt.newMetric((String)"licencing", (String)value2, (FeatureUsageData)data2);
        if (metricEvent == null) {
            EAPUsageCollector.$$$reportNull$$$0(3);
        }
        return metricEvent;
    }

    @NotNull
    private static MetricEvent newBuildMetric(@NotNull String value2) {
        if (value2 == null) {
            EAPUsageCollector.$$$reportNull$$$0(4);
        }
        MetricEvent metricEvent = MetricEventFactoryKt.newMetric((String)"build", (String)value2);
        if (metricEvent == null) {
            EAPUsageCollector.$$$reportNull$$$0(5);
        }
        return metricEvent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/featureStatistics/fusCollectors/EAPUsageCollector";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "collectMetrics";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/featureStatistics/fusCollectors/EAPUsageCollector";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "newLicencingMetric";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "newBuildMetric";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "newLicencingMetric";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "newBuildMetric";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

