/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.featureStatistics.fusCollectors;

import com.intellij.diagnostic.VMOptions;
import com.intellij.featureStatistics.fusCollectors.EventsIdentityThrottle;
import com.intellij.featureStatistics.fusCollectors.EventsRateThrottle;
import com.intellij.featureStatistics.fusCollectors.ThrowableDescription;
import com.intellij.internal.DebugAttachDetector;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LifecycleUsageTriggerCollector {
    private static final Logger LOG = Logger.getInstance(LifecycleUsageTriggerCollector.class);
    private static final String LIFECYCLE = "lifecycle";
    private static final EventsRateThrottle ourErrorsRateThrottle = new EventsRateThrottle(100, 300000L);
    private static final EventsIdentityThrottle ourErrorsIdentityThrottle = new EventsIdentityThrottle(50, 3600000L);

    public static void onIdeStart() {
        Application app = ApplicationManager.getApplication();
        FeatureUsageData data2 = new FeatureUsageData().addData("eap", app.isEAP());
        LifecycleUsageTriggerCollector.addIfTrue(data2, "test", StatisticsUploadAssistant.isTestStatisticsEnabled());
        LifecycleUsageTriggerCollector.addIfTrue(data2, "command_line", app.isCommandLine());
        LifecycleUsageTriggerCollector.addIfTrue(data2, "internal", app.isInternal());
        LifecycleUsageTriggerCollector.addIfTrue(data2, "headless", app.isHeadlessEnvironment());
        LifecycleUsageTriggerCollector.addIfTrue(data2, "debug_agent", DebugAttachDetector.isDebugEnabled());
        FUCounterUsageLogger.getInstance().logEvent(LIFECYCLE, "ide.start", data2);
    }

    private static void addIfTrue(@NotNull FeatureUsageData data2, @NotNull String key, boolean value2) {
        if (data2 == null) {
            LifecycleUsageTriggerCollector.$$$reportNull$$$0(0);
        }
        if (key == null) {
            LifecycleUsageTriggerCollector.$$$reportNull$$$0(1);
        }
        if (value2) {
            data2.addData(key, true);
        }
    }

    public static void onIdeClose(boolean restart) {
        FeatureUsageData data2 = new FeatureUsageData().addData("restart", restart);
        FUCounterUsageLogger.getInstance().logEvent(LIFECYCLE, "ide.close", data2);
    }

    public static void onProjectOpenFinished(@NotNull Project project2, long time) {
        if (project2 == null) {
            LifecycleUsageTriggerCollector.$$$reportNull$$$0(2);
        }
        FeatureUsageData data2 = new FeatureUsageData().addProject(project2).addData("duration_ms", time);
        FUCounterUsageLogger.getInstance().logEvent(LIFECYCLE, "project.opening.finished", data2);
    }

    public static void onProjectOpened(@NotNull Project project2) {
        if (project2 == null) {
            LifecycleUsageTriggerCollector.$$$reportNull$$$0(3);
        }
        FeatureUsageData data2 = new FeatureUsageData().addProject(project2);
        FUCounterUsageLogger.getInstance().logEvent(LIFECYCLE, "project.opened", data2);
    }

    public static void onProjectClosed(@NotNull Project project2) {
        if (project2 == null) {
            LifecycleUsageTriggerCollector.$$$reportNull$$$0(4);
        }
        FeatureUsageData data2 = new FeatureUsageData().addProject(project2);
        FUCounterUsageLogger.getInstance().logEvent(LIFECYCLE, "project.closed", data2);
    }

    public static void onProjectModuleAttached(@NotNull Project project2) {
        if (project2 == null) {
            LifecycleUsageTriggerCollector.$$$reportNull$$$0(5);
        }
        FeatureUsageData data2 = new FeatureUsageData().addProject(project2);
        FUCounterUsageLogger.getInstance().logEvent(LIFECYCLE, "project.module.attached", data2);
    }

    public static void onFrameActivated(@Nullable Project project2) {
        FeatureUsageData data2 = new FeatureUsageData().addProject(project2);
        FUCounterUsageLogger.getInstance().logEvent(LIFECYCLE, "frame.activated", data2);
    }

    public static void onFrameDeactivated(@Nullable Project project2) {
        FeatureUsageData data2 = new FeatureUsageData().addProject(project2);
        FUCounterUsageLogger.getInstance().logEvent(LIFECYCLE, "frame.deactivated", data2);
    }

    public static void onFreeze(long durationMs) {
        FeatureUsageData data2 = new FeatureUsageData().addData("duration_ms", durationMs).addData("duration_grouped", LifecycleUsageTriggerCollector.toLengthGroup((int)(durationMs / 1000L)));
        FUCounterUsageLogger.getInstance().logEvent(LIFECYCLE, "ide.freeze", data2);
    }

    public static void onError(@Nullable PluginId pluginId, @Nullable Throwable throwable, @Nullable VMOptions.MemoryKind memoryErrorKind) {
        try {
            ThrowableDescription description = new ThrowableDescription(throwable);
            FeatureUsageData data2 = new FeatureUsageData().addPluginInfo(pluginId == null ? PluginInfoDetectorKt.getPlatformPlugin() : PluginInfoDetectorKt.getPluginInfoById((PluginId)pluginId)).addData("error", description.getClassName());
            if (memoryErrorKind != null) {
                data2.addData("memory_error_kind", StringUtil.toLowerCase(memoryErrorKind.name()));
            }
            if (ourErrorsRateThrottle.tryPass(System.currentTimeMillis())) {
                List<String> frames = description.getLastFrames(50);
                int framesHash = frames.hashCode();
                data2.addData("error_hash", framesHash);
                if (ourErrorsIdentityThrottle.tryPass(framesHash, System.currentTimeMillis())) {
                    data2.addData("error_frames", frames).addData("error_size", description.getSize());
                }
            } else {
                data2.addData("too_many_errors", true);
            }
            FUCounterUsageLogger.getInstance().logEvent(LIFECYCLE, "ide.error", data2);
        }
        catch (Exception e) {
            LOG.warn(e);
        }
    }

    @NotNull
    private static String toLengthGroup(int seconds) {
        if (seconds >= 60) {
            return "60s+";
        }
        if (seconds > 10) {
            seconds -= seconds % 10;
            String string = seconds + "s+";
            if (string == null) {
                LifecycleUsageTriggerCollector.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = seconds + "s";
        if (string == null) {
            LifecycleUsageTriggerCollector.$$$reportNull$$$0(7);
        }
        return string;
    }

    public static void onProjectFrameSelected(int option2) {
        String optionValue;
        switch (option2) {
            case 0: {
                optionValue = "new";
                break;
            }
            case 1: {
                optionValue = "same";
                break;
            }
            case 2: {
                optionValue = "attach";
                break;
            }
            default: {
                return;
            }
        }
        FUCounterUsageLogger.getInstance().logEvent(LIFECYCLE, "project.frame.selected", new FeatureUsageData().addData("mode", optionValue));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/featureStatistics/fusCollectors/LifecycleUsageTriggerCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/featureStatistics/fusCollectors/LifecycleUsageTriggerCollector";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toLengthGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addIfTrue";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "onProjectOpenFinished";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onProjectOpened";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onProjectClosed";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "onProjectModuleAttached";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

