/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find;

import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.find.FindAllAction;
import com.intellij.find.FindBundle;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.find.FindUtil;
import com.intellij.find.SearchReplaceComponent;
import com.intellij.find.SearchSession;
import com.intellij.find.editorHeaderActions.AddOccurrenceAction;
import com.intellij.find.editorHeaderActions.NextOccurrenceAction;
import com.intellij.find.editorHeaderActions.PrevOccurrenceAction;
import com.intellij.find.editorHeaderActions.RemoveOccurrenceAction;
import com.intellij.find.editorHeaderActions.RestorePreviousSettingsAction;
import com.intellij.find.editorHeaderActions.SelectAllAction;
import com.intellij.find.editorHeaderActions.StatusTextAction;
import com.intellij.find.editorHeaderActions.SwitchToFind;
import com.intellij.find.editorHeaderActions.SwitchToReplace;
import com.intellij.find.editorHeaderActions.ToggleAnywhereAction;
import com.intellij.find.editorHeaderActions.ToggleExceptCommentsAction;
import com.intellij.find.editorHeaderActions.ToggleExceptCommentsAndLiteralsAction;
import com.intellij.find.editorHeaderActions.ToggleExceptLiteralsAction;
import com.intellij.find.editorHeaderActions.ToggleInCommentsAction;
import com.intellij.find.editorHeaderActions.ToggleInLiteralsOnlyAction;
import com.intellij.find.editorHeaderActions.ToggleMatchCase;
import com.intellij.find.editorHeaderActions.TogglePreserveCaseAction;
import com.intellij.find.editorHeaderActions.ToggleRegex;
import com.intellij.find.editorHeaderActions.ToggleSelectionOnlyAction;
import com.intellij.find.editorHeaderActions.ToggleWholeWordsOnlyAction;
import com.intellij.find.impl.livePreview.LivePreviewController;
import com.intellij.find.impl.livePreview.SearchResults;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonPainter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.ex.DefaultCustomComponentAction;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorSearchSession
implements SearchSession,
DataProvider,
SelectionListener,
SearchResults.SearchResultsListener,
SearchReplaceComponent.Listener {
    private static final String FIND_TYPE = "FindInFile";
    public static final DataKey<EditorSearchSession> SESSION_KEY = DataKey.create("EditorSearchSession");
    private final Editor myEditor;
    private final LivePreviewController myLivePreviewController;
    private final SearchResults mySearchResults;
    @NotNull
    private final FindModel myFindModel;
    private final SearchReplaceComponent myComponent;
    private RangeMarker myStartSessionSelectionMarker;
    private RangeMarker myStartSessionCaretMarker;
    private String myStartSelectedText;
    private boolean mySelectionUpdatedFromSearchResults;
    private final LinkLabel<Object> myClickToHighlightLabel;
    private final Disposable myDisposable;

    public EditorSearchSession(@NotNull Editor editor, Project project2) {
        if (editor == null) {
            EditorSearchSession.$$$reportNull$$$0(0);
        }
        this(editor, project2, EditorSearchSession.createDefaultFindModel(project2, editor));
    }

    public EditorSearchSession(final @NotNull Editor editor, Project project2, @NotNull FindModel findModel) {
        if (editor == null) {
            EditorSearchSession.$$$reportNull$$$0(1);
        }
        if (findModel == null) {
            EditorSearchSession.$$$reportNull$$$0(2);
        }
        this.myClickToHighlightLabel = new LinkLabel<Object>(FindBundle.message("link.click.to.highlight", new Object[0]), null, (__, ___) -> {
            this.setMatchesLimit(Integer.MAX_VALUE);
            this.updateResults(true);
        });
        this.myDisposable = Disposer.newDisposable(EditorSearchSession.class.getName());
        assert (!editor.isDisposed());
        this.myClickToHighlightLabel.setVisible(false);
        this.myFindModel = findModel;
        this.myEditor = editor;
        this.saveInitialSelection();
        this.mySearchResults = new SearchResults(this.myEditor, project2);
        this.myLivePreviewController = new LivePreviewController(this.mySearchResults, this, this.myDisposable);
        this.myComponent = SearchReplaceComponent.buildFor(project2, this.myEditor.getContentComponent()).addPrimarySearchActions(this.createPrimarySearchActions()).addSecondarySearchActions(this.createSecondarySearchActions()).addPrimarySearchActions(new ToggleSelectionOnlyAction()).addExtraSearchActions(new ToggleMatchCase(), new ToggleWholeWordsOnlyAction(), new ToggleRegex(), new DefaultCustomComponentAction((Supplier<? extends JComponent>)((Supplier<JComponent>)() -> this.myClickToHighlightLabel))).addSearchFieldActions(new RestorePreviousSettingsAction()).addPrimaryReplaceActions(new ReplaceAction(), new ReplaceAllAction(), new ExcludeAction()).addExtraReplaceAction(new TogglePreserveCaseAction()).addReplaceFieldActions(new PrevOccurrenceAction(false), new NextOccurrenceAction(false)).withDataProvider(this).withCloseAction(this::close).withReplaceAction(this::replaceCurrent).withSecondarySearchActionsIsModifiedGetter(() -> this.myFindModel.getSearchContext() != FindModel.SearchContext.ANY).build();
        this.myComponent.addListener(this);
        new UiNotifyConnector(this.myComponent, new Activatable(){

            @Override
            public void showNotify() {
                EditorSearchSession.this.initLivePreview();
            }

            @Override
            public void hideNotify() {
                EditorSearchSession.this.myLivePreviewController.off();
                EditorSearchSession.this.mySearchResults.removeListener(EditorSearchSession.this);
            }
        });
        new SwitchToFind(this.getComponent());
        new SwitchToReplace(this.getComponent());
        this.myFindModel.addObserver(new FindModel.FindModelObserver(){
            boolean myReentrantLock = false;
            boolean myIsGlobal = EditorSearchSession.access$300(EditorSearchSession.this).isGlobal();
            boolean myIsReplace = EditorSearchSession.access$300(EditorSearchSession.this).isReplaceState();

            @Override
            public void findModelChanged(FindModel findModel1) {
                if (this.myReentrantLock) {
                    return;
                }
                try {
                    this.myReentrantLock = true;
                    String stringToFind = EditorSearchSession.this.myFindModel.getStringToFind();
                    if (!EditorSearchSession.wholeWordsApplicable(stringToFind)) {
                        EditorSearchSession.this.myFindModel.setWholeWordsOnly(false);
                    }
                    if (this.myIsGlobal != EditorSearchSession.this.myFindModel.isGlobal() || this.myIsReplace != EditorSearchSession.this.myFindModel.isReplaceState()) {
                        if (EditorSearchSession.this.myFindModel.getStringToFind().isEmpty() && EditorSearchSession.this.myFindModel.isGlobal()) {
                            EditorSearchSession.this.myFindModel.setStringToFind(StringUtil.notNullize(EditorSearchSession.this.myEditor.getSelectionModel().getSelectedText()));
                        }
                        if (!EditorSearchSession.this.myFindModel.isGlobal()) {
                            if (EditorSearchSession.this.myFindModel.getStringToFind().equals(EditorSearchSession.this.myStartSelectedText)) {
                                EditorSearchSession.this.myFindModel.setStringToFind("");
                            } else {
                                EditorSearchSession.this.restoreInitialCaretPositionAndSelection();
                            }
                        }
                        this.myIsGlobal = EditorSearchSession.this.myFindModel.isGlobal();
                        this.myIsReplace = EditorSearchSession.this.myFindModel.isReplaceState();
                    }
                    EditorSearchSession.this.updateUIWithFindModel();
                    EditorSearchSession.this.mySearchResults.clear();
                    EditorSearchSession.this.updateResults(true);
                    FindUtil.updateFindInFileModel(EditorSearchSession.this.getProject(), EditorSearchSession.this.myFindModel, !ConsoleViewUtil.isConsoleViewEditor(editor));
                }
                finally {
                    this.myReentrantLock = false;
                }
            }
        });
        this.updateUIWithFindModel();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.initLivePreview();
        }
        this.updateMultiLineStateIfNeeded();
        EditorFactory.getInstance().addEditorFactoryListener(new EditorFactoryListener(){

            @Override
            public void editorReleased(@NotNull EditorFactoryEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (event.getEditor() == EditorSearchSession.this.myEditor) {
                    Disposer.dispose(EditorSearchSession.this.myDisposable);
                    EditorSearchSession.this.myLivePreviewController.dispose();
                    EditorSearchSession.this.myStartSessionSelectionMarker.dispose();
                    EditorSearchSession.this.myStartSessionCaretMarker.dispose();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/find/EditorSearchSession$3", "editorReleased"));
            }
        }, this.myDisposable);
        this.myEditor.getSelectionModel().addSelectionListener(this, this.myDisposable);
        FindUtil.triggerUsedOptionsStats(FIND_TYPE, findModel);
    }

    @NotNull
    protected AnAction[] createPrimarySearchActions() {
        AnAction[] anActionArray = new AnAction[]{new StatusTextAction(), new PrevOccurrenceAction(), new NextOccurrenceAction(), new FindAllAction(), new Separator(), new AddOccurrenceAction(), new RemoveOccurrenceAction(), new SelectAllAction(), new Separator()};
        if (anActionArray == null) {
            EditorSearchSession.$$$reportNull$$$0(3);
        }
        return anActionArray;
    }

    @NotNull
    protected AnAction[] createSecondarySearchActions() {
        AnAction[] anActionArray = new AnAction[]{new ToggleAnywhereAction(), new ToggleInCommentsAction(), new ToggleInLiteralsOnlyAction(), new ToggleExceptCommentsAction(), new ToggleExceptLiteralsAction(), new ToggleExceptCommentsAndLiteralsAction()};
        if (anActionArray == null) {
            EditorSearchSession.$$$reportNull$$$0(4);
        }
        return anActionArray;
    }

    private void saveInitialSelection() {
        if (this.mySelectionUpdatedFromSearchResults) {
            return;
        }
        SelectionModel selectionModel = this.myEditor.getSelectionModel();
        Document document = this.myEditor.getDocument();
        this.myStartSessionSelectionMarker = document.createRangeMarker(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd());
        this.myStartSessionCaretMarker = document.createRangeMarker(this.myEditor.getCaretModel().getOffset(), this.myEditor.getCaretModel().getOffset());
        this.myStartSelectedText = selectionModel.getSelectedText();
    }

    public Editor getEditor() {
        return this.myEditor;
    }

    @Nullable
    public static EditorSearchSession get(@Nullable Editor editor) {
        JComponent headerComponent = editor != null ? editor.getHeaderComponent() : null;
        SearchReplaceComponent searchReplaceComponent = ObjectUtils.tryCast(headerComponent, SearchReplaceComponent.class);
        return searchReplaceComponent != null ? SESSION_KEY.getData(searchReplaceComponent) : null;
    }

    @NotNull
    public static EditorSearchSession start(@NotNull Editor editor, @Nullable Project project2) {
        if (editor == null) {
            EditorSearchSession.$$$reportNull$$$0(5);
        }
        EditorSearchSession session2 = new EditorSearchSession(editor, project2);
        editor.setHeaderComponent(session2.getComponent());
        EditorSearchSession editorSearchSession = session2;
        if (editorSearchSession == null) {
            EditorSearchSession.$$$reportNull$$$0(6);
        }
        return editorSearchSession;
    }

    @NotNull
    public static EditorSearchSession start(@NotNull Editor editor, @NotNull FindModel findModel, @Nullable Project project2) {
        if (editor == null) {
            EditorSearchSession.$$$reportNull$$$0(7);
        }
        if (findModel == null) {
            EditorSearchSession.$$$reportNull$$$0(8);
        }
        EditorSearchSession session2 = new EditorSearchSession(editor, project2, findModel);
        editor.setHeaderComponent(session2.getComponent());
        EditorSearchSession editorSearchSession = session2;
        if (editorSearchSession == null) {
            EditorSearchSession.$$$reportNull$$$0(9);
        }
        return editorSearchSession;
    }

    @Override
    @NotNull
    public SearchReplaceComponent getComponent() {
        SearchReplaceComponent searchReplaceComponent = this.myComponent;
        if (searchReplaceComponent == null) {
            EditorSearchSession.$$$reportNull$$$0(10);
        }
        return searchReplaceComponent;
    }

    public Project getProject() {
        return this.myComponent.getProject();
    }

    @NotNull
    private static FindModel createDefaultFindModel(Project project2, Editor editor) {
        String selectedText;
        FindModel findModel = new FindModel();
        findModel.copyFrom(FindManager.getInstance(project2).getFindInFileModel());
        if (editor.getSelectionModel().hasSelection() && (selectedText = editor.getSelectionModel().getSelectedText()) != null) {
            findModel.setStringToFind(selectedText);
        }
        findModel.setPromptOnReplace(false);
        FindModel findModel2 = findModel;
        if (findModel2 == null) {
            EditorSearchSession.$$$reportNull$$$0(11);
        }
        return findModel2;
    }

    @Override
    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            EditorSearchSession.$$$reportNull$$$0(12);
        }
        if (SearchSession.KEY.is(dataId)) {
            return this;
        }
        if (SESSION_KEY.is(dataId)) {
            return this;
        }
        if (CommonDataKeys.EDITOR_EVEN_IF_INACTIVE.is(dataId)) {
            return this.myEditor;
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return this.myFindModel.isReplaceState() ? "Replace_the_found_target" : "ixFindText";
        }
        return null;
    }

    @Override
    public void searchResultsUpdated(@NotNull SearchResults sr) {
        if (sr == null) {
            EditorSearchSession.$$$reportNull$$$0(13);
        }
        if (sr.getFindModel() == null) {
            return;
        }
        if (this.myComponent.getSearchTextComponent().getText().isEmpty()) {
            this.updateUIWithEmptyResults();
        } else {
            String status;
            boolean tooManyMatches;
            int matches = sr.getMatchesCount();
            boolean bl = tooManyMatches = matches > this.mySearchResults.getMatchesLimit();
            if (matches == 0 && !sr.getFindModel().isGlobal() && !this.myEditor.getSelectionModel().hasSelection()) {
                status = ApplicationBundle.message("editorsearch.noselection", new Object[0]);
                this.myComponent.setRegularBackground();
            } else {
                int cursorIndex = sr.getCursorVisualIndex();
                String string = tooManyMatches ? ApplicationBundle.message("editorsearch.toomuch", this.mySearchResults.getMatchesLimit()) : (status = cursorIndex != -1 ? ApplicationBundle.message("editorsearch.current.cursor.position", cursorIndex, matches) : ApplicationBundle.message("editorsearch.matches", matches));
                if (!tooManyMatches && matches <= 0) {
                    this.myComponent.setNotFoundBackground();
                } else {
                    this.myComponent.setRegularBackground();
                }
            }
            this.myComponent.setStatusText(status);
            this.myClickToHighlightLabel.setVisible(tooManyMatches);
        }
        this.myComponent.updateActions();
    }

    @Override
    public void cursorMoved() {
        this.myComponent.updateActions();
    }

    @Override
    public void searchFieldDocumentChanged() {
        if (this.myEditor.isDisposed()) {
            return;
        }
        this.setMatchesLimit(10000);
        String text2 = this.myComponent.getSearchTextComponent().getText();
        this.myFindModel.setStringToFind(text2);
        this.updateResults(true);
        this.updateMultiLineStateIfNeeded();
    }

    private void updateMultiLineStateIfNeeded() {
        this.myFindModel.setMultiline(this.myComponent.getSearchTextComponent().getText().contains("\n") || this.myComponent.getReplaceTextComponent().getText().contains("\n"));
    }

    @Override
    public void replaceFieldDocumentChanged() {
        this.setMatchesLimit(10000);
        this.myFindModel.setStringToReplace(this.myComponent.getReplaceTextComponent().getText());
        this.updateMultiLineStateIfNeeded();
    }

    @Override
    public void multilineStateChanged() {
        this.myFindModel.setMultiline(this.myComponent.isMultiline());
    }

    @Override
    @NotNull
    public FindModel getFindModel() {
        FindModel findModel = this.myFindModel;
        if (findModel == null) {
            EditorSearchSession.$$$reportNull$$$0(14);
        }
        return findModel;
    }

    @Override
    public boolean hasMatches() {
        return this.mySearchResults.hasMatches();
    }

    @Override
    public boolean isSearchInProgress() {
        return this.mySearchResults.isUpdating();
    }

    @Override
    public void searchForward() {
        this.moveCursor(SearchResults.Direction.DOWN);
        this.addTextToRecent(this.myComponent.getSearchTextComponent());
    }

    @Override
    public void searchBackward() {
        this.moveCursor(SearchResults.Direction.UP);
        this.addTextToRecent(this.myComponent.getSearchTextComponent());
    }

    private void updateUIWithFindModel() {
        this.myComponent.update(this.myFindModel.getStringToFind(), this.myFindModel.getStringToReplace(), this.myFindModel.isReplaceState(), this.myFindModel.isMultiline());
        this.updateEmptyText();
        this.myLivePreviewController.setTrackingSelection(!this.myFindModel.isGlobal());
    }

    private void updateEmptyText() {
        if (this.myComponent.getSearchTextComponent() instanceof ComponentWithEmptyText) {
            String emptyText = this.getEmptyText();
            ((ComponentWithEmptyText)((Object)this.myComponent.getSearchTextComponent())).getEmptyText().setText(emptyText);
        }
    }

    @NotNull
    private String getEmptyText() {
        if (this.myFindModel.isGlobal() || !this.myFindModel.getStringToFind().isEmpty()) {
            return "";
        }
        String text2 = this.getEditor().getSelectionModel().getSelectedText();
        if (text2 != null && text2.contains("\n")) {
            boolean replaceState = this.myFindModel.isReplaceState();
            AnAction action2 = ActionManager.getInstance().getAction(replaceState ? "Replace" : "ToggleFindInSelection");
            Shortcut shortcut = ArrayUtil.getFirstElement(action2.getShortcutSet().getShortcuts());
            if (shortcut != null) {
                String string = ApplicationBundle.message("editorsearch.in.selection.with.hint", KeymapUtil.getShortcutText(shortcut));
                if (string == null) {
                    EditorSearchSession.$$$reportNull$$$0(15);
                }
                return string;
            }
        }
        String string = ApplicationBundle.message("editorsearch.in.selection", new Object[0]);
        if (string == null) {
            EditorSearchSession.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static boolean wholeWordsApplicable(String stringToFind) {
        return !stringToFind.startsWith(" ") && !stringToFind.startsWith("\t") && !stringToFind.endsWith(" ") && !stringToFind.endsWith("\t");
    }

    private void setMatchesLimit(int value2) {
        this.mySearchResults.setMatchesLimit(value2);
    }

    private void replaceCurrent() {
        if (this.mySearchResults.getCursor() != null) {
            try {
                this.myLivePreviewController.performReplace();
            }
            catch (FindManager.MalformedReplacementStringException e) {
                Messages.showErrorDialog(this.myComponent, e.getMessage(), FindBundle.message("find.replace.invalid.replacement.string.title", new Object[0]));
            }
        }
    }

    public void addTextToRecent(JTextComponent textField2) {
        this.myComponent.addTextToRecent(textField2);
    }

    @Override
    public void selectionChanged(@NotNull SelectionEvent e) {
        if (e == null) {
            EditorSearchSession.$$$reportNull$$$0(17);
        }
        this.saveInitialSelection();
        this.updateEmptyText();
    }

    @Override
    public void beforeSelectionUpdate() {
        this.mySelectionUpdatedFromSearchResults = true;
    }

    @Override
    public void afterSelectionUpdate() {
        this.mySelectionUpdatedFromSearchResults = false;
    }

    private void moveCursor(SearchResults.Direction direction) {
        this.myLivePreviewController.moveCursor(direction);
    }

    @Override
    public void close() {
        IdeFocusManager.getInstance(this.getProject()).requestFocus(this.myEditor.getContentComponent(), false);
        this.myLivePreviewController.dispose();
        this.myEditor.setHeaderComponent(null);
    }

    private void initLivePreview() {
        if (this.myEditor.isDisposed()) {
            return;
        }
        this.myLivePreviewController.on();
        this.myLivePreviewController.setUserActivityDelay(0);
        this.updateResults(false);
        this.myLivePreviewController.setUserActivityDelay(30);
        this.mySearchResults.addListener(this);
    }

    private void updateResults(boolean allowedToChangedEditorSelection) {
        String text2 = this.myFindModel.getStringToFind();
        if (text2.isEmpty()) {
            this.nothingToSearchFor(allowedToChangedEditorSelection);
        } else {
            if (this.myFindModel.isRegularExpressions()) {
                try {
                    Pattern.compile(text2);
                }
                catch (PatternSyntaxException e) {
                    this.myComponent.setNotFoundBackground();
                    this.myClickToHighlightLabel.setVisible(false);
                    this.mySearchResults.clear();
                    this.myComponent.setStatusText(INCORRECT_REGEX_MESSAGE);
                    return;
                }
                if (text2.matches("\\|+")) {
                    this.nothingToSearchFor(allowedToChangedEditorSelection);
                    this.myComponent.setStatusText(ApplicationBundle.message("editorsearch.empty.string.matches", new Object[0]));
                    return;
                }
            }
            FindManager findManager = FindManager.getInstance(this.getProject());
            if (allowedToChangedEditorSelection) {
                findManager.setFindWasPerformed();
                FindModel copy2 = new FindModel();
                copy2.copyFrom(this.myFindModel);
                copy2.setReplaceState(false);
                findManager.setFindNextModel(copy2);
            }
            if (this.myLivePreviewController != null) {
                this.myLivePreviewController.updateInBackground(this.myFindModel, allowedToChangedEditorSelection);
            }
        }
    }

    private void nothingToSearchFor(boolean allowedToChangedEditorSelection) {
        this.updateUIWithEmptyResults();
        this.mySearchResults.clear();
        if (allowedToChangedEditorSelection && !UIUtil.isClientPropertyTrue(this.myComponent.getSearchTextComponent(), "JUST_CLEARED")) {
            this.restoreInitialCaretPositionAndSelection();
        }
    }

    private void restoreInitialCaretPositionAndSelection() {
        int originalSelectionStart = Math.min(this.myStartSessionSelectionMarker.getStartOffset(), this.myEditor.getDocument().getTextLength());
        int originalSelectionEnd = Math.min(this.myStartSessionSelectionMarker.getEndOffset(), this.myEditor.getDocument().getTextLength());
        this.myEditor.getSelectionModel().setSelection(originalSelectionStart, originalSelectionEnd);
        this.myEditor.getCaretModel().moveToOffset(Math.min(this.myStartSessionCaretMarker.getEndOffset(), this.myEditor.getDocument().getTextLength()));
        this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
    }

    private void updateUIWithEmptyResults() {
        this.myComponent.setRegularBackground();
        this.myComponent.setStatusText("");
        this.myClickToHighlightLabel.setVisible(false);
    }

    public String getTextInField() {
        return this.myComponent.getSearchTextComponent().getText();
    }

    public void setTextInField(String text2) {
        this.myComponent.getSearchTextComponent().setText(text2);
        this.myFindModel.setStringToFind(text2);
    }

    public void selectAllOccurrences() {
        FindUtil.selectSearchResultsInEditor(this.myEditor, this.mySearchResults.getOccurrences().iterator(), -1);
    }

    public void removeOccurrence() {
        this.mySearchResults.prevOccurrence(true);
    }

    public void addNextOccurrence() {
        this.mySearchResults.nextOccurrence(true);
    }

    public void clearUndoInTextFields() {
        this.myComponent.resetUndoRedoActions();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findModel";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/EditorSearchSession";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sr";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/EditorSearchSession";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createPrimarySearchActions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createSecondarySearchActions";
                break;
            }
            case 6: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "start";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultFindModel";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFindModel";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptyText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "searchResultsUpdated";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "selectionChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ExcludeAction
    extends ButtonAction
    implements LightEditCompatible {
        ExcludeAction() {
            super("", 'l');
        }

        @Override
        protected void update(@NotNull JButton button2) {
            FindResult cursor;
            if (button2 == null) {
                ExcludeAction.$$$reportNull$$$0(0);
            }
            button2.setEnabled((cursor = EditorSearchSession.this.mySearchResults.getCursor()) != null);
            button2.setText(cursor != null && EditorSearchSession.this.mySearchResults.isExcluded(cursor) ? FindBundle.message("button.include", new Object[0]) : FindBundle.message("button.exclude", new Object[0]));
        }

        @Override
        protected void onClick() {
            EditorSearchSession.this.myLivePreviewController.exclude();
            EditorSearchSession.this.moveCursor(SearchResults.Direction.DOWN);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "button", "com/intellij/find/EditorSearchSession$ExcludeAction", "update"));
        }
    }

    private class ReplaceAllAction
    extends ButtonAction
    implements LightEditCompatible {
        ReplaceAllAction() {
            super("Replace all", 'a');
        }

        @Override
        protected void update(@NotNull JButton button2) {
            if (button2 == null) {
                ReplaceAllAction.$$$reportNull$$$0(0);
            }
            button2.setEnabled(EditorSearchSession.this.mySearchResults.hasMatches());
        }

        @Override
        protected void onClick() {
            EditorSearchSession.this.myLivePreviewController.performReplaceAll();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "button", "com/intellij/find/EditorSearchSession$ReplaceAllAction", "update"));
        }
    }

    private class ReplaceAction
    extends ButtonAction
    implements LightEditCompatible {
        ReplaceAction() {
            super("Replace", 'p');
        }

        @Override
        protected void update(@NotNull JButton button2) {
            if (button2 == null) {
                ReplaceAction.$$$reportNull$$$0(0);
            }
            button2.setEnabled(EditorSearchSession.this.mySearchResults.hasMatches());
        }

        @Override
        protected void onClick() {
            EditorSearchSession.this.replaceCurrent();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "button", "com/intellij/find/EditorSearchSession$ReplaceAction", "update"));
        }
    }

    private static abstract class ButtonAction
    extends DumbAwareAction
    implements CustomComponentAction,
    ActionListener {
        private final String myTitle;
        private final char myMnemonic;

        ButtonAction(@NotNull String title, char mnemonic) {
            if (title == null) {
                ButtonAction.$$$reportNull$$$0(0);
            }
            this.myTitle = title;
            this.myMnemonic = mnemonic;
        }

        @Override
        @NotNull
        public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
            if (presentation == null) {
                ButtonAction.$$$reportNull$$$0(1);
            }
            if (place == null) {
                ButtonAction.$$$reportNull$$$0(2);
            }
            JButton button2 = new JButton(this.myTitle);
            button2.setFocusable(false);
            if (!UISettings.getInstance().getDisableMnemonicsInControls()) {
                button2.setMnemonic(this.myMnemonic);
            }
            button2.setBorder(new DarculaButtonPainter(){

                @Override
                public Insets getBorderInsets(Component c) {
                    return JBUI.insets(1);
                }
            });
            button2.addActionListener(this);
            JButton jButton = button2;
            if (jButton == null) {
                ButtonAction.$$$reportNull$$$0(3);
            }
            return jButton;
        }

        @Override
        public final void update(@NotNull AnActionEvent e) {
            JButton button2;
            if (e == null) {
                ButtonAction.$$$reportNull$$$0(4);
            }
            if ((button2 = (JButton)e.getPresentation().getClientProperty(COMPONENT_KEY)) != null) {
                this.update(button2);
            }
        }

        @Override
        public final void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ButtonAction.$$$reportNull$$$0(5);
            }
            this.onClick();
        }

        @Override
        public final void actionPerformed(ActionEvent e) {
            this.onClick();
        }

        protected abstract void update(@NotNull JButton var1);

        protected abstract void onClick();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/find/EditorSearchSession$ButtonAction";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/find/EditorSearchSession$ButtonAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createCustomComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createCustomComponent";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

