/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.navigation.actions.GotoDeclarationAction;
import com.intellij.find.FindBundle;
import com.intellij.find.FindManager;
import com.intellij.find.actions.FindUsagesInFileAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.usages.PsiElementUsageTarget;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import org.jetbrains.annotations.NotNull;

public class FindUsagesAction
extends AnAction {
    public FindUsagesAction() {
        this.setInjectedContext(true);
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            FindUsagesAction.$$$reportNull$$$0(0);
        }
        if ((project2 = e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        PsiDocumentManager.getInstance(project2).commitAllDocuments();
        UsageTarget[] usageTargets = e.getData(UsageView.USAGE_TARGETS_KEY);
        if (usageTargets == null) {
            Editor editor = e.getData(CommonDataKeys.EDITOR);
            FindUsagesAction.chooseAmbiguousTargetAndPerform(project2, editor, element2 -> {
                this.startFindUsages(element2);
                return false;
            });
        } else {
            UsageTarget target2 = usageTargets[0];
            if (target2 instanceof PsiElementUsageTarget) {
                PsiElement element3 = ((PsiElementUsageTarget)target2).getElement();
                if (element3 != null) {
                    this.startFindUsages(element3);
                }
            } else {
                target2.findUsages();
            }
        }
    }

    protected void startFindUsages(@NotNull PsiElement element2) {
        if (element2 == null) {
            FindUsagesAction.$$$reportNull$$$0(1);
        }
        FindManager.getInstance(element2.getProject()).findUsages(element2);
    }

    @Override
    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            FindUsagesAction.$$$reportNull$$$0(2);
        }
        FindUsagesInFileAction.updateFindUsagesAction(event);
    }

    static void chooseAmbiguousTargetAndPerform(@NotNull Project project2, Editor editor, @NotNull PsiElementProcessor<? super PsiElement> processor2) {
        if (project2 == null) {
            FindUsagesAction.$$$reportNull$$$0(3);
        }
        if (processor2 == null) {
            FindUsagesAction.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            Messages.showMessageDialog(project2, FindBundle.message("find.no.usages.at.cursor.error", new Object[0]), CommonBundle.getErrorTitle(), Messages.getErrorIcon());
        } else {
            int offset = editor.getCaretModel().getOffset();
            boolean chosen = GotoDeclarationAction.chooseAmbiguousTarget(project2, editor, offset, processor2, FindBundle.message("find.usages.ambiguous.title", new Object[0]), null);
            if (!chosen) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (editor.isDisposed() || !editor.getComponent().isShowing()) {
                        return;
                    }
                    HintManager.getInstance().showErrorHint(editor, FindBundle.message("find.no.usages.at.cursor.error", new Object[0]));
                }, project2.getDisposed());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/find/actions/FindUsagesAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "startFindUsages";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "chooseAmbiguousTargetAndPerform";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ShowSettingsAndFindUsages
    extends FindUsagesAction {
        @Override
        protected void startFindUsages(@NotNull PsiElement element2) {
            if (element2 == null) {
                ShowSettingsAndFindUsages.$$$reportNull$$$0(0);
            }
            FindManager.getInstance(element2.getProject()).findUsages(element2, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/find/actions/FindUsagesAction$ShowSettingsAndFindUsages", "startFindUsages"));
        }
    }
}

