/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.find.FindManager;
import com.intellij.find.FindSettings;
import com.intellij.find.UsagesPreviewPanelProvider;
import com.intellij.find.actions.CompositeActiveComponent;
import com.intellij.find.actions.FindUsagesAction;
import com.intellij.find.actions.FindUsagesInFileAction;
import com.intellij.find.actions.PingEDT;
import com.intellij.find.actions.ShowUsagesActionHandler;
import com.intellij.find.actions.ShowUsagesTable;
import com.intellij.find.actions.ShowUsagesTableCellRenderer;
import com.intellij.find.actions.UsageListCellRenderer;
import com.intellij.find.findUsages.AbstractFindUsagesDialog;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerBase;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.find.findUsages.FindUsagesHandlerUi;
import com.intellij.find.findUsages.FindUsagesManager;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.gotoByName.ModelDiff;
import com.intellij.internal.statistic.service.fus.collectors.UIEventId;
import com.intellij.internal.statistic.service.fus.collectors.UIEventLogger;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PopupAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.preview.PreviewManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IntRef;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.ActiveComponent;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.TitlePanel;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.PopupUpdateProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.PsiElementUsageTarget;
import com.intellij.usages.ShowUsagesSettings;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.UsageViewSettings;
import com.intellij.usages.impl.GroupNode;
import com.intellij.usages.impl.NullUsage;
import com.intellij.usages.impl.UsageGroupingRuleProviderImpl;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.impl.UsageViewManagerImpl;
import com.intellij.usages.rules.UsageFilteringRuleProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.EdtScheduledExecutorService;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowUsagesAction
extends AnAction
implements PopupAction,
HintManagerImpl.ActionToIgnore {
    public static final String ID = "ShowUsages";

    public static int getUsagesPageSize() {
        return Math.max(1, Registry.intValue("ide.usages.page.size", 100));
    }

    public ShowUsagesAction() {
        this.setInjectedContext(true);
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        UsageTarget[] usageTargets;
        if (e == null) {
            ShowUsagesAction.$$$reportNull$$$0(0);
        }
        FindUsagesInFileAction.updateFindUsagesAction(e);
        if (e.getPresentation().isEnabled() && (usageTargets = e.getData(UsageView.USAGE_TARGETS_KEY)) != null && !(ArrayUtil.getFirstElement(usageTargets) instanceof PsiElementUsageTarget)) {
            e.getPresentation().setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        PsiElement element3;
        Project project2;
        if (e == null) {
            ShowUsagesAction.$$$reportNull$$$0(1);
        }
        if ((project2 = e.getProject()) == null) {
            return;
        }
        ShowUsagesActionState state = ShowUsagesAction.getState(project2);
        Runnable continuation = state.continuation;
        if (continuation != null) {
            state.continuation = null;
            ShowUsagesAction.hideHints();
            continuation.run();
            return;
        }
        RelativePoint popupPosition = JBPopupFactory.getInstance().guessBestPopupLocation(e.getDataContext());
        PsiDocumentManager.getInstance(project2).commitAllDocuments();
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.goto.usages");
        UsageTarget[] usageTargets = e.getData(UsageView.USAGE_TARGETS_KEY);
        Editor editor = e.getData(CommonDataKeys.EDITOR);
        if (usageTargets == null) {
            FindUsagesAction.chooseAmbiguousTargetAndPerform(project2, editor, element2 -> {
                ShowUsagesAction.startFindUsages(element2, popupPosition, editor);
                return false;
            });
        } else if (ArrayUtil.getFirstElement(usageTargets) instanceof PsiElementUsageTarget && (element3 = ((PsiElementUsageTarget)usageTargets[0]).getElement()) != null) {
            ShowUsagesAction.startFindUsages(element3, popupPosition, editor);
        }
    }

    private static void hideHints() {
        HintManager.getInstance().hideHints(2, false, false);
    }

    public static void startFindUsages(@NotNull PsiElement element2, @NotNull RelativePoint popupPosition, @Nullable Editor editor) {
        Project project2;
        FindUsagesManager findUsagesManager;
        FindUsagesHandler handler2;
        if (element2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(2);
        }
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(3);
        }
        if ((handler2 = (findUsagesManager = ((FindManagerImpl)FindManager.getInstance(project2 = element2.getProject())).getFindUsagesManager()).getFindUsagesHandler(element2, FindUsagesHandlerFactory.OperationMode.USAGES_WITH_DEFAULT_OPTIONS)) == null) {
            return;
        }
        FindUsagesOptions options = handler2.getFindUsagesOptions(DataManager.getInstance().getDataContext());
        ShowUsagesAction.showElementUsages(editor, popupPosition, handler2, options, new IntRef(0));
    }

    private static void rulesChanged(@NotNull UsageViewImpl usageView, @NotNull PingEDT pingEDT, JBPopup popup2) {
        if (usageView == null) {
            ShowUsagesAction.$$$reportNull$$$0(4);
        }
        if (pingEDT == null) {
            ShowUsagesAction.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (!(popup2 != null && popup2.isDisposed() || usageView.isDisposed())) {
                usageView.waitForUpdateRequestsCompletion();
                if (!(popup2 != null && popup2.isDisposed() || usageView.isDisposed())) {
                    pingEDT.ping();
                }
            }
        }));
    }

    private static void showElementUsages(final @Nullable Editor editor, final @NotNull RelativePoint popupPosition, final @NotNull FindUsagesHandlerBase handler2, final @NotNull FindUsagesOptions options, final @NotNull IntRef minWidth) {
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(6);
        }
        if (handler2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(7);
        }
        if (options == null) {
            ShowUsagesAction.$$$reportNull$$$0(8);
        }
        if (minWidth == null) {
            ShowUsagesAction.$$$reportNull$$$0(9);
        }
        Project project2 = handler2.getProject();
        final FindUsagesManager findUsagesManager = ((FindManagerImpl)FindManager.getInstance(project2)).getFindUsagesManager();
        PsiElement[] primaryElements = handler2.getPrimaryElements();
        PsiElement[] secondaryElements = handler2.getSecondaryElements();
        UsageSearcher usageSearcher = FindUsagesManager.createUsageSearcher(handler2, primaryElements, secondaryElements, options);
        ShowUsagesAction.showElementUsages(project2, editor, popupPosition, ShowUsagesAction.getUsagesPageSize(), minWidth, findUsagesManager.createPresentation(handler2, options), usageSearcher, new ShowUsagesActionHandler(){

            @Override
            public boolean isValid() {
                return handler2.getPsiElement().isValid();
            }

            @Override
            @NotNull
            public SearchScope getSelectedScope() {
                SearchScope searchScope = options.searchScope;
                if (searchScope == null) {
                    1.$$$reportNull$$$0(0);
                }
                return searchScope;
            }

            @Override
            @NotNull
            public GlobalSearchScope getMaximalScope() {
                GlobalSearchScope globalSearchScope = FindUsagesManager.getMaximalScope(handler2);
                if (globalSearchScope == null) {
                    1.$$$reportNull$$$0(1);
                }
                return globalSearchScope;
            }

            @Override
            public void showDialogAndShowUsages(@Nullable Editor newEditor) {
                ShowUsagesAction.showDialog(handler2, newOptions -> ShowUsagesAction.showElementUsages(newEditor, popupPosition, handler2, newOptions, minWidth));
            }

            @Override
            public void findUsages() {
                findUsagesManager.findUsages(handler2.getPrimaryElements(), handler2.getSecondaryElements(), handler2, options, FindSettings.getInstance().isSkipResultsWithOneUsage());
            }

            @Override
            public void showUsagesInScope(@NotNull SearchScope searchScope) {
                if (searchScope == null) {
                    1.$$$reportNull$$$0(2);
                }
                FindUsagesOptions newOptions = options.clone();
                newOptions.searchScope = searchScope;
                ShowUsagesAction.showElementUsages(editor, popupPosition, handler2, newOptions, minWidth);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/find/actions/ShowUsagesAction$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "searchScope";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSelectedScope";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getMaximalScope";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/find/actions/ShowUsagesAction$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "showUsagesInScope";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    private static void showElementUsages(@NotNull Project project2, @Nullable Editor editor, @NotNull RelativePoint popupPosition, int maxUsages, @NotNull IntRef minWidth, @NotNull UsageViewPresentation presentation, @NotNull UsageSearcher usageSearcher, @NotNull ShowUsagesActionHandler actionHandler) {
        PsiReference reference2;
        if (project2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(10);
        }
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(11);
        }
        if (minWidth == null) {
            ShowUsagesAction.$$$reportNull$$$0(12);
        }
        if (presentation == null) {
            ShowUsagesAction.$$$reportNull$$$0(13);
        }
        if (usageSearcher == null) {
            ShowUsagesAction.$$$reportNull$$$0(14);
        }
        if (actionHandler == null) {
            ShowUsagesAction.$$$reportNull$$$0(15);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        UsageViewSettings usageViewSettings = UsageViewSettings.getInstance();
        ShowUsagesSettings showUsagesSettings = ShowUsagesSettings.getInstance();
        UsageViewSettings savedGlobalSettings = new UsageViewSettings();
        savedGlobalSettings.loadState(usageViewSettings);
        usageViewSettings.loadState(showUsagesSettings.getState());
        UsageViewManager manager = UsageViewManager.getInstance(project2);
        presentation.setDetachedMode(true);
        UsageViewImpl usageView = (UsageViewImpl)manager.createUsageView(UsageTarget.EMPTY_ARRAY, Usage.EMPTY_ARRAY, presentation, null);
        if (editor != null && (reference2 = TargetElementUtil.findReference(editor)) != null) {
            UsageInfo2UsageAdapter origin = new UsageInfo2UsageAdapter(new UsageInfo(reference2));
            usageView.setOriginUsage(origin);
        }
        Disposer.register(usageView, () -> {
            showUsagesSettings.applyUsageViewSettings(usageViewSettings);
            usageViewSettings.loadState(savedGlobalSettings);
        });
        SearchScope searchScope = actionHandler.getSelectedScope();
        AtomicInteger outOfScopeUsages = new AtomicInteger();
        ShowUsagesTable table = new ShowUsagesTable(new ShowUsagesTableCellRenderer(usageView, outOfScopeUsages, searchScope));
        AsyncProcessIcon processIcon = new AsyncProcessIcon("xxx");
        TitlePanel statusPanel = new TitlePanel();
        statusPanel.add((Component)processIcon, "East");
        Consumer<String> statusConsumer = statusPanel::setText;
        ShowUsagesAction.addUsageNodes(usageView.getRoot(), usageView, new ArrayList());
        ArrayList usages = new ArrayList();
        LinkedHashSet visibleNodes = new LinkedHashSet();
        List<UsageNode> data2 = ShowUsagesAction.collectData(usages, visibleNodes, usageView);
        table.setTableModel(data2);
        boolean isPreviewMode = Boolean.TRUE == PreviewManager.SERVICE.preview(project2, UsagesPreviewPanelProvider.ID, Pair.create(usageView, table), false);
        Runnable itemChosenCallback = table.prepareTable(isPreviewMode, () -> ShowUsagesAction.showElementUsages(project2, editor, popupPosition, maxUsages + ShowUsagesAction.getUsagesPageSize(), minWidth, presentation, usageSearcher, actionHandler), () -> ShowUsagesActionHandler.showUsagesInMaximalScope(actionHandler));
        JBPopup popup2 = isPreviewMode ? null : ShowUsagesAction.createUsagePopup(project2, usageView, table, itemChosenCallback, presentation, statusPanel, minWidth, () -> actionHandler.showDialogAndShowUsages(editor), actionHandler);
        ProgressIndicatorBase indicator = new ProgressIndicatorBase();
        if (popup2 != null) {
            Disposer.register(popup2, usageView);
            Disposer.register(popup2, indicator::cancel);
            EdtScheduledExecutorService.getInstance().schedule(() -> {
                if (!usageView.isDisposed()) {
                    ShowUsagesAction.showPopupIfNeedTo(popup2, popupPosition);
                }
            }, 300L, TimeUnit.MILLISECONDS);
        }
        PingEDT pingEDT = new PingEDT("Rebuild popup in EDT", o -> popup2 != null && popup2.isDisposed(), 100, () -> {
            ArrayList copy2;
            if (popup2 != null && popup2.isDisposed()) {
                return;
            }
            ArrayList<UsageNode> nodes = new ArrayList<UsageNode>(usages.size());
            List list2 = usages;
            synchronized (list2) {
                if (!(popup2 == null || popup2.isVisible() || !usages.isEmpty() && ShowUsagesAction.showPopupIfNeedTo(popup2, popupPosition))) {
                    return;
                }
                ShowUsagesAction.addUsageNodes(usageView.getRoot(), usageView, nodes);
                copy2 = new ArrayList(usages);
            }
            ShowUsagesAction.rebuildTable(usageView, copy2, nodes, table, popup2, statusConsumer, popupPosition, minWidth, !processIcon.isDisposed());
        });
        MessageBusConnection messageBusConnection = project2.getMessageBus().connect(usageView);
        messageBusConnection.subscribe(UsageFilteringRuleProvider.RULES_CHANGED, () -> ShowUsagesAction.rulesChanged(usageView, pingEDT, popup2));
        Processor<Usage> collect = usage -> {
            if (!UsageViewManagerImpl.isInScope(usage, searchScope)) {
                if (outOfScopeUsages.getAndIncrement() == 0) {
                    visibleNodes.add(Holder.USAGES_OUTSIDE_SCOPE_NODE);
                    usages.add(ShowUsagesTable.USAGES_OUTSIDE_SCOPE_SEPARATOR);
                }
                return true;
            }
            List list2 = usages;
            synchronized (list2) {
                if (visibleNodes.size() >= maxUsages) {
                    return false;
                }
                UsageNode node = ReadAction.compute(() -> usageView.doAppendUsage((Usage)usage));
                usages.add(usage);
                if (node != null) {
                    visibleNodes.add(node);
                    boolean continueSearch = true;
                    if (visibleNodes.size() == maxUsages) {
                        visibleNodes.add(Holder.MORE_USAGES_SEPARATOR_NODE);
                        usages.add(ShowUsagesTable.MORE_USAGES_SEPARATOR);
                        continueSearch = false;
                    }
                    pingEDT.ping();
                    return continueSearch;
                }
            }
            return true;
        };
        FindUsagesManager.startProcessUsages(indicator, project2, usageSearcher, collect, () -> ApplicationManager.getApplication().invokeLater(() -> {
            Disposer.dispose(processIcon);
            Container parent = processIcon.getParent();
            if (parent != null) {
                parent.remove(processIcon);
                parent.repaint();
            }
            pingEDT.ping();
            List list2 = usages;
            synchronized (list2) {
                if (visibleNodes.isEmpty()) {
                    if (usages.isEmpty()) {
                        String hint = UsageViewBundle.message("no.usages.found.in", searchScope.getDisplayName());
                        ShowUsagesAction.hint(project2, editor, popupPosition, false, hint, actionHandler);
                        ShowUsagesAction.cancel(popup2);
                    }
                } else if (visibleNodes.size() == 1) {
                    if (usages.size() == 1) {
                        Usage usage = ((UsageNode)visibleNodes.iterator().next()).getUsage();
                        if (usage == ShowUsagesTable.USAGES_OUTSIDE_SCOPE_SEPARATOR) {
                            String hint = UsageViewManagerImpl.outOfScopeMessage(outOfScopeUsages.get(), searchScope);
                            ShowUsagesAction.hint(project2, editor, popupPosition, true, hint, actionHandler);
                        } else {
                            String hint = UsageViewBundle.message("show.usages.only.usage", searchScope.getDisplayName());
                            ShowUsagesAction.navigateAndHint(project2, usage, popupPosition, hint, actionHandler);
                        }
                        ShowUsagesAction.cancel(popup2);
                    } else {
                        assert (usages.size() > 1) : usages;
                        Usage visibleUsage = ((UsageNode)visibleNodes.iterator().next()).getUsage();
                        if (ShowUsagesAction.areAllUsagesInOneLine(visibleUsage, usages)) {
                            String hint = UsageViewBundle.message("all.usages.are.in.this.line", usages.size(), searchScope.getDisplayName());
                            ShowUsagesAction.navigateAndHint(project2, visibleUsage, popupPosition, hint, actionHandler);
                            ShowUsagesAction.cancel(popup2);
                        }
                    }
                } else {
                    boolean hasMore = visibleNodes.contains(Holder.MORE_USAGES_SEPARATOR_NODE);
                    statusConsumer.accept(ShowUsagesAction.getStatusString(false, hasMore, visibleNodes.size(), usages.size()));
                }
            }
        }, project2.getDisposed()));
    }

    @NotNull
    static UsageNode createStringNode(@NotNull Object string) {
        if (string == null) {
            ShowUsagesAction.$$$reportNull$$$0(16);
        }
        return new StringNode(string);
    }

    private static boolean showPopupIfNeedTo(@NotNull JBPopup popup2, @NotNull RelativePoint popupPosition) {
        if (popup2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(17);
        }
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(18);
        }
        if (!popup2.isDisposed() && !popup2.isVisible()) {
            popup2.show(popupPosition);
            return true;
        }
        return false;
    }

    @NotNull
    private static JComponent createHintComponent(@NotNull String secondInvocationTitle, boolean isWarning, @NotNull JComponent button2) {
        if (secondInvocationTitle == null) {
            ShowUsagesAction.$$$reportNull$$$0(19);
        }
        if (button2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(20);
        }
        JComponent label2 = HintUtil.createInformationLabel(secondInvocationTitle);
        if (isWarning) {
            label2.setBackground(MessageType.WARNING.getPopupBackground());
        }
        JPanel panel2 = new JPanel(new BorderLayout());
        button2.setBackground(label2.getBackground());
        panel2.setBackground(label2.getBackground());
        label2.setOpaque(false);
        label2.setBorder(null);
        panel2.setBorder(HintUtil.createHintBorder());
        panel2.add((Component)label2, "Center");
        panel2.add((Component)button2, "East");
        JPanel jPanel = panel2;
        if (jPanel == null) {
            ShowUsagesAction.$$$reportNull$$$0(21);
        }
        return jPanel;
    }

    @NotNull
    private static InplaceButton createSettingsButton(@NotNull Project project2, @NotNull Runnable cancelAction, @NotNull Runnable showDialogAndFindUsagesRunnable) {
        if (project2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(22);
        }
        if (cancelAction == null) {
            ShowUsagesAction.$$$reportNull$$$0(23);
        }
        if (showDialogAndFindUsagesRunnable == null) {
            ShowUsagesAction.$$$reportNull$$$0(24);
        }
        String shortcutText = "";
        KeyboardShortcut shortcut = UsageViewImpl.getShowUsagesWithSettingsShortcut();
        if (shortcut != null) {
            shortcutText = "(" + KeymapUtil.getShortcutText(shortcut) + ")";
        }
        return new InplaceButton("Settings..." + shortcutText, AllIcons.General.Settings, __ -> {
            ApplicationManager.getApplication().invokeLater(showDialogAndFindUsagesRunnable, project2.getDisposed());
            cancelAction.run();
        });
    }

    private static void showDialog(@NotNull FindUsagesHandlerBase handler2, @NotNull @NotNull Consumer<@NotNull FindUsagesOptions> optionsConsumer) {
        if (handler2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(25);
        }
        if (optionsConsumer == null) {
            ShowUsagesAction.$$$reportNull$$$0(26);
        }
        UIEventLogger.logUIEvent((UIEventId)UIEventId.ShowUsagesPopupShowSettings);
        AbstractFindUsagesDialog dialog2 = handler2 instanceof FindUsagesHandlerUi ? ((FindUsagesHandlerUi)((Object)handler2)).getFindUsagesDialog(false, false, false) : FindUsagesHandler.createDefaultFindUsagesDialog(false, false, false, handler2);
        if (dialog2.showAndGet()) {
            dialog2.calcFindUsagesOptions();
            FindUsagesOptions options = handler2.getFindUsagesOptions(DataManager.getInstance().getDataContext());
            optionsConsumer.accept(options);
        }
    }

    @NotNull
    private static JBPopup createUsagePopup(@NotNull Project project2, @NotNull UsageViewImpl usageView, @NotNull JTable table, @NotNull Runnable itemChoseCallback, @NotNull UsageViewPresentation presentation, final @NotNull TitlePanel statusPanel, @NotNull IntRef minWidth, final @NotNull Runnable showDialogAndFindUsagesRunnable, final @NotNull ShowUsagesActionHandler actionHandler) {
        if (project2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(27);
        }
        if (usageView == null) {
            ShowUsagesAction.$$$reportNull$$$0(28);
        }
        if (table == null) {
            ShowUsagesAction.$$$reportNull$$$0(29);
        }
        if (itemChoseCallback == null) {
            ShowUsagesAction.$$$reportNull$$$0(30);
        }
        if (presentation == null) {
            ShowUsagesAction.$$$reportNull$$$0(31);
        }
        if (statusPanel == null) {
            ShowUsagesAction.$$$reportNull$$$0(32);
        }
        if (minWidth == null) {
            ShowUsagesAction.$$$reportNull$$$0(33);
        }
        if (showDialogAndFindUsagesRunnable == null) {
            ShowUsagesAction.$$$reportNull$$$0(34);
        }
        if (actionHandler == null) {
            ShowUsagesAction.$$$reportNull$$$0(35);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        PopupChooserBuilder builder2 = JBPopupFactory.getInstance().createPopupChooserBuilder(table);
        String title = presentation.getTabText();
        builder2.setTitle(XmlStringUtil.wrapInHtml("<body><nobr>" + StringUtil.escapeXmlEntities(title) + "</nobr></body>"));
        builder2.setAdText(ShowUsagesActionHandler.getSecondInvocationTitle(actionHandler));
        ((PopupChooserBuilder)builder2.setMovable(true)).setResizable(true);
        builder2.setItemChoosenCallback(itemChoseCallback);
        final JBPopup[] popup2 = new JBPopup[1];
        KeyboardShortcut shortcut = UsageViewImpl.getShowUsagesWithSettingsShortcut();
        if (shortcut != null) {
            new DumbAwareAction(){

                @Override
                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    ShowUsagesAction.cancel(popup2[0]);
                    showDialogAndFindUsagesRunnable.run();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/actions/ShowUsagesAction$2", "actionPerformed"));
                }
            }.registerCustomShortcutSet(new CustomShortcutSet(shortcut.getFirstKeyStroke()), table);
        }
        if ((shortcut = ShowUsagesAction.getShowUsagesShortcut()) != null) {
            new DumbAwareAction(){

                @Override
                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    ShowUsagesAction.cancel(popup2[0]);
                    ShowUsagesActionHandler.showUsagesInMaximalScope(actionHandler);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/actions/ShowUsagesAction$3", "actionPerformed"));
                }
            }.registerCustomShortcutSet(new CustomShortcutSet(shortcut.getFirstKeyStroke()), table);
        }
        InplaceButton settingsButton = ShowUsagesAction.createSettingsButton(project2, () -> ShowUsagesAction.cancel(popup2[0]), showDialogAndFindUsagesRunnable);
        ActiveComponent statusComponent = new ActiveComponent(){

            @Override
            public void setActive(boolean active) {
                statusPanel.setActive(active);
            }

            @Override
            @NotNull
            public JComponent getComponent() {
                TitlePanel titlePanel = statusPanel;
                if (titlePanel == null) {
                    4.$$$reportNull$$$0(0);
                }
                return titlePanel;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/actions/ShowUsagesAction$4", "getComponent"));
            }
        };
        DefaultActionGroup pinGroup = new DefaultActionGroup();
        ActiveComponent pin = ShowUsagesAction.createPinButton(project2, popup2, pinGroup, actionHandler::findUsages);
        builder2.setCommandButton(new CompositeActiveComponent(statusComponent, settingsButton, pin));
        DefaultActionGroup toolbar = new DefaultActionGroup();
        usageView.addFilteringActions(toolbar);
        toolbar.add(UsageGroupingRuleProviderImpl.createGroupByFileStructureAction(usageView));
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("UsageViewToolbar", toolbar, true);
        actionToolbar.setReservePlaceAutoPopupIcon(false);
        JComponent toolBar = actionToolbar.getComponent();
        toolBar.setOpaque(false);
        builder2.setSettingButton(toolBar);
        builder2.setCancelKeyEnabled(false);
        PopupUpdateProcessor processor2 = new PopupUpdateProcessor(usageView.getProject()){

            @Override
            public void updatePopup(Object lookupItemObject) {
            }
        };
        builder2.addListener(processor2);
        popup2[0] = builder2.createPopup();
        JComponent content2 = popup2[0].getContent();
        String fullTitle = title + ShowUsagesAction.getStatusString(true, false, 0, 0);
        int approxWidth = (int)(toolBar.getPreferredSize().getWidth() + new JLabel(fullTitle).getPreferredSize().getWidth() + settingsButton.getPreferredSize().getWidth());
        minWidth.set(Math.max(minWidth.get(), approxWidth));
        for (AnAction action2 : toolbar.getChildren(null)) {
            action2.unregisterCustomShortcutSet(usageView.getComponent());
            action2.registerCustomShortcutSet(action2.getShortcutSet(), content2);
        }
        for (AnAction action2 : pinGroup.getChildren(null)) {
            action2.unregisterCustomShortcutSet(usageView.getComponent());
            action2.registerCustomShortcutSet(action2.getShortcutSet(), content2);
        }
        JBPopup jBPopup = popup2[0];
        if (jBPopup == null) {
            ShowUsagesAction.$$$reportNull$$$0(36);
        }
        return jBPopup;
    }

    @NotNull
    private static ActiveComponent createPinButton(@NotNull Project project2, final JBPopup @NotNull [] popup2, @NotNull DefaultActionGroup pinGroup, final @NotNull Runnable findUsagesRunnable) {
        if (project2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(37);
        }
        if (pinGroup == null) {
            ShowUsagesAction.$$$reportNull$$$0(38);
        }
        if (findUsagesRunnable == null) {
            ShowUsagesAction.$$$reportNull$$$0(39);
        }
        if (popup2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(40);
        }
        Icon icon2 = ToolWindowManagerEx.getInstanceEx(project2).getLocationIcon("Find", AllIcons.General.Pin_tab);
        AnAction pinAction = new AnAction(IdeBundle.messagePointer("show.in.find.window.button.name", new Object[0]), IdeBundle.messagePointer("show.in.find.window.button.pin.description", new Object[0]), icon2){
            {
                super(arg0, arg1, arg2);
                AnAction action2 = ActionManager.getInstance().getAction("FindUsages");
                this.setShortcutSet(action2.getShortcutSet());
            }

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                ShowUsagesAction.hideHints();
                ShowUsagesAction.cancel(popup2[0]);
                findUsagesRunnable.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/actions/ShowUsagesAction$6", "actionPerformed"));
            }
        };
        pinGroup.add(pinAction);
        ActionToolbar pinToolbar = ActionManager.getInstance().createActionToolbar("UsageViewToolbar", pinGroup, true);
        pinToolbar.setReservePlaceAutoPopupIcon(false);
        final JComponent pinToolBar = pinToolbar.getComponent();
        pinToolBar.setBorder(null);
        pinToolBar.setOpaque(false);
        return new ActiveComponent.Adapter(){

            @Override
            @NotNull
            public JComponent getComponent() {
                JComponent jComponent = pinToolBar;
                if (jComponent == null) {
                    7.$$$reportNull$$$0(0);
                }
                return jComponent;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/actions/ShowUsagesAction$7", "getComponent"));
            }
        };
    }

    private static void cancel(@Nullable JBPopup popup2) {
        if (popup2 != null) {
            popup2.cancel();
        }
    }

    @NotNull
    private static String getStatusString(boolean findUsagesInProgress, boolean hasMore, int visibleCount, int totalCount) {
        if (findUsagesInProgress || hasMore) {
            String string = UsageViewBundle.message("showing.0.usages", visibleCount - (hasMore ? 1 : 0));
            if (string == null) {
                ShowUsagesAction.$$$reportNull$$$0(41);
            }
            return string;
        }
        if (visibleCount != totalCount) {
            String string = UsageViewBundle.message("showing.0.of.1.usages", visibleCount, totalCount);
            if (string == null) {
                ShowUsagesAction.$$$reportNull$$$0(42);
            }
            return string;
        }
        String string = UsageViewBundle.message("found.0.usages", totalCount);
        if (string == null) {
            ShowUsagesAction.$$$reportNull$$$0(43);
        }
        return string;
    }

    @NotNull
    private static String suggestSecondInvocation(@NotNull String text2, @Nullable String title) {
        if (text2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(44);
        }
        if (title != null) {
            text2 = text2 + "<br><small>" + title + "</small>";
        }
        String string = XmlStringUtil.wrapInHtml(UIUtil.convertSpace2Nbsp(text2));
        if (string == null) {
            ShowUsagesAction.$$$reportNull$$$0(45);
        }
        return string;
    }

    @Nullable
    static KeyboardShortcut getShowUsagesShortcut() {
        return ActionManager.getInstance().getKeyboardShortcut(ID);
    }

    private static int filtered(@NotNull List<? extends Usage> usages, @NotNull UsageViewImpl usageView) {
        if (usages == null) {
            ShowUsagesAction.$$$reportNull$$$0(46);
        }
        if (usageView == null) {
            ShowUsagesAction.$$$reportNull$$$0(47);
        }
        return (int)usages.stream().filter(usage -> !usageView.isVisible((Usage)usage)).count();
    }

    private static int getUsageOffset(@NotNull Usage usage) {
        if (usage == null) {
            ShowUsagesAction.$$$reportNull$$$0(48);
        }
        if (!(usage instanceof UsageInfo2UsageAdapter)) {
            return -1;
        }
        PsiElement element2 = ((UsageInfo2UsageAdapter)usage).getElement();
        if (element2 == null) {
            return -1;
        }
        return element2.getTextRange().getStartOffset();
    }

    private static boolean areAllUsagesInOneLine(@NotNull Usage visibleUsage, @NotNull List<? extends Usage> usages) {
        Editor editor;
        if (visibleUsage == null) {
            ShowUsagesAction.$$$reportNull$$$0(49);
        }
        if (usages == null) {
            ShowUsagesAction.$$$reportNull$$$0(50);
        }
        if ((editor = ShowUsagesAction.getEditorFor(visibleUsage)) == null) {
            return false;
        }
        int offset = ShowUsagesAction.getUsageOffset(visibleUsage);
        if (offset == -1) {
            return false;
        }
        int lineNumber = editor.getDocument().getLineNumber(offset);
        for (Usage usage : usages) {
            Editor otherEditor = ShowUsagesAction.getEditorFor(usage);
            if (otherEditor != editor) {
                return false;
            }
            int otherOffset = ShowUsagesAction.getUsageOffset(usage);
            if (otherOffset == -1) {
                return false;
            }
            int otherLine = otherEditor.getDocument().getLineNumber(otherOffset);
            if (otherLine == lineNumber) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static List<UsageNode> collectData(@NotNull List<? extends Usage> usages, @NotNull Collection<? extends UsageNode> visibleNodes, @NotNull UsageViewImpl usageView) {
        if (usages == null) {
            ShowUsagesAction.$$$reportNull$$$0(51);
        }
        if (visibleNodes == null) {
            ShowUsagesAction.$$$reportNull$$$0(52);
        }
        if (usageView == null) {
            ShowUsagesAction.$$$reportNull$$$0(53);
        }
        @NotNull ArrayList<UsageNode> data2 = new ArrayList<UsageNode>();
        int filtered2 = ShowUsagesAction.filtered(usages, usageView);
        if (filtered2 != 0) {
            data2.add(ShowUsagesAction.createStringNode(UsageViewBundle.message("usages.were.filtered.out", filtered2)));
        }
        data2.addAll(visibleNodes);
        if (data2.isEmpty()) {
            data2.add(ShowUsagesAction.createStringNode(UsageViewBundle.message("progress.searching", new Object[0])));
        }
        data2.sort(Holder.USAGE_NODE_COMPARATOR);
        ArrayList<UsageNode> arrayList = data2;
        if (arrayList == null) {
            ShowUsagesAction.$$$reportNull$$$0(54);
        }
        return arrayList;
    }

    private static int calcMaxWidth(@NotNull JTable table) {
        if (table == null) {
            ShowUsagesAction.$$$reportNull$$$0(55);
        }
        int colsNum = table.getColumnModel().getColumnCount();
        int totalWidth = 0;
        for (int col = 0; col < colsNum - 1; ++col) {
            TableColumn column = table.getColumnModel().getColumn(col);
            int preferred = column.getPreferredWidth();
            int width = Math.max(preferred, ShowUsagesAction.columnMaxWidth(table, col));
            totalWidth += width;
            column.setMinWidth(width);
            column.setMaxWidth(width);
            column.setWidth(width);
            column.setPreferredWidth(width);
        }
        return totalWidth += ShowUsagesAction.columnMaxWidth(table, colsNum - 1);
    }

    private static int columnMaxWidth(@NotNull JTable table, int col) {
        if (table == null) {
            ShowUsagesAction.$$$reportNull$$$0(56);
        }
        TableColumn column = table.getColumnModel().getColumn(col);
        int width = 0;
        for (int row = 0; row < table.getRowCount(); ++row) {
            Component component2 = table.prepareRenderer(column.getCellRenderer(), row, col);
            int rendererWidth = component2.getPreferredSize().width;
            width = Math.max(width, rendererWidth + table.getIntercellSpacing().width);
        }
        return width;
    }

    private static void rebuildTable(@NotNull UsageViewImpl usageView, @NotNull List<? extends Usage> usages, @NotNull List<UsageNode> nodes, @NotNull ShowUsagesTable table, @Nullable JBPopup popup2, @NotNull Consumer<String> statusConsumer, @NotNull RelativePoint popupPosition, @NotNull IntRef minWidth, boolean findUsagesInProgress) {
        boolean hasOutsideScopeUsages;
        if (usageView == null) {
            ShowUsagesAction.$$$reportNull$$$0(57);
        }
        if (usages == null) {
            ShowUsagesAction.$$$reportNull$$$0(58);
        }
        if (nodes == null) {
            ShowUsagesAction.$$$reportNull$$$0(59);
        }
        if (table == null) {
            ShowUsagesAction.$$$reportNull$$$0(60);
        }
        if (statusConsumer == null) {
            ShowUsagesAction.$$$reportNull$$$0(61);
        }
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(62);
        }
        if (minWidth == null) {
            ShowUsagesAction.$$$reportNull$$$0(63);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        boolean shouldShowMoreSeparator = usages.contains(ShowUsagesTable.MORE_USAGES_SEPARATOR);
        if (shouldShowMoreSeparator) {
            nodes.add(Holder.MORE_USAGES_SEPARATOR_NODE);
        }
        if ((hasOutsideScopeUsages = usages.contains(ShowUsagesTable.USAGES_OUTSIDE_SCOPE_SEPARATOR)) && !shouldShowMoreSeparator) {
            nodes.add(Holder.USAGES_OUTSIDE_SCOPE_NODE);
        }
        boolean hasMore = shouldShowMoreSeparator || hasOutsideScopeUsages;
        statusConsumer.accept(ShowUsagesAction.getStatusString(findUsagesInProgress, hasMore, nodes.size(), usages.size()));
        List<UsageNode> data2 = ShowUsagesAction.collectData(usages, nodes, usageView);
        ShowUsagesTable.MyModel tableModel = table.setTableModel(data2);
        List existingData = tableModel.getItems();
        int row = table.getSelectedRow();
        int newSelection = ShowUsagesAction.updateModel(tableModel, existingData, data2, row == -1 ? 0 : row);
        if (newSelection < 0 || newSelection >= tableModel.getRowCount()) {
            ScrollingUtil.ensureSelectionExists(table);
            newSelection = table.getSelectedRow();
        } else {
            Object valueInTopRow;
            if (newSelection == 0 && table.getModel().getRowCount() > 1 && (valueInTopRow = table.getModel().getValueAt(0, 0)) instanceof UsageNode && usageView.isOriginUsage(((UsageNode)valueInTopRow).getUsage())) {
                ++newSelection;
            }
            table.getSelectionModel().setSelectionInterval(newSelection, newSelection);
        }
        ScrollingUtil.ensureIndexIsVisible(table, newSelection, 0);
        if (popup2 != null) {
            ShowUsagesAction.setSizeAndDimensions(table, popup2, popupPosition, minWidth, data2);
        }
    }

    private static int updateModel(@NotNull ShowUsagesTable.MyModel tableModel, @NotNull List<? extends UsageNode> listOld, @NotNull List<? extends UsageNode> listNew, int oldSelection) {
        if (tableModel == null) {
            ShowUsagesAction.$$$reportNull$$$0(64);
        }
        if (listOld == null) {
            ShowUsagesAction.$$$reportNull$$$0(65);
        }
        if (listNew == null) {
            ShowUsagesAction.$$$reportNull$$$0(66);
        }
        Object[] oa = listOld.toArray(new UsageNode[0]);
        Object[] na = listNew.toArray(new UsageNode[0]);
        List<ModelDiff.Cmd> cmds = ModelDiff.createDiffCmds(tableModel, oa, na);
        int selection = oldSelection;
        if (cmds != null) {
            for (ModelDiff.Cmd cmd : cmds) {
                selection = cmd.translateSelection(selection);
                cmd.apply();
            }
        }
        return selection;
    }

    private static void setSizeAndDimensions(@NotNull JTable table, @NotNull JBPopup popup2, @NotNull RelativePoint popupPosition, @NotNull IntRef minWidth, @NotNull List<? extends UsageNode> data2) {
        if (table == null) {
            ShowUsagesAction.$$$reportNull$$$0(67);
        }
        if (popup2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(68);
        }
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(69);
        }
        if (minWidth == null) {
            ShowUsagesAction.$$$reportNull$$$0(70);
        }
        if (data2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(71);
        }
        JComponent content2 = popup2.getContent();
        Window window = SwingUtilities.windowForComponent(content2);
        Dimension d = window.getSize();
        int width = ShowUsagesAction.calcMaxWidth(table);
        width = (int)Math.max(d.getWidth(), (double)width);
        Dimension headerSize = ((AbstractPopup)popup2).getHeaderPreferredSize();
        width = Math.max((int)headerSize.getWidth(), width);
        width = Math.max(minWidth.get(), width);
        int delta = minWidth.get() == -1 ? 0 : width - minWidth.get();
        int newWidth = Math.max(width, d.width + delta);
        minWidth.set(newWidth);
        Dimension footerSize = ((AbstractPopup)popup2).getFooterPreferredSize();
        int footer = footerSize.height;
        int footerBorder = footer == 0 ? 0 : 1;
        Insets insets = ((AbstractPopup)popup2).getPopupBorder().getBorderInsets(content2);
        int minHeight = headerSize.height + footer + footerBorder + insets.top + insets.bottom;
        Rectangle rectangle = ShowUsagesAction.getPreferredBounds(table, popupPosition.getScreenPoint(), newWidth, minHeight, data2.size());
        table.setSize(rectangle.width, rectangle.height - minHeight);
        if (!data2.isEmpty()) {
            ScrollingUtil.ensureSelectionExists(table);
        }
        Dimension newDim = rectangle.getSize();
        window.setBounds(rectangle);
        window.setMinimumSize(newDim);
        window.setMaximumSize(newDim);
        window.validate();
        window.repaint();
    }

    @NotNull
    private static Rectangle getPreferredBounds(@NotNull JTable table, @NotNull Point point, int width, int minHeight, int modelRows) {
        if (table == null) {
            ShowUsagesAction.$$$reportNull$$$0(72);
        }
        if (point == null) {
            ShowUsagesAction.$$$reportNull$$$0(73);
        }
        boolean addExtraSpace = Registry.is("ide.preferred.scrollable.viewport.extra.space");
        int visibleRows = Math.min(30, modelRows);
        int rowHeight = table.getRowHeight();
        int space = addExtraSpace && visibleRows < modelRows ? rowHeight / 2 : 0;
        int height = visibleRows * rowHeight + minHeight + space;
        Rectangle bounds2 = new Rectangle(point.x, point.y, width, height);
        ScreenUtil.fitToScreen(bounds2);
        if (bounds2.height != height) {
            bounds2.height = Math.max(1, (bounds2.height - (minHeight += addExtraSpace && space == 0 ? rowHeight / 2 : space)) / rowHeight) * rowHeight + minHeight;
        }
        Rectangle rectangle = bounds2;
        if (rectangle == null) {
            ShowUsagesAction.$$$reportNull$$$0(74);
        }
        return rectangle;
    }

    private static void addUsageNodes(@NotNull GroupNode root, @NotNull UsageViewImpl usageView, @NotNull List<? super UsageNode> outNodes) {
        if (root == null) {
            ShowUsagesAction.$$$reportNull$$$0(75);
        }
        if (usageView == null) {
            ShowUsagesAction.$$$reportNull$$$0(76);
        }
        if (outNodes == null) {
            ShowUsagesAction.$$$reportNull$$$0(77);
        }
        for (UsageNode node : root.getUsageNodes()) {
            Usage usage = node.getUsage();
            if (!usageView.isVisible(usage)) continue;
            node.setParent(root);
            outNodes.add(node);
        }
        for (GroupNode groupNode : root.getSubGroups()) {
            groupNode.setParent(root);
            ShowUsagesAction.addUsageNodes(groupNode, usageView, outNodes);
        }
    }

    private static void navigateAndHint(@NotNull Project project2, @NotNull Usage usage, @NotNull RelativePoint popupPosition, @NotNull String hint, @NotNull ShowUsagesActionHandler actionHandler) {
        if (project2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(78);
        }
        if (usage == null) {
            ShowUsagesAction.$$$reportNull$$$0(79);
        }
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(80);
        }
        if (hint == null) {
            ShowUsagesAction.$$$reportNull$$$0(81);
        }
        if (actionHandler == null) {
            ShowUsagesAction.$$$reportNull$$$0(82);
        }
        usage.navigate(true);
        Editor newEditor = ShowUsagesAction.getEditorFor(usage);
        if (newEditor == null) {
            return;
        }
        ShowUsagesAction.hint(project2, newEditor, popupPosition, false, hint, actionHandler);
    }

    private static void hint(@NotNull Project project2, @Nullable Editor editor, @NotNull RelativePoint popupPosition, boolean isWarning, @NotNull String hint, @NotNull ShowUsagesActionHandler actionHandler) {
        if (project2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(83);
        }
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(84);
        }
        if (hint == null) {
            ShowUsagesAction.$$$reportNull$$$0(85);
        }
        if (actionHandler == null) {
            ShowUsagesAction.$$$reportNull$$$0(86);
        }
        Runnable runnable2 = () -> {
            if (!actionHandler.isValid()) {
                return;
            }
            JComponent label2 = ShowUsagesAction.createHintComponent(ShowUsagesAction.suggestSecondInvocation(hint, ShowUsagesActionHandler.getSecondInvocationTitle(actionHandler)), isWarning, ShowUsagesAction.createSettingsButton(project2, ShowUsagesAction::hideHints, () -> actionHandler.showDialogAndShowUsages(editor)));
            ShowUsagesActionState state = ShowUsagesAction.getState(project2);
            state.continuation = () -> ShowUsagesActionHandler.showUsagesInMaximalScope(actionHandler);
            ShowUsagesAction.runWhenHidden(label2, () -> {
                state.continuation = null;
            });
            if (editor == null || editor.isDisposed() || !editor.getComponent().isShowing()) {
                int flags = 42;
                HintManager.getInstance().showHint(label2, popupPosition, flags, 0);
            } else {
                HintManager.getInstance().showInformationHint(editor, label2);
            }
        };
        if (editor == null) {
            IdeFocusManager.getInstance(project2).doWhenFocusSettlesDown(() -> IdeFocusManager.getInstance(project2).doWhenFocusSettlesDown(runnable2));
        } else {
            IdeFocusManager.getInstance(project2).doWhenFocusSettlesDown(() -> editor.getScrollingModel().runActionOnScrollingFinished(() -> IdeFocusManager.getInstance(project2).doWhenFocusSettlesDown(() -> AsyncEditorLoader.performWhenLoaded(editor, runnable2))));
        }
    }

    @Nullable
    private static Editor getEditorFor(@NotNull Usage usage) {
        FileEditorLocation location2;
        if (usage == null) {
            ShowUsagesAction.$$$reportNull$$$0(87);
        }
        FileEditor newFileEditor = (location2 = usage.getLocation()) == null ? null : location2.getEditor();
        return newFileEditor instanceof TextEditor ? ((TextEditor)newFileEditor).getEditor() : null;
    }

    @NotNull
    private static ShowUsagesActionState getState(@NotNull Project project2) {
        if (project2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(88);
        }
        ShowUsagesActionState showUsagesActionState = ServiceManager.getService(project2, ShowUsagesActionState.class);
        if (showUsagesActionState == null) {
            ShowUsagesAction.$$$reportNull$$$0(89);
        }
        return showUsagesActionState;
    }

    private static void runWhenHidden(@NotNull Component c, @NotNull Runnable r) {
        if (c == null) {
            ShowUsagesAction.$$$reportNull$$$0(90);
        }
        if (r == null) {
            ShowUsagesAction.$$$reportNull$$$0(91);
        }
        c.addHierarchyListener(ShowUsagesAction.runWhenHidden(r));
    }

    @NotNull
    private static HierarchyListener runWhenHidden(final @NotNull Runnable r) {
        if (r == null) {
            ShowUsagesAction.$$$reportNull$$$0(92);
        }
        return new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (!BitUtil.isSet(e.getChangeFlags(), 2L)) {
                    return;
                }
                Component component2 = e.getComponent();
                if (component2.isDisplayable()) {
                    return;
                }
                r.run();
                component2.removeHierarchyListener(this);
            }
        };
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public void startFindUsages(@NotNull PsiElement element2, @NotNull RelativePoint popupPosition, @Nullable Editor editor, int maxUsages) {
        if (element2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(93);
        }
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(94);
        }
        ShowUsagesAction.startFindUsages(element2, popupPosition, editor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 21: 
            case 36: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 54: 
            case 74: 
            case 89: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 21: 
            case 36: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 54: 
            case 74: 
            case 89: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 18: 
            case 62: 
            case 69: 
            case 80: 
            case 84: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupPosition";
                break;
            }
            case 4: 
            case 28: 
            case 47: 
            case 53: 
            case 57: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageView";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pingEDT";
                break;
            }
            case 7: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 9: 
            case 12: 
            case 33: 
            case 63: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minWidth";
                break;
            }
            case 10: 
            case 22: 
            case 27: 
            case 37: 
            case 78: 
            case 83: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageSearcher";
                break;
            }
            case 15: 
            case 35: 
            case 82: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionHandler";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 17: 
            case 40: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondInvocationTitle";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
            case 21: 
            case 36: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 54: 
            case 74: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/actions/ShowUsagesAction";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancelAction";
                break;
            }
            case 24: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "showDialogAndFindUsagesRunnable";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionsConsumer";
                break;
            }
            case 29: 
            case 55: 
            case 56: 
            case 60: 
            case 67: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemChoseCallback";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusPanel";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pinGroup";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findUsagesRunnable";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 46: 
            case 50: 
            case 51: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 48: 
            case 79: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibleUsage";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibleNodes";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusConsumer";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableModel";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOld";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listNew";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outNodes";
                break;
            }
            case 81: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hint";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 91: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/actions/ShowUsagesAction";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createHintComponent";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsagePopup";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusString";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestSecondInvocation";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "collectData";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredBounds";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: 
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "startFindUsages";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "rulesChanged";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "showElementUsages";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createStringNode";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "showPopupIfNeedTo";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createHintComponent";
                break;
            }
            case 21: 
            case 36: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 54: 
            case 74: 
            case 89: {
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createSettingsButton";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "showDialog";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createUsagePopup";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "createPinButton";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "suggestSecondInvocation";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "filtered";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getUsageOffset";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "areAllUsagesInOneLine";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "collectData";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "calcMaxWidth";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "columnMaxWidth";
                break;
            }
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "rebuildTable";
                break;
            }
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "updateModel";
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "setSizeAndDimensions";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "getPreferredBounds";
                break;
            }
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "addUsageNodes";
                break;
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "navigateAndHint";
                break;
            }
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "hint";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "getEditorFor";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 90: 
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "runWhenHidden";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 21: 
            case 36: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 54: 
            case 74: 
            case 89: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Service
    private static final class ShowUsagesActionState {
        Runnable continuation;

        private ShowUsagesActionState() {
        }
    }

    static class StringNode
    extends UsageNode {
        @NotNull
        private final Object myString;

        private StringNode(@NotNull Object string) {
            if (string == null) {
                StringNode.$$$reportNull$$$0(0);
            }
            super(null, NullUsage.INSTANCE);
            this.myString = string;
        }

        @Override
        public String toString() {
            return this.myString.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/find/actions/ShowUsagesAction$StringNode", "<init>"));
        }
    }

    private static class Holder {
        private static final UsageNode USAGES_OUTSIDE_SCOPE_NODE = new UsageNode(null, ShowUsagesTable.USAGES_OUTSIDE_SCOPE_SEPARATOR);
        private static final UsageNode MORE_USAGES_SEPARATOR_NODE = UsageViewImpl.NULL_NODE;
        private static final Comparator<UsageNode> USAGE_NODE_COMPARATOR = (c1, c2) -> {
            VirtualFile v2;
            String name2;
            int weight2;
            int weight1;
            if (c1 instanceof StringNode || c2 instanceof StringNode) {
                if (c1 instanceof StringNode && c2 instanceof StringNode) {
                    return Comparing.compare(c1.toString(), c2.toString());
                }
                return c1 instanceof StringNode ? 1 : -1;
            }
            Usage o1 = c1.getUsage();
            Usage o2 = c2.getUsage();
            int n = o1 == ShowUsagesTable.USAGES_OUTSIDE_SCOPE_SEPARATOR ? 2 : (weight1 = o1 == ShowUsagesTable.MORE_USAGES_SEPARATOR ? 1 : 0);
            int n2 = o2 == ShowUsagesTable.USAGES_OUTSIDE_SCOPE_SEPARATOR ? 2 : (weight2 = o2 == ShowUsagesTable.MORE_USAGES_SEPARATOR ? 1 : 0);
            if (weight1 != weight2) {
                return weight1 - weight2;
            }
            if (o1 instanceof Comparable && o2 instanceof Comparable) {
                return ((Comparable)((Object)o1)).compareTo(o2);
            }
            VirtualFile v1 = UsageListCellRenderer.getVirtualFile(o1);
            String name1 = v1 == null ? null : v1.getName();
            int i = Comparing.compare(name1, name2 = (v2 = UsageListCellRenderer.getVirtualFile(o2)) == null ? null : v2.getName());
            if (i != 0) {
                return i;
            }
            if (Comparing.equal(v1, v2)) {
                FileEditorLocation loc1 = o1.getLocation();
                FileEditorLocation loc2 = o2.getLocation();
                return Comparing.compare(loc1, loc2);
            }
            String path1 = v1 == null ? null : v1.getPath();
            String path2 = v2 == null ? null : v2.getPath();
            return Comparing.compare(path1, path2);
        };

        private Holder() {
        }
    }
}

