/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.find.actions.ShowUsagesAction;
import com.intellij.find.actions.ShowUsagesTableCellRenderer;
import com.intellij.ide.util.gotoByName.ModelDiff;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TableUtil;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.table.JBTable;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageToPsiElementProvider;
import com.intellij.usages.impl.GroupNode;
import com.intellij.usages.impl.NullUsage;
import com.intellij.usages.impl.UsageAdapter;
import com.intellij.usages.impl.UsageNode;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ShowUsagesTable
extends JBTable
implements DataProvider {
    static final Usage MORE_USAGES_SEPARATOR = NullUsage.INSTANCE;
    static final Usage USAGES_OUTSIDE_SCOPE_SEPARATOR = new UsageAdapter();
    private static final int MARGIN = 2;
    private final ShowUsagesTableCellRenderer myRenderer;

    ShowUsagesTable(@NotNull ShowUsagesTableCellRenderer renderer) {
        if (renderer == null) {
            ShowUsagesTable.$$$reportNull$$$0(0);
        }
        this.myRenderer = renderer;
        ScrollingUtil.installActions(this);
        HintUpdateSupply.installDataContextHintUpdateSupply(this);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            ShowUsagesTable.$$$reportNull$$$0(1);
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            int[] selected2 = this.getSelectedRows();
            if (selected2.length == 1) {
                return ShowUsagesTable.getPsiElementForHint(this.getValueAt(selected2[0], 0));
            }
        } else if (LangDataKeys.POSITION_ADJUSTER_POPUP.is(dataId)) {
            return PopupUtil.getPopupContainerFor(this);
        }
        return null;
    }

    @Override
    public int getRowHeight() {
        return super.getRowHeight() + 4;
    }

    @Override
    @NotNull
    public Component prepareRenderer(@NotNull TableCellRenderer renderer, int row, int column) {
        Component component2;
        if (renderer == null) {
            ShowUsagesTable.$$$reportNull$$$0(2);
        }
        if ((component2 = super.prepareRenderer(renderer, row, column)) instanceof JComponent) {
            ((JComponent)component2).setBorder(JBUI.Borders.empty(2, 2, 2, 0));
        }
        Component component3 = component2;
        if (component3 == null) {
            ShowUsagesTable.$$$reportNull$$$0(3);
        }
        return component3;
    }

    @NotNull
    Runnable prepareTable(boolean previewMode, @NotNull Runnable appendMoreUsageRunnable, @NotNull Runnable showInMaximalScopeRunnable) {
        if (appendMoreUsageRunnable == null) {
            ShowUsagesTable.$$$reportNull$$$0(4);
        }
        if (showInMaximalScopeRunnable == null) {
            ShowUsagesTable.$$$reportNull$$$0(5);
        }
        MySpeedSearch speedSearch = new MySpeedSearch(this);
        speedSearch.setComparator(new SpeedSearchComparator(false));
        this.setRowHeight(PlatformIcons.CLASS_ICON.getIconHeight() + 2);
        this.setShowGrid(false);
        this.setShowVerticalLines(false);
        this.setShowHorizontalLines(false);
        this.setTableHeader(null);
        this.setAutoResizeMode(3);
        this.setIntercellSpacing(new Dimension(0, 0));
        AtomicReference selectedUsages = new AtomicReference();
        AtomicBoolean moreUsagesSelected = new AtomicBoolean();
        AtomicBoolean outsideScopeUsagesSelected = new AtomicBoolean();
        this.getSelectionModel().addListSelectionListener(e -> {
            selectedUsages.set(null);
            outsideScopeUsagesSelected.set(false);
            moreUsagesSelected.set(false);
            ArrayList<Object> usages = null;
            for (int i : this.getSelectedRows()) {
                Object value2 = this.getValueAt(i, 0);
                if (!(value2 instanceof UsageNode)) continue;
                Usage usage = ((UsageNode)value2).getUsage();
                if (usage == USAGES_OUTSIDE_SCOPE_SEPARATOR) {
                    outsideScopeUsagesSelected.set(true);
                    usages = null;
                    break;
                }
                if (usage == MORE_USAGES_SEPARATOR) {
                    moreUsagesSelected.set(true);
                    usages = null;
                    break;
                }
                if (usages == null) {
                    usages = new ArrayList<Object>();
                }
                usages.add(usage instanceof UsageInfo2UsageAdapter ? ((UsageInfo2UsageAdapter)usage).getUsageInfo().copy() : usage);
            }
            selectedUsages.set(usages);
        });
        final Runnable itemChosenCallback = () -> {
            if (moreUsagesSelected.get()) {
                appendMoreUsageRunnable.run();
                return;
            }
            if (outsideScopeUsagesSelected.get()) {
                showInMaximalScopeRunnable.run();
                return;
            }
            List usages = (List)selectedUsages.get();
            if (usages != null) {
                for (Object usage : usages) {
                    if (usage instanceof UsageInfo) {
                        UsageViewUtil.navigateTo((UsageInfo)usage, true);
                        continue;
                    }
                    if (!(usage instanceof Navigatable)) continue;
                    ((Navigatable)usage).navigate(true);
                }
            }
        };
        if (previewMode) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (UIUtil.isActionClick(e, 502) && !UIUtil.isSelectionButtonDown(e) && !e.isConsumed()) {
                        itemChosenCallback.run();
                    }
                }
            });
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        itemChosenCallback.run();
                    }
                }
            });
        }
        Runnable runnable2 = itemChosenCallback;
        if (runnable2 == null) {
            ShowUsagesTable.$$$reportNull$$$0(6);
        }
        return runnable2;
    }

    @Nullable
    private static PsiElement getPsiElementForHint(Object selectedValue) {
        PsiElement element2;
        Usage usage;
        if (selectedValue instanceof UsageNode && (usage = ((UsageNode)selectedValue).getUsage()) instanceof UsageInfo2UsageAdapter && (element2 = ((UsageInfo2UsageAdapter)usage).getElement()) != null) {
            PsiElement view = UsageToPsiElementProvider.findAppropriateParentFrom(element2);
            return view == null ? element2 : view;
        }
        return null;
    }

    private static int calcColumnCount(@NotNull List<UsageNode> data2) {
        if (data2 == null) {
            ShowUsagesTable.$$$reportNull$$$0(7);
        }
        return data2.isEmpty() || data2.get(0) instanceof ShowUsagesAction.StringNode ? 1 : 4;
    }

    @NotNull
    MyModel setTableModel(@NotNull List<UsageNode> data2) {
        MyModel model;
        if (data2 == null) {
            ShowUsagesTable.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        int columnCount = ShowUsagesTable.calcColumnCount(data2);
        MyModel myModel = model = this.getModel() instanceof MyModel ? (MyModel)this.getModel() : null;
        if (model == null || model.getColumnCount() != columnCount) {
            model = new MyModel(data2, columnCount);
            this.setModel(model);
            for (int i = 0; i < this.getColumnModel().getColumnCount(); ++i) {
                TableColumn column = this.getColumnModel().getColumn(i);
                column.setPreferredWidth(0);
                column.setCellRenderer(this.myRenderer);
            }
        }
        MyModel myModel2 = model;
        if (myModel2 == null) {
            ShowUsagesTable.$$$reportNull$$$0(9);
        }
        return myModel2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/actions/ShowUsagesTable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appendMoreUsageRunnable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "showInMaximalScopeRunnable";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/actions/ShowUsagesTable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareRenderer";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareTable";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "setTableModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "prepareRenderer";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "prepareTable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "calcColumnCount";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setTableModel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class MyModel
    extends ListTableModel<UsageNode>
    implements ModelDiff.Model<Object> {
        private MyModel(@NotNull List<UsageNode> data2, int cols) {
            if (data2 == null) {
                MyModel.$$$reportNull$$$0(0);
            }
            super((ColumnInfo[])MyModel.cols(cols), data2, 0);
        }

        @NotNull
        private static ColumnInfo<UsageNode, UsageNode>[] cols(int cols) {
            ColumnInfo<UsageNode, UsageNode> o = new ColumnInfo<UsageNode, UsageNode>(""){

                @Override
                @Nullable
                public UsageNode valueOf(UsageNode node) {
                    return node;
                }
            };
            List<1> list2 = Collections.nCopies(cols, o);
            ColumnInfo<I, A>[] columnInfoArray = list2.toArray(ColumnInfo.emptyArray());
            if (columnInfoArray == null) {
                MyModel.$$$reportNull$$$0(1);
            }
            return columnInfoArray;
        }

        @Override
        public void addToModel(int idx, Object element2) {
            UsageNode node;
            UsageNode usageNode = node = element2 instanceof UsageNode ? (UsageNode)element2 : ShowUsagesAction.createStringNode(element2);
            if (idx < this.getRowCount()) {
                this.insertRow(idx, node);
            } else {
                this.addRow(node);
            }
        }

        @Override
        public void removeRangeFromModel(int start2, int end) {
            for (int i = end; i >= start2; --i) {
                this.removeRow(i);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/find/actions/ShowUsagesTable$MyModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/find/actions/ShowUsagesTable$MyModel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "cols";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MySpeedSearch
    extends SpeedSearchBase<JTable> {
        MySpeedSearch(@NotNull ShowUsagesTable table) {
            if (table == null) {
                MySpeedSearch.$$$reportNull$$$0(0);
            }
            super(table);
        }

        @Override
        protected int getSelectedIndex() {
            return this.getTable().getSelectedRow();
        }

        @Override
        protected int convertIndexToModel(int viewIndex) {
            return this.getTable().convertRowIndexToModel(viewIndex);
        }

        @Override
        protected Object @NotNull [] getAllElements() {
            Object[] objectArray = ((MyModel)this.getTable().getModel()).getItems().toArray();
            if (objectArray == null) {
                MySpeedSearch.$$$reportNull$$$0(1);
            }
            return objectArray;
        }

        @Override
        protected String getElementText(@NotNull Object element2) {
            if (element2 == null) {
                MySpeedSearch.$$$reportNull$$$0(2);
            }
            if (!(element2 instanceof UsageNode)) {
                return element2.toString();
            }
            UsageNode node = (UsageNode)element2;
            if (node instanceof ShowUsagesAction.StringNode) {
                return "";
            }
            Usage usage = node.getUsage();
            if (usage == MORE_USAGES_SEPARATOR || usage == USAGES_OUTSIDE_SCOPE_SEPARATOR) {
                return "";
            }
            GroupNode group = (GroupNode)node.getParent();
            String groupText = group == null ? "" : group.getGroup().getText(null);
            return groupText + usage.getPresentation().getPlainText();
        }

        @Override
        protected void selectElement(Object element2, String selectedText) {
            List data2 = ((MyModel)this.getTable().getModel()).getItems();
            int i = data2.indexOf(element2);
            if (i == -1) {
                return;
            }
            int viewRow = this.getTable().convertRowIndexToView(i);
            this.getTable().getSelectionModel().setSelectionInterval(viewRow, viewRow);
            TableUtil.scrollSelectionToVisible(this.getTable());
        }

        private ShowUsagesTable getTable() {
            return (ShowUsagesTable)this.myComponent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/find/actions/ShowUsagesTable$MySpeedSearch";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/find/actions/ShowUsagesTable$MySpeedSearch";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllElements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getElementText";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

