/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.find.actions.ShowUsagesAction;
import com.intellij.find.actions.ShowUsagesTable;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.DirtyUI;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.usages.TextChunk;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsagePresentation;
import com.intellij.usages.impl.GroupNode;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.impl.UsageViewManagerImpl;
import com.intellij.usages.rules.UsageInFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ShowUsagesTableCellRenderer
implements TableCellRenderer {
    private final UsageViewImpl myUsageView;
    @NotNull
    private final AtomicInteger myOutOfScopeUsages;
    @NotNull
    private final SearchScope mySearchScope;
    private static final int CURRENT_ASTERISK_COL = 0;
    private static final int FILE_GROUP_COL = 1;
    private static final int LINE_NUMBER_COL = 2;
    private static final int USAGE_TEXT_COL = 3;

    ShowUsagesTableCellRenderer(@NotNull UsageViewImpl usageView, @NotNull AtomicInteger outOfScopeUsages, @NotNull SearchScope searchScope) {
        if (usageView == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(0);
        }
        if (outOfScopeUsages == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(1);
        }
        if (searchScope == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(2);
        }
        this.myUsageView = usageView;
        this.myOutOfScopeUsages = outOfScopeUsages;
        this.mySearchScope = searchScope;
    }

    @Override
    @DirtyUI
    public Component getTableCellRendererComponent(JTable list2, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
        Color rowForeground;
        UsageNode usageNode = value2 instanceof UsageNode ? (UsageNode)value2 : null;
        Usage usage = usageNode == null ? null : usageNode.getUsage();
        Color fileBgColor = this.getBackgroundColor(isSelected, usage);
        Color selectionBg = UIUtil.getListSelectionBackground(true);
        Color selectionFg = UIUtil.getListSelectionForeground();
        Color rowBackground = isSelected ? selectionBg : (fileBgColor == null ? list2.getBackground() : fileBgColor);
        Color color = rowForeground = isSelected ? selectionFg : list2.getForeground();
        if (usageNode == null || usageNode instanceof ShowUsagesAction.StringNode) {
            SimpleColoredComponent textChunks = new SimpleColoredComponent();
            textChunks.append(ObjectUtils.notNull(value2, "").toString(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            return ShowUsagesTableCellRenderer.textComponentSpanningWholeRow(textChunks, rowBackground, rowForeground, column, list2);
        }
        if (usage == ShowUsagesTable.MORE_USAGES_SEPARATOR) {
            SimpleColoredComponent textChunks = new SimpleColoredComponent();
            textChunks.append("...<");
            textChunks.append("more usages", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            textChunks.append(">...");
            return ShowUsagesTableCellRenderer.textComponentSpanningWholeRow(textChunks, rowBackground, rowForeground, column, list2);
        }
        if (usage == ShowUsagesTable.USAGES_OUTSIDE_SCOPE_SEPARATOR) {
            SimpleColoredComponent textChunks = new SimpleColoredComponent();
            textChunks.append("...<");
            textChunks.append(UsageViewManagerImpl.outOfScopeMessage(this.myOutOfScopeUsages.get(), this.mySearchScope), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            textChunks.append(">...");
            return ShowUsagesTableCellRenderer.textComponentSpanningWholeRow(textChunks, rowBackground, rowForeground, column, list2);
        }
        LayoutManager layout = column == 3 ? new BorderLayout() : new FlowLayout(column == 2 ? 2 : 0, 0, 0){

            @Override
            public void layoutContainer(Container container2) {
                super.layoutContainer(container2);
                for (Component component2 : container2.getComponents()) {
                    Rectangle b = component2.getBounds();
                    Insets insets = container2.getInsets();
                    component2.setBounds(b.x, b.y, b.width, container2.getSize().height - insets.top - insets.bottom);
                }
            }
        };
        JPanel panel2 = new JPanel(layout);
        panel2.setFont(null);
        boolean isOriginUsage = this.myUsageView.isOriginUsage(usage);
        if (isOriginUsage) {
            rowBackground = ShowUsagesTableCellRenderer.slightlyDifferentColor(rowBackground);
            if (fileBgColor != null) {
                fileBgColor = ShowUsagesTableCellRenderer.slightlyDifferentColor(fileBgColor);
            }
            selectionBg = ShowUsagesTableCellRenderer.slightlyDifferentColor(selectionBg);
        }
        panel2.setBackground(rowBackground);
        panel2.setForeground(rowForeground);
        SimpleColoredComponent textChunks = new SimpleColoredComponent();
        UsagePresentation presentation = usage.getPresentation();
        TextChunk[] text2 = presentation.getText();
        switch (column) {
            case 0: {
                if (!isOriginUsage) break;
                panel2.add(new JLabel(isSelected ? AllIcons.General.ModifiedSelected : AllIcons.General.Modified));
                break;
            }
            case 1: {
                this.appendGroupText(list2, (GroupNode)usageNode.getParent(), panel2, fileBgColor, isSelected);
                break;
            }
            case 2: {
                if (text2.length != 0) {
                    TextChunk chunk = text2[0];
                    textChunks.append(chunk.getText(), ShowUsagesTableCellRenderer.getAttributes(isSelected, fileBgColor, selectionBg, selectionFg, chunk));
                }
                SpeedSearchUtil.applySpeedSearchHighlighting(list2, textChunks, false, isSelected);
                panel2.add(textChunks);
                break;
            }
            case 3: {
                Icon icon2 = presentation.getIcon();
                textChunks.setIcon(icon2 == null ? EmptyIcon.ICON_16 : icon2);
                textChunks.append("").appendTextPadding(JBUIScale.scale(21));
                for (int i = 1; i < text2.length; ++i) {
                    TextChunk chunk = text2[i];
                    textChunks.append(chunk.getText(), ShowUsagesTableCellRenderer.getAttributes(isSelected, fileBgColor, selectionBg, selectionFg, chunk));
                }
                SpeedSearchUtil.applySpeedSearchHighlighting(list2, textChunks, false, isSelected);
                panel2.add(textChunks);
                if (!isOriginUsage) break;
                SimpleColoredComponent origin = new SimpleColoredComponent();
                origin.setIconTextGap(JBUIScale.scale(5));
                SimpleTextAttributes attributes = text2.length == 0 ? SimpleTextAttributes.REGULAR_ATTRIBUTES.derive(-1, new Color(0x808080), null, null) : ShowUsagesTableCellRenderer.getAttributes(isSelected, fileBgColor, selectionBg, selectionFg, text2[0]);
                origin.append("| Current", attributes);
                origin.appendTextPadding(JBUIScale.scale(45));
                panel2.add((Component)origin, "East");
                break;
            }
            default: {
                throw new IllegalStateException("unknown column: " + column);
            }
        }
        return panel2;
    }

    @NotNull
    private static Color slightlyDifferentColor(@NotNull Color back) {
        if (back == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(3);
        }
        Color color = EditorColorsManager.getInstance().isDarkEditor() ? ColorUtil.brighter(back, 3) : ColorUtil.hackBrightness(back, 1, 0.952381f);
        if (color == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(4);
        }
        return color;
    }

    @NotNull
    private static SimpleTextAttributes getAttributes(boolean isSelected, Color fileBgColor, Color selectionBg, Color selectionFg, @NotNull TextChunk chunk) {
        if (chunk == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(5);
        }
        SimpleTextAttributes background = chunk.getSimpleAttributesIgnoreBackground();
        return isSelected ? new SimpleTextAttributes(selectionBg, selectionFg, null, background.getStyle()) : ShowUsagesTableCellRenderer.deriveBgColor(background, fileBgColor);
    }

    @NotNull
    private static Component textComponentSpanningWholeRow(@NotNull SimpleColoredComponent chunks, Color rowBackground, Color rowForeground, final int column, final @NotNull JTable table) {
        if (chunks == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(6);
        }
        if (table == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(7);
        }
        SimpleColoredComponent component2 = new SimpleColoredComponent(){

            @Override
            protected void doPaint(Graphics2D g) {
                int offset = 0;
                TableColumnModel columnModel = table.getColumnModel();
                for (int i = 0; i < column; ++i) {
                    offset += columnModel.getColumn(i).getWidth();
                }
                g.translate(-offset, 0);
                this.setSize(this.getWidth() + offset, this.getHeight());
                super.doPaint(g);
                g.translate(offset, 0);
            }

            @Override
            @NotNull
            public Dimension getPreferredSize() {
                return column == table.getColumnModel().getColumnCount() - 1 ? super.getPreferredSize() : new Dimension(0, 0);
            }
        };
        component2.setBackground(rowBackground);
        component2.setForeground(rowForeground);
        SimpleColoredComponent.ColoredIterator iterator2 = chunks.iterator();
        while (iterator2.hasNext()) {
            iterator2.next();
            String fragment = iterator2.getFragment();
            SimpleTextAttributes attributes = iterator2.getTextAttributes();
            attributes = attributes.derive(attributes.getStyle(), rowForeground, rowBackground, attributes.getWaveColor());
            component2.append(fragment, attributes);
        }
        SimpleColoredComponent simpleColoredComponent = component2;
        if (simpleColoredComponent == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(8);
        }
        return simpleColoredComponent;
    }

    @NotNull
    private static SimpleTextAttributes deriveBgColor(@NotNull SimpleTextAttributes attributes, @Nullable Color fileBgColor) {
        if (attributes == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(9);
        }
        if (fileBgColor != null) {
            attributes = attributes.derive(-1, null, fileBgColor, null);
        }
        SimpleTextAttributes simpleTextAttributes = attributes;
        if (simpleTextAttributes == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(10);
        }
        return simpleTextAttributes;
    }

    private Color getBackgroundColor(boolean isSelected, Usage usage) {
        Color fileBgColor = null;
        if (isSelected) {
            fileBgColor = UIUtil.getListSelectionBackground(true);
        } else {
            Project project2;
            Color color;
            VirtualFile virtualFile2;
            VirtualFile virtualFile3 = virtualFile2 = usage instanceof UsageInFile ? ((UsageInFile)usage).getFile() : null;
            if (virtualFile2 != null && (color = VfsPresentationUtil.getFileBackgroundColor(project2 = this.myUsageView.getProject(), virtualFile2)) != null) {
                fileBgColor = color;
            }
        }
        return fileBgColor;
    }

    private void appendGroupText(@NotNull JTable table, GroupNode node, @NotNull JPanel panel2, Color fileBgColor, boolean isSelected) {
        UsageGroup group;
        if (table == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(11);
        }
        if (panel2 == null) {
            ShowUsagesTableCellRenderer.$$$reportNull$$$0(12);
        }
        UsageGroup usageGroup = group = node == null ? null : node.getGroup();
        if (group == null) {
            return;
        }
        GroupNode parentGroup = (GroupNode)node.getParent();
        this.appendGroupText(table, parentGroup, panel2, fileBgColor, isSelected);
        if (node.canNavigateToSource()) {
            SimpleColoredComponent renderer = new SimpleColoredComponent();
            renderer.setIcon(group.getIcon(false));
            SimpleTextAttributes attributes = ShowUsagesTableCellRenderer.deriveBgColor(SimpleTextAttributes.REGULAR_ATTRIBUTES, fileBgColor);
            renderer.append(group.getText(this.myUsageView), attributes);
            SpeedSearchUtil.applySpeedSearchHighlighting(table, renderer, false, isSelected);
            panel2.add(renderer);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outOfScopeUsages";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "back";
                break;
            }
            case 4: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/actions/ShowUsagesTableCellRenderer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunk";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunks";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/actions/ShowUsagesTableCellRenderer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "slightlyDifferentColor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "textComponentSpanningWholeRow";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "deriveBgColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "slightlyDifferentColor";
                break;
            }
            case 4: 
            case 8: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "textComponentSpanningWholeRow";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "deriveBgColor";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "appendGroupText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

