/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.find.FindBundle;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindProgressIndicator;
import com.intellij.find.FindResult;
import com.intellij.find.FindSettings;
import com.intellij.find.FindUtil;
import com.intellij.find.findInProject.FindInProjectManager;
import com.intellij.find.impl.FindInProjectTask;
import com.intellij.find.impl.FindResultUsageInfo;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.progress.util.TooManyUsagesStatus;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileProvider;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.VirtualFileManagerImpl;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.DefaultSearchScopeProviders;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SearchScopeProvider;
import com.intellij.ui.content.Content;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewContentManager;
import com.intellij.usages.ConfigurableUsageTarget;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.PatternUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindInProjectUtil {
    private static final int USAGES_PER_READ_ACTION = 100;

    private FindInProjectUtil() {
    }

    public static void setDirectoryName(@NotNull FindModel model, @NotNull DataContext dataContext) {
        Module module2;
        VirtualFile virtualFile2;
        if (model == null) {
            FindInProjectUtil.$$$reportNull$$$0(0);
        }
        if (dataContext == null) {
            FindInProjectUtil.$$$reportNull$$$0(1);
        }
        PsiElement psiElement = null;
        Project project2 = CommonDataKeys.PROJECT.getData(dataContext);
        Editor editor = CommonDataKeys.EDITOR.getData(dataContext);
        if (project2 != null && editor == null && !DumbServiceImpl.getInstance(project2).isDumb()) {
            try {
                psiElement = CommonDataKeys.PSI_ELEMENT.getData(dataContext);
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
        }
        String directoryName = null;
        if (psiElement instanceof PsiDirectory) {
            directoryName = ((PsiDirectory)psiElement).getVirtualFile().getPresentableUrl();
        }
        if (directoryName == null && psiElement instanceof PsiDirectoryContainer) {
            PsiDirectory[] directories = ((PsiDirectoryContainer)psiElement).getDirectories();
            String string = directoryName = directories.length == 1 ? directories[0].getVirtualFile().getPresentableUrl() : null;
        }
        if (directoryName == null && (virtualFile2 = CommonDataKeys.VIRTUAL_FILE.getData(dataContext)) != null && virtualFile2.isDirectory()) {
            directoryName = virtualFile2.getPresentableUrl();
        }
        if ((module2 = LangDataKeys.MODULE_CONTEXT.getData(dataContext)) != null) {
            model.setModuleName(module2.getName());
            model.setDirectoryName(null);
            model.setCustomScope(false);
        }
        if ((model.getModuleName() == null || editor == null) && directoryName != null) {
            model.setDirectoryName(directoryName);
            model.setCustomScope(false);
        }
        if (directoryName == null && module2 == null && project2 != null) {
            ChangeList changeList = (ChangeList)ArrayUtil.getFirstElement((Object[])dataContext.getData(VcsDataKeys.CHANGE_LISTS));
            if (changeList == null) {
                Change change = (Change)ArrayUtil.getFirstElement((Object[])dataContext.getData(VcsDataKeys.CHANGES));
                ChangeList changeList2 = changeList = change == null ? null : ChangeListManager.getInstance(project2).getChangeList(change);
            }
            if (changeList != null) {
                SearchScope changeListScope;
                String changeListName = changeList.getName();
                DefaultSearchScopeProviders.ChangeLists changeListsScopeProvider = SearchScopeProvider.EP_NAME.findExtension(DefaultSearchScopeProviders.ChangeLists.class);
                if (changeListsScopeProvider != null && (changeListScope = (SearchScope)((Object)ContainerUtil.find(changeListsScopeProvider.getSearchScopes(project2, dataContext), scope -> scope.getDisplayName().equals(changeListName)))) != null) {
                    model.setCustomScope(true);
                    model.setCustomScopeName(changeListScope.getDisplayName());
                    model.setCustomScope(changeListScope);
                }
            }
        }
        model.setProjectScope(model.getDirectoryName() == null && model.getModuleName() == null && !model.isCustomScope());
    }

    @Deprecated
    @Nullable
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static PsiDirectory getPsiDirectory(@NotNull FindModel findModel, @NotNull Project project2) {
        VirtualFile directory;
        if (findModel == null) {
            FindInProjectUtil.$$$reportNull$$$0(2);
        }
        if (project2 == null) {
            FindInProjectUtil.$$$reportNull$$$0(3);
        }
        return (directory = FindInProjectUtil.getDirectory(findModel)) == null ? null : PsiManager.getInstance(project2).findDirectory(directory);
    }

    @Nullable
    public static VirtualFile getDirectory(@NotNull FindModel findModel) {
        if (findModel == null) {
            FindInProjectUtil.$$$reportNull$$$0(4);
        }
        String directoryName = findModel.getDirectoryName();
        if (findModel.isProjectScope() || StringUtil.isEmptyOrSpaces(directoryName)) {
            return null;
        }
        String path2 = FileUtil.toSystemIndependentName(directoryName);
        VirtualFile virtualFile2 = LocalFileSystem.getInstance().findFileByPath(path2);
        if (virtualFile2 == null || !virtualFile2.isDirectory()) {
            virtualFile2 = null;
            List<VirtualFileSystem> fileSystems = ((VirtualFileManagerImpl)VirtualFileManager.getInstance()).getPhysicalFileSystems();
            for (VirtualFileSystem fs : fileSystems) {
                VirtualFile file2;
                if (!(fs instanceof LocalFileProvider) || (file2 = fs.findFileByPath(path2)) == null || !file2.isDirectory()) continue;
                if (file2.getChildren().length > 0) {
                    virtualFile2 = file2;
                    break;
                }
                if (virtualFile2 != null) continue;
                virtualFile2 = file2;
            }
            if (virtualFile2 == null && !path2.contains("!/")) {
                virtualFile2 = JarFileSystem.getInstance().findFileByPath(path2 + "!/");
            }
        }
        return virtualFile2;
    }

    @NotNull
    public static Condition<CharSequence> createFileMaskCondition(@Nullable String filter2) throws PatternSyntaxException {
        if (filter2 == null) {
            Condition<CharSequence> condition2 = Conditions.alwaysTrue();
            if (condition2 == null) {
                FindInProjectUtil.$$$reportNull$$$0(5);
            }
            return condition2;
        }
        String pattern = "";
        String negativePattern = "";
        List<String> masks = StringUtil.split(filter2, ",");
        for (String mask : masks) {
            if (StringUtil.startsWith(mask = mask.trim(), "!")) {
                negativePattern = negativePattern + (negativePattern.isEmpty() ? "" : "|") + "(" + PatternUtil.convertToRegex(mask.substring(1)) + ")";
                continue;
            }
            pattern = pattern + (pattern.isEmpty() ? "" : "|") + "(" + PatternUtil.convertToRegex(mask) + ")";
        }
        if (pattern.isEmpty()) {
            pattern = PatternUtil.convertToRegex("*");
        }
        final String finalPattern = pattern;
        final String finalNegativePattern = negativePattern;
        return new Condition<CharSequence>(){
            final Pattern regExp;
            final Pattern negativeRegExp;
            {
                this.regExp = Pattern.compile(finalPattern, 2);
                this.negativeRegExp = StringUtil.isEmpty(finalNegativePattern) ? null : Pattern.compile(finalNegativePattern, 2);
            }

            @Override
            public boolean value(CharSequence input) {
                return this.regExp.matcher(input).matches() && (this.negativeRegExp == null || !this.negativeRegExp.matcher(input).matches());
            }
        };
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    public static void findUsages(@NotNull FindModel findModel, @Nullable PsiDirectory psiDirectory, @NotNull Project project2, @NotNull Processor<? super UsageInfo> consumer, @NotNull FindUsagesProcessPresentation processPresentation) {
        if (findModel == null) {
            FindInProjectUtil.$$$reportNull$$$0(6);
        }
        if (project2 == null) {
            FindInProjectUtil.$$$reportNull$$$0(7);
        }
        if (consumer == null) {
            FindInProjectUtil.$$$reportNull$$$0(8);
        }
        if (processPresentation == null) {
            FindInProjectUtil.$$$reportNull$$$0(9);
        }
        FindInProjectUtil.findUsages(findModel, project2, consumer, processPresentation);
    }

    public static void findUsages(@NotNull FindModel findModel, @NotNull Project project2, @NotNull Processor<? super UsageInfo> consumer, @NotNull FindUsagesProcessPresentation processPresentation) {
        if (findModel == null) {
            FindInProjectUtil.$$$reportNull$$$0(10);
        }
        if (project2 == null) {
            FindInProjectUtil.$$$reportNull$$$0(11);
        }
        if (consumer == null) {
            FindInProjectUtil.$$$reportNull$$$0(12);
        }
        if (processPresentation == null) {
            FindInProjectUtil.$$$reportNull$$$0(13);
        }
        FindInProjectUtil.findUsages(findModel, project2, processPresentation, Collections.emptySet(), consumer);
    }

    public static void findUsages(@NotNull FindModel findModel, @NotNull Project project2, @NotNull FindUsagesProcessPresentation processPresentation, @NotNull Set<? extends VirtualFile> filesToStart, @NotNull Processor<? super UsageInfo> consumer) {
        if (findModel == null) {
            FindInProjectUtil.$$$reportNull$$$0(14);
        }
        if (project2 == null) {
            FindInProjectUtil.$$$reportNull$$$0(15);
        }
        if (processPresentation == null) {
            FindInProjectUtil.$$$reportNull$$$0(16);
        }
        if (filesToStart == null) {
            FindInProjectUtil.$$$reportNull$$$0(17);
        }
        if (consumer == null) {
            FindInProjectUtil.$$$reportNull$$$0(18);
        }
        Runnable runnable2 = () -> new FindInProjectTask(findModel, project2, filesToStart).findUsages(processPresentation, consumer);
        if (ProgressManager.getGlobalProgressIndicator() == null) {
            ProgressManager.getInstance().runProcess(runnable2, (ProgressIndicator)new EmptyProgressIndicator());
        } else {
            runnable2.run();
        }
    }

    static boolean processUsagesInFile(@NotNull PsiFile psiFile, @NotNull VirtualFile virtualFile2, @NotNull FindModel findModel, @NotNull Processor<? super UsageInfo> consumer) {
        int before;
        if (psiFile == null) {
            FindInProjectUtil.$$$reportNull$$$0(19);
        }
        if (virtualFile2 == null) {
            FindInProjectUtil.$$$reportNull$$$0(20);
        }
        if (findModel == null) {
            FindInProjectUtil.$$$reportNull$$$0(21);
        }
        if (consumer == null) {
            FindInProjectUtil.$$$reportNull$$$0(22);
        }
        if (findModel.getStringToFind().isEmpty()) {
            return ReadAction.compute(() -> consumer.process(new UsageInfo(psiFile)));
        }
        if (virtualFile2.getFileType().isBinary()) {
            return true;
        }
        Document document = ReadAction.compute(() -> virtualFile2.isValid() ? FileDocumentManager.getInstance().getDocument(virtualFile2) : null);
        if (document == null) {
            return true;
        }
        int[] offsetRef = new int[]{0};
        ProgressIndicator current2 = ProgressManager.getInstance().getProgressIndicator();
        if (current2 == null) {
            throw new IllegalStateException("must find usages under progress");
        }
        ProgressIndicator indicator = ProgressWrapper.unwrapAll(current2);
        TooManyUsagesStatus tooManyUsagesStatus = TooManyUsagesStatus.getFrom(indicator);
        do {
            tooManyUsagesStatus.pauseProcessingIfTooManyUsages();
            before = offsetRef[0];
            boolean success = ReadAction.compute(() -> !psiFile.isValid() || FindInProjectUtil.processSomeOccurrencesInFile(document, findModel, psiFile, offsetRef, consumer));
            if (success) continue;
            return false;
        } while (offsetRef[0] != before);
        return true;
    }

    private static boolean processSomeOccurrencesInFile(@NotNull Document document, @NotNull FindModel findModel, @NotNull PsiFile psiFile, int @NotNull [] offsetRef, @NotNull Processor<? super UsageInfo> consumer) {
        FindResult result2;
        if (document == null) {
            FindInProjectUtil.$$$reportNull$$$0(23);
        }
        if (findModel == null) {
            FindInProjectUtil.$$$reportNull$$$0(24);
        }
        if (psiFile == null) {
            FindInProjectUtil.$$$reportNull$$$0(25);
        }
        if (consumer == null) {
            FindInProjectUtil.$$$reportNull$$$0(26);
        }
        if (offsetRef == null) {
            FindInProjectUtil.$$$reportNull$$$0(27);
        }
        CharSequence text2 = document.getCharsSequence();
        int textLength = document.getTextLength();
        int offset = offsetRef[0];
        Project project2 = psiFile.getProject();
        FindManager findManager = FindManager.getInstance(project2);
        int count = 0;
        while (offset < textLength && (result2 = findManager.findString(text2, offset, findModel, psiFile.getVirtualFile())).isStringFound()) {
            TextRange range2;
            SearchScope customScope;
            int prevOffset = offset;
            if (prevOffset == (offset = result2.getEndOffset()) || offset == result2.getStartOffset()) {
                ++offset;
            }
            if ((customScope = findModel.getCustomScope()) instanceof LocalSearchScope && !((LocalSearchScope)customScope).containsRange(psiFile, range2 = new TextRange(result2.getStartOffset(), result2.getEndOffset()))) continue;
            FindResultUsageInfo info = new FindResultUsageInfo(findManager, psiFile, prevOffset, findModel, result2);
            if (!consumer.process(info)) {
                return false;
            }
            if (++count < 100) continue;
            break;
        }
        offsetRef[0] = offset;
        return true;
    }

    @NotNull
    private static String getTitleForScope(@NotNull FindModel findModel) {
        if (findModel == null) {
            FindInProjectUtil.$$$reportNull$$$0(28);
        }
        String scopeName = findModel.isProjectScope() ? FindBundle.message("find.scope.project.title", new Object[0]) : (findModel.getModuleName() != null ? FindBundle.message("find.scope.module.title", findModel.getModuleName()) : (findModel.getCustomScopeName() != null ? findModel.getCustomScopeName() : FindBundle.message("find.scope.directory.title", findModel.getDirectoryName())));
        String result2 = scopeName;
        if (findModel.getFileFilter() != null) {
            result2 = result2 + " " + FindBundle.message("find.scope.files.with.mask", findModel.getFileFilter());
        }
        String string = result2;
        if (string == null) {
            FindInProjectUtil.$$$reportNull$$$0(29);
        }
        return string;
    }

    @NotNull
    public static UsageViewPresentation setupViewPresentation(@NotNull FindModel findModel) {
        if (findModel == null) {
            FindInProjectUtil.$$$reportNull$$$0(30);
        }
        return FindInProjectUtil.setupViewPresentation(FindSettings.getInstance().isShowResultsInSeparateView(), findModel);
    }

    @NotNull
    public static UsageViewPresentation setupViewPresentation(boolean toOpenInNewTab, @NotNull FindModel findModel) {
        if (findModel == null) {
            FindInProjectUtil.$$$reportNull$$$0(31);
        }
        UsageViewPresentation presentation = new UsageViewPresentation();
        FindInProjectUtil.setupViewPresentation(presentation, toOpenInNewTab, findModel);
        UsageViewPresentation usageViewPresentation = presentation;
        if (usageViewPresentation == null) {
            FindInProjectUtil.$$$reportNull$$$0(32);
        }
        return usageViewPresentation;
    }

    public static void setupViewPresentation(UsageViewPresentation presentation, @NotNull FindModel findModel) {
        if (findModel == null) {
            FindInProjectUtil.$$$reportNull$$$0(33);
        }
        FindInProjectUtil.setupViewPresentation(presentation, FindSettings.getInstance().isShowResultsInSeparateView(), findModel);
    }

    public static void setupViewPresentation(UsageViewPresentation presentation, boolean toOpenInNewTab, @NotNull FindModel findModel) {
        String scope;
        if (findModel == null) {
            FindInProjectUtil.$$$reportNull$$$0(34);
        }
        if (!(scope = FindInProjectUtil.getTitleForScope(findModel)).isEmpty()) {
            scope = Character.toLowerCase(scope.charAt(0)) + scope.substring(1);
        }
        String stringToFind = findModel.getStringToFind();
        presentation.setScopeText(scope);
        if (stringToFind.isEmpty()) {
            presentation.setTabText("Files");
            presentation.setToolwindowTitle("Files in " + scope);
            presentation.setUsagesString("files");
        } else {
            FindModel.SearchContext searchContext = findModel.getSearchContext();
            String contextText = "";
            if (searchContext != FindModel.SearchContext.ANY) {
                contextText = FindBundle.message("find.context.presentation.scope.label", FindInProjectUtil.getPresentableName(searchContext));
            }
            presentation.setTabText(FindBundle.message("find.usage.view.tab.text", stringToFind, contextText));
            presentation.setToolwindowTitle(FindBundle.message("find.usage.view.toolwindow.title", stringToFind, scope, contextText));
            presentation.setUsagesString(FindBundle.message("find.usage.view.usages.text", stringToFind));
            presentation.setUsagesWord(FindBundle.message("occurrence", new Object[0]));
            presentation.setCodeUsagesString(FindBundle.message("found.occurrences", new Object[0]));
            presentation.setContextText(contextText);
        }
        presentation.setOpenInNewTab(toOpenInNewTab);
        presentation.setCodeUsages(false);
        presentation.setUsageTypeFilteringAvailable(true);
        if (findModel.isReplaceState() && findModel.isRegularExpressions()) {
            presentation.setSearchPattern(findModel.compileRegExp());
            try {
                presentation.setReplacePattern(Pattern.compile(findModel.getStringToReplace()));
            }
            catch (Exception e) {
                presentation.setReplacePattern(null);
            }
        } else {
            presentation.setSearchPattern(null);
            presentation.setReplacePattern(null);
        }
        presentation.setReplaceMode(findModel.isReplaceState());
    }

    @NotNull
    public static FindUsagesProcessPresentation setupProcessPresentation(@NotNull Project project2, @NotNull UsageViewPresentation presentation) {
        if (project2 == null) {
            FindInProjectUtil.$$$reportNull$$$0(35);
        }
        if (presentation == null) {
            FindInProjectUtil.$$$reportNull$$$0(36);
        }
        return FindInProjectUtil.setupProcessPresentation(project2, !FindSettings.getInstance().isSkipResultsWithOneUsage(), presentation);
    }

    @NotNull
    public static FindUsagesProcessPresentation setupProcessPresentation(@NotNull Project project2, boolean showPanelIfOnlyOneUsage, @NotNull UsageViewPresentation presentation) {
        if (project2 == null) {
            FindInProjectUtil.$$$reportNull$$$0(37);
        }
        if (presentation == null) {
            FindInProjectUtil.$$$reportNull$$$0(38);
        }
        FindUsagesProcessPresentation processPresentation = new FindUsagesProcessPresentation(presentation);
        processPresentation.setShowNotFoundMessage(true);
        processPresentation.setShowPanelIfOnlyOneUsage(showPanelIfOnlyOneUsage);
        processPresentation.setProgressIndicatorFactory(() -> new FindProgressIndicator(project2, presentation.getScopeText()));
        FindUsagesProcessPresentation findUsagesProcessPresentation = processPresentation;
        if (findUsagesProcessPresentation == null) {
            FindInProjectUtil.$$$reportNull$$$0(39);
        }
        return findUsagesProcessPresentation;
    }

    private static List<PsiElement> getTopLevelRegExpChars(String regExpText, Project project2) {
        PsiElement[] children2;
        PsiFile file2 = PsiFileFactory.getInstance(project2).createFileFromText("A.regexp", regExpText);
        List<PsiElement> result2 = null;
        for (PsiElement child2 : children2 = file2.getChildren()) {
            PsiElement[] grandChildren = child2.getChildren();
            if (grandChildren.length != 1) {
                return Collections.emptyList();
            }
            for (PsiElement grandGrandChild : grandChildren[0].getChildren()) {
                if (result2 == null) {
                    result2 = new ArrayList<PsiElement>();
                }
                result2.add(grandGrandChild);
            }
        }
        return result2 != null ? result2 : Collections.emptyList();
    }

    @NotNull
    public static String buildStringToFindForIndicesFromRegExp(@NotNull String stringToFind, @NotNull Project project2) {
        if (stringToFind == null) {
            FindInProjectUtil.$$$reportNull$$$0(40);
        }
        if (project2 == null) {
            FindInProjectUtil.$$$reportNull$$$0(41);
        }
        if (!Registry.is("idea.regexp.search.uses.indices")) {
            return "";
        }
        String string = ReadAction.compute(() -> {
            final List<PsiElement> topLevelRegExpChars = FindInProjectUtil.getTopLevelRegExpChars("a", project2);
            if (topLevelRegExpChars.size() != 1) {
                return "";
            }
            return StringUtil.join(FindInProjectUtil.getTopLevelRegExpChars(stringToFind, project2), new Function<PsiElement, String>(){
                final Class regExpCharPsiClass;
                {
                    this.regExpCharPsiClass = ((PsiElement)topLevelRegExpChars.get(0)).getClass();
                }

                @Override
                public String fun(PsiElement element2) {
                    String text2;
                    if (this.regExpCharPsiClass.isInstance(element2) && !(text2 = element2.getText()).startsWith("\\")) {
                        return text2;
                    }
                    return " ";
                }
            }, "");
        });
        if (string == null) {
            FindInProjectUtil.$$$reportNull$$$0(42);
        }
        return string;
    }

    public static void initStringToFindFromDataContext(FindModel findModel, @NotNull DataContext dataContext) {
        if (dataContext == null) {
            FindInProjectUtil.$$$reportNull$$$0(43);
        }
        Editor editor = CommonDataKeys.EDITOR.getData(dataContext);
        FindUtil.initStringToFindWithSelection(findModel, editor);
        if (editor == null || !editor.getSelectionModel().hasSelection()) {
            FindUtil.useFindStringFromFindInFileModel(findModel, CommonDataKeys.EDITOR_EVEN_IF_INACTIVE.getData(dataContext));
        }
    }

    private static void addSourceDirectoriesFromLibraries(@NotNull Project project2, @NotNull VirtualFile directory, @NotNull Collection<? super VirtualFile> outSourceRoots) {
        ProjectFileIndex index;
        if (project2 == null) {
            FindInProjectUtil.$$$reportNull$$$0(44);
        }
        if (directory == null) {
            FindInProjectUtil.$$$reportNull$$$0(45);
        }
        if (outSourceRoots == null) {
            FindInProjectUtil.$$$reportNull$$$0(46);
        }
        if (!(index = ProjectFileIndex.SERVICE.getInstance(project2)).isInLibraryClasses(directory)) {
            return;
        }
        VirtualFile classRoot = index.getClassRootForFile(directory);
        if (classRoot == null) {
            return;
        }
        String relativePath = VfsUtilCore.getRelativePath(directory, classRoot);
        if (relativePath == null) {
            return;
        }
        THashSet<VirtualFile> otherSourceRoots = new THashSet<VirtualFile>();
        block0: for (OrderEntry entry : index.getOrderEntriesForFile(directory)) {
            if (entry instanceof LibraryOrderEntry) {
                String[] sourceUrls;
                Library library = ((LibraryOrderEntry)entry).getLibrary();
                if (library == null) continue;
                for (String sourceUrl : sourceUrls = library.getUrls(OrderRootType.SOURCES)) {
                    if (!VfsUtilCore.isEqualOrAncestor(sourceUrl, directory.getUrl())) continue;
                    otherSourceRoots.clear();
                    break block0;
                }
            }
            for (VirtualFile sourceRoot : entry.getFiles(OrderRootType.SOURCES)) {
                VirtualFile sourceFile = sourceRoot.findFileByRelativePath(relativePath);
                if (sourceFile == null) continue;
                otherSourceRoots.add(sourceFile);
            }
        }
        outSourceRoots.addAll(otherSourceRoots);
    }

    @NotNull
    static SearchScope getScopeFromModel(@NotNull Project project2, @NotNull FindModel findModel) {
        Module module2;
        if (project2 == null) {
            FindInProjectUtil.$$$reportNull$$$0(47);
        }
        if (findModel == null) {
            FindInProjectUtil.$$$reportNull$$$0(48);
        }
        SearchScope customScope = findModel.isCustomScope() ? findModel.getCustomScope() : null;
        VirtualFile directory = FindInProjectUtil.getDirectory(findModel);
        Module module3 = module2 = findModel.getModuleName() == null ? null : ModuleManager.getInstance(project2).findModuleByName(findModel.getModuleName());
        SearchScope searchScope = customScope != null ? customScope : (directory != null ? FindInProjectUtil.forDirectory(project2, findModel.isWithSubdirectories(), directory) : (module2 != null ? module2.getModuleContentScope() : (findModel.isProjectScope() ? ProjectScope.getContentScope(project2) : GlobalSearchScope.allScope(project2))));
        if (searchScope == null) {
            FindInProjectUtil.$$$reportNull$$$0(49);
        }
        return searchScope;
    }

    @NotNull
    private static GlobalSearchScope forDirectory(@NotNull Project project2, boolean withSubdirectories, @NotNull VirtualFile directory) {
        if (project2 == null) {
            FindInProjectUtil.$$$reportNull$$$0(50);
        }
        if (directory == null) {
            FindInProjectUtil.$$$reportNull$$$0(51);
        }
        LinkedHashSet<VirtualFile> result2 = new LinkedHashSet<VirtualFile>();
        result2.add(directory);
        FindInProjectUtil.addSourceDirectoriesFromLibraries(project2, directory, result2);
        VirtualFile[] array = result2.toArray(VirtualFile.EMPTY_ARRAY);
        GlobalSearchScope globalSearchScope = GlobalSearchScopesCore.directoriesScope(project2, withSubdirectories, array);
        if (globalSearchScope == null) {
            FindInProjectUtil.$$$reportNull$$$0(52);
        }
        return globalSearchScope;
    }

    public static void initFileFilter(@NotNull JComboBox<? super String> fileFilter, @NotNull JCheckBox useFileFilter) {
        if (fileFilter == null) {
            FindInProjectUtil.$$$reportNull$$$0(53);
        }
        if (useFileFilter == null) {
            FindInProjectUtil.$$$reportNull$$$0(54);
        }
        fileFilter.setEditable(true);
        String[] fileMasks = FindSettings.getInstance().getRecentFileMasks();
        for (int i = fileMasks.length - 1; i >= 0; --i) {
            fileFilter.addItem(fileMasks[i]);
        }
        fileFilter.setEnabled(false);
        useFileFilter.addActionListener(__ -> {
            if (useFileFilter.isSelected()) {
                fileFilter.setEnabled(true);
                fileFilter.getEditor().selectAll();
                fileFilter.getEditor().getEditorComponent().requestFocusInWindow();
            } else {
                fileFilter.setEnabled(false);
            }
        });
    }

    public static String getPresentableName(@NotNull FindModel.SearchContext searchContext) {
        if (searchContext == null) {
            FindInProjectUtil.$$$reportNull$$$0(55);
        }
        String messageKey = null;
        if (searchContext == FindModel.SearchContext.ANY) {
            messageKey = "find.context.anywhere.scope.label";
        } else if (searchContext == FindModel.SearchContext.EXCEPT_COMMENTS) {
            messageKey = "find.context.except.comments.scope.label";
        } else if (searchContext == FindModel.SearchContext.EXCEPT_STRING_LITERALS) {
            messageKey = "find.context.except.literals.scope.label";
        } else if (searchContext == FindModel.SearchContext.EXCEPT_COMMENTS_AND_STRING_LITERALS) {
            messageKey = "find.context.except.comments.and.literals.scope.label";
        } else if (searchContext == FindModel.SearchContext.IN_COMMENTS) {
            messageKey = "find.context.in.comments.scope.label";
        } else if (searchContext == FindModel.SearchContext.IN_STRING_LITERALS) {
            messageKey = "find.context.in.literals.scope.label";
        }
        return messageKey != null ? FindBundle.message(messageKey, new Object[0]) : searchContext.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 29: 
            case 32: 
            case 39: 
            case 42: 
            case 49: 
            case 52: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 29: 
            case 32: 
            case 39: 
            case 42: 
            case 49: 
            case 52: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 10: 
            case 14: 
            case 21: 
            case 24: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findModel";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 15: 
            case 35: 
            case 37: 
            case 41: 
            case 44: 
            case 47: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 29: 
            case 32: 
            case 39: 
            case 42: 
            case 49: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/impl/FindInProjectUtil";
                break;
            }
            case 8: 
            case 12: 
            case 18: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 9: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processPresentation";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToStart";
                break;
            }
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "offsetRef";
                break;
            }
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringToFind";
                break;
            }
            case 45: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outSourceRoots";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileFilter";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "useFileFilter";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/impl/FindInProjectUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileMaskCondition";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitleForScope";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "setupViewPresentation";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "setupProcessPresentation";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "buildStringToFindForIndicesFromRegExp";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeFromModel";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "forDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setDirectoryName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPsiDirectory";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDirectory";
                break;
            }
            case 5: 
            case 29: 
            case 32: 
            case 39: 
            case 42: 
            case 49: 
            case 52: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "processUsagesInFile";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "processSomeOccurrencesInFile";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getTitleForScope";
                break;
            }
            case 30: 
            case 31: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "setupViewPresentation";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "setupProcessPresentation";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "buildStringToFindForIndicesFromRegExp";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "initStringToFindFromDataContext";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "addSourceDirectoriesFromLibraries";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getScopeFromModel";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "forDirectory";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "initFileFilter";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 29: 
            case 32: 
            case 39: 
            case 42: 
            case 49: 
            case 52: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class StringUsageTarget
    implements ConfigurableUsageTarget,
    ItemPresentation,
    TypeSafeDataProvider {
        @NotNull
        protected final Project myProject;
        @NotNull
        protected final FindModel myFindModel;

        public StringUsageTarget(@NotNull Project project2, @NotNull FindModel findModel) {
            if (project2 == null) {
                StringUsageTarget.$$$reportNull$$$0(0);
            }
            if (findModel == null) {
                StringUsageTarget.$$$reportNull$$$0(1);
            }
            this.myProject = project2;
            this.myFindModel = findModel.clone();
        }

        @Override
        @NotNull
        public String getPresentableText() {
            UsageViewPresentation presentation = FindInProjectUtil.setupViewPresentation(false, this.myFindModel);
            String string = presentation.getToolwindowTitle();
            if (string == null) {
                StringUsageTarget.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        public String getLongDescriptiveName() {
            String string = this.getPresentableText();
            if (string == null) {
                StringUsageTarget.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        public String getLocationString() {
            return this.myFindModel + "!!";
        }

        @Override
        public Icon getIcon(boolean open2) {
            return AllIcons.Actions.Find;
        }

        @Override
        public void findUsages() {
            FindInProjectManager.getInstance(this.myProject).startFindInProject(this.myFindModel);
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public String getName() {
            return this.myFindModel.getStringToFind().isEmpty() ? this.myFindModel.getFileFilter() : this.myFindModel.getStringToFind();
        }

        @Override
        public ItemPresentation getPresentation() {
            return this;
        }

        @Override
        public void navigate(boolean requestFocus) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean canNavigate() {
            return false;
        }

        @Override
        public boolean canNavigateToSource() {
            return false;
        }

        @Override
        public void showSettings() {
            Content selectedContent = UsageViewContentManager.getInstance(this.myProject).getSelectedContent(true);
            JComponent component2 = selectedContent == null ? null : selectedContent.getComponent();
            FindInProjectManager findInProjectManager = FindInProjectManager.getInstance(this.myProject);
            findInProjectManager.findInProject(DataManager.getInstance().getDataContext(component2), this.myFindModel);
        }

        @Override
        public KeyboardShortcut getShortcut() {
            return ActionManager.getInstance().getKeyboardShortcut("FindInPath");
        }

        @Override
        public void calcData(@NotNull DataKey key, @NotNull DataSink sink) {
            if (key == null) {
                StringUsageTarget.$$$reportNull$$$0(4);
            }
            if (sink == null) {
                StringUsageTarget.$$$reportNull$$$0(5);
            }
            if (UsageView.USAGE_SCOPE.equals(key)) {
                SearchScope scope = FindInProjectUtil.getScopeFromModel(this.myProject, this.myFindModel);
                sink.put(UsageView.USAGE_SCOPE, scope);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "findModel";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/find/impl/FindInProjectUtil$StringUsageTarget";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/find/impl/FindInProjectUtil$StringUsageTarget";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableText";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLongDescriptiveName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "calcData";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

