/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.ngrams;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.ThreadLocalCachedIntArray;
import com.intellij.openapi.util.text.TrigramBuilder;
import com.intellij.util.indexing.CustomInputsIndexFileBasedIndexExtension;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DocumentChangeDependentIndex;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.THashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class TrigramIndex
extends ScalarIndexExtension<Integer>
implements CustomInputsIndexFileBasedIndexExtension<Integer>,
DocumentChangeDependentIndex {
    @Deprecated
    public static final boolean ENABLED = true;
    public static final ID<Integer, Void> INDEX_ID = ID.create("Trigram.Index");
    private static final FileBasedIndex.InputFilter INPUT_FILTER = file2 -> TrigramIndex.isIndexable(file2.getFileType());
    private static final ThreadLocalCachedIntArray spareBufferLocal = new ThreadLocalCachedIntArray();

    public static boolean isIndexable(FileType fileType) {
        return !fileType.isBinary();
    }

    @Override
    @NotNull
    public ID<Integer, Void> getName() {
        ID<Integer, Void> iD = INDEX_ID;
        if (iD == null) {
            TrigramIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @Override
    @NotNull
    public DataIndexer<Integer, Void, FileContent> getIndexer() {
        return new DataIndexer<Integer, Void, FileContent>(){

            @Override
            @NotNull
            public Map<Integer, Void> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    1.$$$reportNull$$$0(0);
                }
                MyTrigramProcessor trigramProcessor = new MyTrigramProcessor();
                TrigramBuilder.processTrigrams(inputData.getContentAsText(), trigramProcessor);
                Map<Integer, Void> map2 = trigramProcessor.map;
                if (map2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return map2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/find/ngrams/TrigramIndex$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/find/ngrams/TrigramIndex$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @Override
    @NotNull
    public KeyDescriptor<Integer> getKeyDescriptor() {
        EnumeratorIntegerDescriptor enumeratorIntegerDescriptor = EnumeratorIntegerDescriptor.INSTANCE;
        if (enumeratorIntegerDescriptor == null) {
            TrigramIndex.$$$reportNull$$$0(1);
        }
        return enumeratorIntegerDescriptor;
    }

    @Override
    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = INPUT_FILTER;
        if (inputFilter == null) {
            TrigramIndex.$$$reportNull$$$0(2);
        }
        return inputFilter;
    }

    @Override
    public boolean dependsOnFileContent() {
        return true;
    }

    @Override
    public int getVersion() {
        return 3;
    }

    @Override
    public boolean hasSnapshotMapping() {
        return true;
    }

    @Override
    public boolean needsForwardIndexWhenSharing() {
        return false;
    }

    @Override
    @NotNull
    public DataExternalizer<Collection<Integer>> createExternalizer() {
        return new DataExternalizer<Collection<Integer>>(){

            @Override
            public void save(@NotNull DataOutput out, @NotNull Collection<Integer> value2) throws IOException {
                if (out == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (value2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                int numberOfValues = value2.size();
                int[] buffer = spareBufferLocal.getBuffer(numberOfValues);
                int ptr = 0;
                for (Integer i : value2) {
                    buffer[ptr++] = i;
                }
                Arrays.sort(buffer, 0, numberOfValues);
                DataInputOutputUtil.writeINT(out, numberOfValues);
                int prev = 0;
                for (ptr = 0; ptr < numberOfValues; ++ptr) {
                    DataInputOutputUtil.writeLONG(out, (long)buffer[ptr] - (long)prev);
                    prev = buffer[ptr];
                }
            }

            @Override
            @NotNull
            public Collection<Integer> read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    2.$$$reportNull$$$0(2);
                }
                int size = DataInputOutputUtil.readINT(in);
                ArrayList<Integer> result2 = new ArrayList<Integer>(size);
                int prev = 0;
                while (size-- > 0) {
                    int l = (int)(DataInputOutputUtil.readLONG(in) + (long)prev);
                    result2.add(l);
                    prev = l;
                }
                ArrayList<Integer> arrayList = result2;
                if (arrayList == null) {
                    2.$$$reportNull$$$0(3);
                }
                return arrayList;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/find/ngrams/TrigramIndex$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/find/ngrams/TrigramIndex$2";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "read";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "save";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "read";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/find/ngrams/TrigramIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class MyTrigramProcessor
    extends TrigramBuilder.TrigramProcessor {
        Map<Integer, Void> map;

        private MyTrigramProcessor() {
        }

        @Override
        public boolean consumeTrigramsCount(int count) {
            this.map = new THashMap<Integer, Void>(count);
            return true;
        }

        @Override
        public boolean execute(int value2) {
            this.map.put(value2, null);
            return true;
        }
    }
}

