/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.Block;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public interface ASTBlock
extends Block {
    @Nullable
    public ASTNode getNode();

    @Contract(value="null -> null")
    @Nullable
    public static ASTNode getNode(@Nullable Block block) {
        return ObjectUtils.doIfCast(block, ASTBlock.class, it -> it.getNode());
    }

    @Contract(value="null -> null")
    @Nullable
    public static IElementType getElementType(@Nullable Block block) {
        return ObjectUtils.doIfNotNull(ASTBlock.getNode(block), PsiUtilCore::getElementType);
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiElement getPsiElement(@Nullable Block block) {
        return ObjectUtils.doIfNotNull(ASTBlock.getNode(block), it -> it.getPsi());
    }
}

