/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Block;
import com.intellij.formatting.Spacing;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpacingBuilder {
    private static final Logger LOG = Logger.getInstance(SpacingBuilder.class);
    private final CommonCodeStyleSettings myCodeStyleSettings;
    private final List<SpacingRule> myRules;

    @Deprecated
    public SpacingBuilder(CodeStyleSettings codeStyleSettings) {
        this.myRules = new ArrayList<SpacingRule>();
        this.myCodeStyleSettings = new CommonCodeStyleSettings(Language.ANY);
        LOG.error("The plugin calling this method uses deprecated API and must be updated.");
    }

    public SpacingBuilder(@NotNull CodeStyleSettings codeStyleSettings, @NotNull Language language2) {
        if (codeStyleSettings == null) {
            SpacingBuilder.$$$reportNull$$$0(0);
        }
        if (language2 == null) {
            SpacingBuilder.$$$reportNull$$$0(1);
        }
        this.myRules = new ArrayList<SpacingRule>();
        this.myCodeStyleSettings = codeStyleSettings.getCommonSettings(language2);
    }

    public SpacingBuilder(@NotNull CommonCodeStyleSettings languageCodeStyleSettings) {
        if (languageCodeStyleSettings == null) {
            SpacingBuilder.$$$reportNull$$$0(2);
        }
        this.myRules = new ArrayList<SpacingRule>();
        assert (languageCodeStyleSettings.getLanguage() != null) : "Only language code style settings are accepted (getLanguage() != null)";
        this.myCodeStyleSettings = languageCodeStyleSettings;
    }

    public RuleBuilder after(IElementType elementType) {
        return new RuleBuilder(new RuleCondition[]{new RuleCondition(null, TokenSet.create(elementType), null)});
    }

    public RuleBuilder after(TokenSet tokenSet) {
        return new RuleBuilder(new RuleCondition[]{new RuleCondition(null, tokenSet, null)});
    }

    public RuleBuilder afterInside(IElementType elementType, IElementType parentType) {
        return new RuleBuilder(new RuleCondition[]{new RuleCondition(TokenSet.create(parentType), TokenSet.create(elementType), null)});
    }

    public RuleBuilder afterInside(IElementType elementType, TokenSet parentType) {
        return new RuleBuilder(new RuleCondition[]{new RuleCondition(parentType, TokenSet.create(elementType), null)});
    }

    public RuleBuilder afterInside(TokenSet tokenSet, IElementType parentType) {
        return new RuleBuilder(new RuleCondition[]{new RuleCondition(TokenSet.create(parentType), tokenSet, null)});
    }

    public RuleBuilder before(IElementType elementType) {
        return this.before(TokenSet.create(elementType));
    }

    public RuleBuilder before(TokenSet tokenSet) {
        return new RuleBuilder(new RuleCondition[]{new RuleCondition(null, null, tokenSet)});
    }

    public RuleBuilder beforeInside(TokenSet tokenSet, IElementType parentType) {
        return new RuleBuilder(new RuleCondition[]{new RuleCondition(TokenSet.create(parentType), null, tokenSet)});
    }

    public RuleBuilder beforeInside(IElementType elementType, IElementType parentType) {
        return new RuleBuilder(new RuleCondition[]{new RuleCondition(TokenSet.create(parentType), null, TokenSet.create(elementType))});
    }

    public RuleBuilder beforeInside(IElementType elementType, TokenSet parentTypes) {
        return new RuleBuilder(new RuleCondition[]{new RuleCondition(parentTypes, null, TokenSet.create(elementType))});
    }

    public RuleBuilder between(IElementType left, IElementType right) {
        return new RuleBuilder(new RuleCondition[]{new RuleCondition(null, TokenSet.create(left), TokenSet.create(right))});
    }

    public RuleBuilder between(IElementType left, TokenSet rightSet) {
        return new RuleBuilder(new RuleCondition[]{new RuleCondition(null, TokenSet.create(left), rightSet)});
    }

    public RuleBuilder between(TokenSet leftSet, IElementType right) {
        return new RuleBuilder(new RuleCondition[]{new RuleCondition(null, leftSet, TokenSet.create(right))});
    }

    public RuleBuilder between(TokenSet leftType, TokenSet rightType) {
        return new RuleBuilder(new RuleCondition[]{new RuleCondition(null, leftType, rightType)});
    }

    public RuleBuilder betweenInside(IElementType leftType, IElementType rightType, IElementType parentType) {
        return new RuleBuilder(new RuleCondition[]{new RuleCondition(TokenSet.create(parentType), TokenSet.create(leftType), TokenSet.create(rightType))});
    }

    public RuleBuilder betweenInside(TokenSet leftSet, TokenSet rightSet, IElementType parentType) {
        return new RuleBuilder(new RuleCondition[]{new RuleCondition(TokenSet.create(parentType), leftSet, rightSet)});
    }

    public RuleBuilder withinPair(IElementType pairFirst, IElementType pairSecond) {
        RuleCondition before = new RuleCondition(null, TokenSet.create(pairFirst), null);
        RuleCondition after2 = new RuleCondition(null, null, TokenSet.create(pairSecond));
        return new RuleBuilder(new RuleCondition[]{before, after2});
    }

    public RuleBuilder withinPairInside(IElementType pairFirst, IElementType pairSecond, IElementType parent) {
        TokenSet parentSet = TokenSet.create(parent);
        RuleCondition before = new RuleCondition(parentSet, TokenSet.create(pairFirst), null);
        RuleCondition after2 = new RuleCondition(parentSet, null, TokenSet.create(pairSecond));
        return new RuleBuilder(new RuleCondition[]{before, after2});
    }

    public RuleBuilder around(IElementType elementType) {
        return this.around(TokenSet.create(elementType));
    }

    public RuleBuilder around(TokenSet tokenSet) {
        RuleCondition before = new RuleCondition(null, null, tokenSet);
        RuleCondition after2 = new RuleCondition(null, tokenSet, null);
        return new RuleBuilder(new RuleCondition[]{before, after2});
    }

    public RuleBuilder aroundInside(TokenSet tokenSet, TokenSet parent) {
        RuleCondition before = new RuleCondition(parent, null, tokenSet);
        RuleCondition after2 = new RuleCondition(parent, tokenSet, null);
        return new RuleBuilder(new RuleCondition[]{before, after2});
    }

    public RuleBuilder aroundInside(TokenSet tokenSet, IElementType parent) {
        RuleCondition before = new RuleCondition(TokenSet.create(parent), null, tokenSet);
        RuleCondition after2 = new RuleCondition(TokenSet.create(parent), tokenSet, null);
        return new RuleBuilder(new RuleCondition[]{before, after2});
    }

    public RuleBuilder aroundInside(IElementType token, IElementType parent) {
        TokenSet tokenSet = TokenSet.create(token);
        RuleCondition before = new RuleCondition(TokenSet.create(parent), null, tokenSet);
        RuleCondition after2 = new RuleCondition(TokenSet.create(parent), tokenSet, null);
        return new RuleBuilder(new RuleCondition[]{before, after2});
    }

    public RuleBuilder aroundInside(IElementType token, TokenSet parent) {
        TokenSet tokenSet = TokenSet.create(token);
        RuleCondition before = new RuleCondition(parent, null, tokenSet);
        RuleCondition after2 = new RuleCondition(parent, tokenSet, null);
        return new RuleBuilder(new RuleCondition[]{before, after2});
    }

    public SpacingBuilder append(SpacingBuilder builder2) {
        this.myRules.addAll(builder2.myRules);
        return this;
    }

    @Contract(value="_,null,_,_->null; _,_,null,_->null; _,_,_,null->null")
    @Nullable
    public Spacing getSpacing(@NotNull Block parentBlock, @Nullable IElementType parentType, @Nullable IElementType child1Type, @Nullable IElementType child2Type) {
        if (parentBlock == null) {
            SpacingBuilder.$$$reportNull$$$0(3);
        }
        for (SpacingRule rule2 : this.myRules) {
            if (!rule2.matches(parentType, child1Type, child2Type)) continue;
            return rule2.createSpacing(parentBlock.getTextRange());
        }
        return null;
    }

    @Contract(value="null,_,_->null; _,null,_->null; _,_,null->null")
    @Nullable
    public Spacing getSpacing(@Nullable Block parent, @Nullable Block child1, @Nullable Block child2) {
        if (!(parent instanceof ASTBlock && child1 instanceof ASTBlock && child2 instanceof ASTBlock)) {
            return null;
        }
        for (SpacingRule rule2 : this.myRules) {
            if (!rule2.matches((ASTBlock)parent, (ASTBlock)child1, (ASTBlock)child2)) continue;
            return rule2.createSpacing(parent.getTextRange());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeStyleSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageCodeStyleSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentBlock";
                break;
            }
        }
        objectArray2[1] = "com/intellij/formatting/SpacingBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getSpacing";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public class RuleBuilder {
        RuleCondition[] myConditions;

        private RuleBuilder(RuleCondition ... conditions) {
            this.myConditions = conditions;
        }

        public SpacingBuilder none() {
            return this.spaces(0);
        }

        public SpacingBuilder spaceIf(boolean option2) {
            return this.spaceIf(option2, false);
        }

        public SpacingBuilder spaceIf(boolean option2, boolean useParentDependentLFSpacing) {
            return this.spaces(option2 ? 1 : 0, useParentDependentLFSpacing);
        }

        public SpacingBuilder spaces(int count) {
            return this.spaces(count, false);
        }

        public SpacingBuilder spaces(int count, boolean useParentDependentLFSpacing) {
            if (useParentDependentLFSpacing) {
                return this.parentDependentLFSpacing(count, count, ((SpacingBuilder)SpacingBuilder.this).myCodeStyleSettings.KEEP_LINE_BREAKS, ((SpacingBuilder)SpacingBuilder.this).myCodeStyleSettings.KEEP_BLANK_LINES_IN_CODE);
            }
            return this.spacing(count, count, 0, ((SpacingBuilder)SpacingBuilder.this).myCodeStyleSettings.KEEP_LINE_BREAKS, ((SpacingBuilder)SpacingBuilder.this).myCodeStyleSettings.KEEP_BLANK_LINES_IN_CODE);
        }

        public SpacingBuilder blankLines(int count) {
            int blankLines = count + 1;
            for (RuleCondition condition2 : this.myConditions) {
                SpacingBuilder.this.myRules.add(new SpacingRule(condition2, 0, 0, blankLines, ((SpacingBuilder)SpacingBuilder.this).myCodeStyleSettings.KEEP_LINE_BREAKS, ((SpacingBuilder)SpacingBuilder.this).myCodeStyleSettings.KEEP_BLANK_LINES_IN_DECLARATIONS));
            }
            return SpacingBuilder.this;
        }

        public SpacingBuilder lineBreakInCodeIf(boolean option2) {
            return option2 ? this.lineBreakInCode() : SpacingBuilder.this;
        }

        public SpacingBuilder lineBreakInCode() {
            for (RuleCondition condition2 : this.myConditions) {
                SpacingBuilder.this.myRules.add(new SpacingRule(condition2, 1, 0, 1, ((SpacingBuilder)SpacingBuilder.this).myCodeStyleSettings.KEEP_LINE_BREAKS, ((SpacingBuilder)SpacingBuilder.this).myCodeStyleSettings.KEEP_BLANK_LINES_IN_CODE));
            }
            return SpacingBuilder.this;
        }

        public SpacingBuilder lineBreakOrForceSpace(boolean lbOption, boolean spaceOption) {
            if (lbOption) {
                return this.lineBreakInCode();
            }
            int count = spaceOption ? 1 : 0;
            return this.spacing(count, count, 0, false, 0);
        }

        public SpacingBuilder spacing(int minSpaces, int maxSpaces, int minLF, boolean keepLineBreaks, int keepBlankLines) {
            for (RuleCondition condition2 : this.myConditions) {
                SpacingBuilder.this.myRules.add(new SpacingRule(condition2, minSpaces, maxSpaces, minLF, keepLineBreaks, keepBlankLines));
            }
            return SpacingBuilder.this;
        }

        public SpacingBuilder parentDependentLFSpacing(int minSpaces, int maxSpaces, boolean keepLineBreaks, int keepBlankLines) {
            for (RuleCondition condition2 : this.myConditions) {
                SpacingBuilder.this.myRules.add(new DependentLFSpacingRule(condition2, minSpaces, maxSpaces, keepLineBreaks, keepBlankLines));
            }
            return SpacingBuilder.this;
        }
    }

    private static class RuleCondition {
        private final TokenSet myParentType;
        private final TokenSet myChild1Type;
        private final TokenSet myChild2Type;

        private RuleCondition(TokenSet parentType, TokenSet child1Type, TokenSet child2Type) {
            this.myParentType = parentType;
            this.myChild1Type = child1Type;
            this.myChild2Type = child2Type;
        }

        private boolean matches(@NotNull IElementType parentType, @NotNull IElementType firstChildType, @NotNull IElementType secondChildType) {
            if (parentType == null) {
                RuleCondition.$$$reportNull$$$0(0);
            }
            if (firstChildType == null) {
                RuleCondition.$$$reportNull$$$0(1);
            }
            if (secondChildType == null) {
                RuleCondition.$$$reportNull$$$0(2);
            }
            return !(this.myParentType != null && !this.myParentType.contains(parentType) || this.myChild1Type != null && !this.myChild1Type.contains(firstChildType) || this.myChild2Type != null && !this.myChild2Type.contains(secondChildType));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parentType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "firstChildType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "secondChildType";
                    break;
                }
            }
            objectArray[1] = "com/intellij/formatting/SpacingBuilder$RuleCondition";
            objectArray[2] = "matches";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DependentLFSpacingRule
    extends SpacingRule {
        DependentLFSpacingRule(@NotNull RuleCondition condition2, int minSpaces, int maxSpaces, boolean keepLineBreaks, int keepBlankLines) {
            if (condition2 == null) {
                DependentLFSpacingRule.$$$reportNull$$$0(0);
            }
            super(condition2, minSpaces, maxSpaces, 1, keepLineBreaks, keepBlankLines);
        }

        @Override
        @NotNull
        Spacing createSpacing(@NotNull TextRange parentRange) {
            if (parentRange == null) {
                DependentLFSpacingRule.$$$reportNull$$$0(1);
            }
            Spacing spacing = Spacing.createDependentLFSpacing(this.myMinSpaces, this.myMaxSpaces, parentRange, this.myKeepLineBreaks, this.myKeepBlankLines);
            if (spacing == null) {
                DependentLFSpacingRule.$$$reportNull$$$0(2);
            }
            return spacing;
        }

        @Override
        @Deprecated
        Spacing createSpacing(@NotNull ASTBlock parentBlock, @NotNull ASTBlock childBlock1, @NotNull ASTBlock childBlock2) {
            if (parentBlock == null) {
                DependentLFSpacingRule.$$$reportNull$$$0(3);
            }
            if (childBlock1 == null) {
                DependentLFSpacingRule.$$$reportNull$$$0(4);
            }
            if (childBlock2 == null) {
                DependentLFSpacingRule.$$$reportNull$$$0(5);
            }
            return this.createSpacing(parentBlock.getTextRange());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentRange";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/formatting/SpacingBuilder$DependentLFSpacingRule";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentBlock";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "childBlock1";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "childBlock2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/formatting/SpacingBuilder$DependentLFSpacingRule";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createSpacing";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createSpacing";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SpacingRule {
        protected final RuleCondition myRuleCondition;
        protected final int myMinSpaces;
        protected final int myMaxSpaces;
        protected final int myMinLF;
        protected final boolean myKeepLineBreaks;
        protected final int myKeepBlankLines;

        private SpacingRule(@NotNull RuleCondition condition2, int minSpaces, int maxSpaces, int minLF, boolean keepLineBreaks, int keepBlankLines) {
            if (condition2 == null) {
                SpacingRule.$$$reportNull$$$0(0);
            }
            this.myRuleCondition = condition2;
            this.myMinSpaces = minSpaces;
            this.myMaxSpaces = maxSpaces;
            this.myMinLF = minLF;
            this.myKeepLineBreaks = keepLineBreaks;
            this.myKeepBlankLines = keepBlankLines;
        }

        @Contract(value="null,_,_->false; _,null,_->false; _,_,null->false")
        public boolean matches(@Nullable IElementType parentType, @Nullable IElementType childType1, @Nullable IElementType childType2) {
            return parentType != null && childType1 != null && childType2 != null && this.myRuleCondition.matches(parentType, childType1, childType2);
        }

        @Contract(value="null,_,_->false; _,null,_->false; _,_,null->false")
        public boolean matches(@Nullable ASTBlock parentBlock, @Nullable ASTBlock childBlock1, @Nullable ASTBlock childBlock2) {
            return this.matches(ASTBlock.getElementType(parentBlock), ASTBlock.getElementType(childBlock1), ASTBlock.getElementType(childBlock2));
        }

        @NotNull
        Spacing createSpacing(@NotNull TextRange parentRange) {
            if (parentRange == null) {
                SpacingRule.$$$reportNull$$$0(1);
            }
            Spacing spacing = Spacing.createSpacing(this.myMinSpaces, this.myMaxSpaces, this.myMinLF, this.myKeepLineBreaks, this.myKeepBlankLines);
            if (spacing == null) {
                SpacingRule.$$$reportNull$$$0(2);
            }
            return spacing;
        }

        @Deprecated
        Spacing createSpacing(@NotNull ASTBlock parentBlock, @NotNull ASTBlock childBlock1, @NotNull ASTBlock childBlock2) {
            if (parentBlock == null) {
                SpacingRule.$$$reportNull$$$0(3);
            }
            if (childBlock1 == null) {
                SpacingRule.$$$reportNull$$$0(4);
            }
            if (childBlock2 == null) {
                SpacingRule.$$$reportNull$$$0(5);
            }
            return this.createSpacing(parentBlock.getTextRange());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentRange";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/formatting/SpacingBuilder$SpacingRule";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentBlock";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "childBlock1";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "childBlock2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/formatting/SpacingBuilder$SpacingRule";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createSpacing";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createSpacing";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

