/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import java.util.HashMap;
import java.util.Map;

public enum WrapType {
    ALWAYS(2),
    NORMAL(1),
    NONE(0),
    CHOP_DOWN_IF_LONG(4);

    private static final Map<Integer, WrapType> LEGACY_MAPPINGS;
    private final int myLegacyRepresentation;

    private WrapType(int legacyRepresentation) {
        this.myLegacyRepresentation = legacyRepresentation;
    }

    public static WrapType byLegacyRepresentation(int value2) {
        WrapType result2 = LEGACY_MAPPINGS.get(value2);
        return result2 == null ? CHOP_DOWN_IF_LONG : result2;
    }

    public int getLegacyRepresentation() {
        return this.myLegacyRepresentation;
    }

    static {
        LEGACY_MAPPINGS = new HashMap<Integer, WrapType>();
        for (WrapType wrapType : WrapType.values()) {
            LEGACY_MAPPINGS.put(wrapType.getLegacyRepresentation(), wrapType);
        }
    }
}

