/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.alignment;

import com.intellij.formatting.alignment.AlignmentInColumnsConfig;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class AlignmentInColumnsHelper {
    public static final AlignmentInColumnsHelper INSTANCE = new AlignmentInColumnsHelper();

    public boolean useDifferentVarDeclarationAlignment(ASTNode node, AlignmentInColumnsConfig config2, int blankLinesToBeKeptOnReformat) {
        List<IElementType> currTypes;
        List<IElementType> prevTypes;
        ASTNode prev = AlignmentInColumnsHelper.getPreviousAdjacentNodeOfTargetType(node, config2, blankLinesToBeKeptOnReformat);
        if (prev == null) {
            return true;
        }
        ASTNode curr = AlignmentInColumnsHelper.deriveNodeOfTargetType(node, TokenSet.create(prev.getElementType()));
        if (curr == null) {
            return true;
        }
        ASTNode prevSubNode = AlignmentInColumnsHelper.getSubNodeThatStartsNewLine(prev.getFirstChildNode(), config2);
        ASTNode currSubNode = AlignmentInColumnsHelper.getSubNodeThatStartsNewLine(curr.getFirstChildNode(), config2);
        while (true) {
            boolean currNodeIsDefined;
            boolean prevNodeIsDefined = prevSubNode != null;
            boolean bl = currNodeIsDefined = currSubNode != null;
            if (prevNodeIsDefined ^ currNodeIsDefined) {
                return true;
            }
            if (prevSubNode == null) break;
            if (prevSubNode.getElementType() != currSubNode.getElementType()) {
                return true;
            }
            prevSubNode = AlignmentInColumnsHelper.getSubNodeThatStartsNewLine(prevSubNode.getTreeNext(), config2);
            currSubNode = AlignmentInColumnsHelper.getSubNodeThatStartsNewLine(currSubNode.getTreeNext(), config2);
        }
        ASTNode currentFieldToUse = curr;
        for (ASTNode nextNode = curr.getTreeNext(); nextNode != null && nextNode.getTreeParent() == curr.getTreeParent(); nextNode = nextNode.getTreeNext()) {
            IElementType type = nextNode.getElementType();
            if (config2.getWhiteSpaceTokenTypes().contains(type)) {
                ASTNode previous = nextNode.getTreePrev();
                if ((previous == null || previous.getElementType() != curr.getElementType()) && StringUtil.countNewLines(nextNode.getChars()) <= 1) continue;
                break;
            }
            if (config2.getCommentTokenTypes().contains(type) || type != curr.getElementType()) continue;
            currentFieldToUse = nextNode;
        }
        return !(prevTypes = AlignmentInColumnsHelper.findSubNodeTypes(prev, config2.getDistinguishableTypes())).equals(currTypes = AlignmentInColumnsHelper.findSubNodeTypes(currentFieldToUse, config2.getDistinguishableTypes()));
    }

    @Nullable
    private static ASTNode getPreviousAdjacentNodeOfTargetType(ASTNode baseNode, AlignmentInColumnsConfig config2, final double blankLinesToBeKeptOnReformat) {
        ASTNode nodeOfTargetType = AlignmentInColumnsHelper.deriveNodeOfTargetType(baseNode, config2.getTargetDeclarationTypes());
        if (nodeOfTargetType == null) {
            return null;
        }
        final ASTNode[] prev = new ASTNode[1];
        AlignmentInColumnsHelper.findPreviousNode(config2, baseNode, new NodeProcessor(){

            @Override
            public boolean targetTypeFound(ASTNode node) {
                prev[0] = node;
                return true;
            }

            @Override
            public boolean whitespaceFound(ASTNode node) {
                return blankLinesToBeKeptOnReformat > 0.0 && StringUtil.countChars(node.getText(), '\n') > 1;
            }
        });
        if (prev[0] == null) {
            return null;
        }
        Couple<ASTNode> siblingParents = TreeUtil.findTopmostSiblingParents(prev[0], baseNode);
        if (siblingParents.first != null && siblingParents.second != null) {
            for (ASTNode each = ((ASTNode)siblingParents.second).getTreePrev(); each != null && each != siblingParents.first; each = each.getTreePrev()) {
                IElementType eachType = each.getElementType();
                if (config2.getCommentTokenTypes().contains(eachType) || config2.getWhiteSpaceTokenTypes().contains(eachType)) continue;
                return null;
            }
        }
        return AlignmentInColumnsHelper.deriveNodeOfTargetType(prev[0], TokenSet.create(nodeOfTargetType.getElementType()));
    }

    @Nullable
    private static ASTNode deriveNodeOfTargetType(ASTNode baseNode, TokenSet targetTypes) {
        if (targetTypes.contains(baseNode.getElementType())) {
            return baseNode;
        }
        for (ASTNode node = baseNode; node != null; node = node.getFirstChildNode()) {
            IElementType nodeType = node.getElementType();
            if (!targetTypes.contains(nodeType)) continue;
            return node;
        }
        return null;
    }

    private static boolean findPreviousNode(AlignmentInColumnsConfig config2, ASTNode from, NodeProcessor processor2) {
        return AlignmentInColumnsHelper.findPreviousNode(config2, from, from.getElementType(), false, true, processor2);
    }

    private static boolean findPreviousNode(AlignmentInColumnsConfig config2, ASTNode from, IElementType targetType, boolean processFrom, boolean processParent, NodeProcessor processor2) {
        ASTNode prev;
        if (from == null) {
            return false;
        }
        ASTNode aSTNode = prev = processFrom ? from : from.getTreePrev();
        while (prev != null) {
            IElementType prevType = prev.getElementType();
            if (prevType == targetType ? processor2.targetTypeFound(prev) : config2.getWhiteSpaceTokenTypes().contains(prevType) && processor2.whitespaceFound(prev)) {
                return true;
            }
            if (AlignmentInColumnsHelper.findPreviousNode(config2, prev.getLastChildNode(), targetType, true, false, processor2)) {
                return true;
            }
            prev = prev.getTreePrev();
        }
        if (processParent) {
            for (ASTNode parent = from.getTreeParent(); parent != null; parent = parent.getTreeParent()) {
                if (!AlignmentInColumnsHelper.findPreviousNode(config2, parent, targetType, false, false, processor2)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static ASTNode getSubNodeThatStartsNewLine(@Nullable ASTNode startNode, AlignmentInColumnsConfig config2) {
        if (startNode == null) {
            return null;
        }
        ASTNode parent = startNode.getTreeParent();
        if (parent == null) {
            return null;
        }
        final boolean[] returnFirstNonEmptySubNode = new boolean[]{false};
        AlignmentInColumnsHelper.findPreviousNode(config2, startNode, new NodeProcessor(){

            @Override
            public boolean targetTypeFound(ASTNode node) {
                return true;
            }

            @Override
            public boolean whitespaceFound(ASTNode node) {
                returnFirstNonEmptySubNode[0] = StringUtil.countNewLines(node.getChars()) > 0;
                return returnFirstNonEmptySubNode[0];
            }
        });
        boolean stop2 = false;
        for (ASTNode result2 = startNode; result2 != null && result2.getTreeParent() == parent; result2 = result2.getTreeNext()) {
            if (config2.getStopMultilineCheckElementTypes().contains(result2.getElementType())) {
                return null;
            }
            if (result2.getTextLength() <= 0 || config2.getCommentTokenTypes().contains(result2.getElementType())) continue;
            if (config2.getWhiteSpaceTokenTypes().contains(result2.getElementType()) && StringUtil.countNewLines(result2.getChars()) > 0) {
                stop2 = true;
                continue;
            }
            if (returnFirstNonEmptySubNode[0]) {
                return result2;
            }
            if (!stop2) continue;
            return result2;
        }
        return null;
    }

    private static List<IElementType> findSubNodeTypes(ASTNode node, TokenSet types) {
        SmartList<IElementType> foundTypes = new SmartList<IElementType>();
        for (ASTNode child2 = node.getFirstChildNode(); child2 != null && child2.getTreeParent() == node; child2 = child2.getTreeNext()) {
            IElementType type = child2.getElementType();
            if (!types.contains(type)) continue;
            foundTypes.add(type);
        }
        return foundTypes;
    }

    private static abstract class NodeProcessor {
        private NodeProcessor() {
        }

        public boolean targetTypeFound(ASTNode node) {
            return false;
        }

        public boolean whitespaceFound(ASTNode node) {
            return false;
        }
    }
}

