/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.commandLine;

import com.intellij.application.options.CodeStyle;
import com.intellij.formatting.commandLine.FileSetProcessor;
import com.intellij.formatting.commandLine.MessageOutput;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.util.PlatformUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileSetFormatter
extends FileSetProcessor {
    private static final Logger LOG = Logger.getInstance(FileSetFormatter.class);
    private static final String PROJECT_DIR_PREFIX = PlatformUtils.getPlatformPrefix() + ".format.";
    private static final String PROJECT_DIR_SUFFIX = ".tmp";
    private static final String RESULT_MESSAGE_OK = "OK";
    private static final String RESULT_MESSAGE_FAILED = "Failed";
    private static final String RESULT_MESSAGE_NOT_SUPPORTED = "Skipped, not supported.";
    private static final String RESULT_MESSAGE_BINARY_FILE = "Skipped, binary file.";
    @NotNull
    private final String myProjectUID;
    @Nullable
    private Project myProject;
    private final MessageOutput myMessageOutput;
    @NotNull
    private CodeStyleSettings mySettings;

    public FileSetFormatter(@NotNull MessageOutput messageOutput) {
        if (messageOutput == null) {
            FileSetFormatter.$$$reportNull$$$0(0);
        }
        this.myMessageOutput = messageOutput;
        this.mySettings = new CodeStyleSettings();
        this.myProjectUID = UUID.randomUUID().toString();
    }

    public void setCodeStyleSettings(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            FileSetFormatter.$$$reportNull$$$0(1);
        }
        this.mySettings = settings;
    }

    private void createProject() throws IOException {
        ProjectManagerEx projectManager = ProjectManagerEx.getInstanceEx();
        File projectDir = this.createProjectDir();
        this.myProject = projectManager.createProject(this.myProjectUID, projectDir.getPath());
        if (this.myProject != null) {
            projectManager.openProject(this.myProject);
            CodeStyle.setMainProjectSettings(this.myProject, this.mySettings);
        }
    }

    private File createProjectDir() throws IOException {
        File tempDir = FileUtil.createTempDirectory(PROJECT_DIR_PREFIX, this.myProjectUID + PROJECT_DIR_SUFFIX);
        File projectDir = new File(tempDir.getPath() + File.separator + ".idea");
        if (projectDir.mkdirs()) {
            return projectDir;
        }
        throw new IOException("Cannot create a temporary project at " + projectDir);
    }

    private void closeProject() {
        if (this.myProject != null) {
            ProjectManagerEx.getInstanceEx().closeAndDispose(this.myProject);
        }
    }

    @Override
    public void processFiles() throws IOException {
        this.createProject();
        if (this.myProject != null) {
            super.processFiles();
            this.closeProject();
        }
    }

    @Override
    protected boolean processFile(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            FileSetFormatter.$$$reportNull$$$0(2);
        }
        String resultMessage = RESULT_MESSAGE_OK;
        assert (this.myProject != null);
        VfsUtil.markDirtyAndRefresh(false, false, false, virtualFile2);
        this.myMessageOutput.info("Formatting " + virtualFile2.getCanonicalPath() + "...");
        if (!virtualFile2.getFileType().isBinary()) {
            VirtualFile[] openFiles;
            Document document = FileDocumentManager.getInstance().getDocument(virtualFile2);
            if (document != null) {
                PsiFile psiFile = PsiDocumentManager.getInstance(this.myProject).getPsiFile(document);
                NonProjectFileWritingAccessProvider.allowWriting(Collections.singletonList(virtualFile2));
                if (psiFile != null) {
                    if (FileSetFormatter.isFormattingSupported(psiFile)) {
                        FileSetFormatter.reformatFile(this.myProject, psiFile, document);
                        FileDocumentManager.getInstance().saveDocument(document);
                    } else {
                        resultMessage = RESULT_MESSAGE_NOT_SUPPORTED;
                    }
                } else {
                    LOG.warn("Unable to get a PSI file for " + virtualFile2.getPath());
                    resultMessage = RESULT_MESSAGE_FAILED;
                }
            } else {
                LOG.warn("No document available for " + virtualFile2.getPath());
                resultMessage = RESULT_MESSAGE_FAILED;
            }
            FileEditorManager editorManager = FileEditorManager.getInstance(this.myProject);
            for (VirtualFile openFile2 : openFiles = editorManager.getOpenFiles()) {
                editorManager.closeFile(openFile2);
            }
        } else {
            resultMessage = RESULT_MESSAGE_BINARY_FILE;
        }
        this.myMessageOutput.info(resultMessage + "\n");
        return RESULT_MESSAGE_OK.equals(resultMessage);
    }

    private static void reformatFile(@NotNull Project project2, @NotNull PsiFile file2, @NotNull Document document) {
        if (project2 == null) {
            FileSetFormatter.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            FileSetFormatter.$$$reportNull$$$0(4);
        }
        if (document == null) {
            FileSetFormatter.$$$reportNull$$$0(5);
        }
        WriteCommandAction.runWriteCommandAction(project2, () -> {
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance(project2);
            codeStyleManager.reformatText(file2, 0, file2.getTextLength());
            PsiDocumentManager.getInstance(project2).commitDocument(document);
        });
    }

    private static boolean isFormattingSupported(@NotNull PsiFile file2) {
        if (file2 == null) {
            FileSetFormatter.$$$reportNull$$$0(6);
        }
        return LanguageFormatting.INSTANCE.forContext(file2) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageOutput";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        objectArray2[1] = "com/intellij/formatting/commandLine/FileSetFormatter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setCodeStyleSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "reformatFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isFormattingSupported";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

