/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.engine;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.TextChange;
import com.intellij.openapi.editor.impl.BulkChangesMerger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class CaretOffsetUpdater {
    private final Map<Editor, Integer> myCaretOffsets;

    CaretOffsetUpdater(@NotNull Document document) {
        Editor[] editors;
        if (document == null) {
            CaretOffsetUpdater.$$$reportNull$$$0(0);
        }
        this.myCaretOffsets = new HashMap<Editor, Integer>();
        for (Editor editor : editors = EditorFactory.getInstance().getEditors(document)) {
            this.myCaretOffsets.put(editor, editor.getCaretModel().getOffset());
        }
    }

    void update(@NotNull List<? extends TextChange> changes) {
        if (changes == null) {
            CaretOffsetUpdater.$$$reportNull$$$0(1);
        }
        BulkChangesMerger merger = BulkChangesMerger.INSTANCE;
        for (Map.Entry<Editor, Integer> entry : this.myCaretOffsets.entrySet()) {
            entry.setValue(merger.updateOffset(entry.getValue(), changes));
        }
    }

    void restoreCaretLocations() {
        for (Map.Entry<Editor, Integer> entry : this.myCaretOffsets.entrySet()) {
            entry.getKey().getCaretModel().moveToOffset(entry.getValue());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
        }
        objectArray2[1] = "com/intellij/formatting/engine/CaretOffsetUpdater";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

