/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection;

import com.intellij.framework.FrameworkType;
import com.intellij.framework.detection.DetectedFrameworkDescription;
import com.intellij.framework.detection.FrameworkDetectionContext;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.util.indexing.FileContent;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FrameworkDetector {
    public static final ExtensionPointName<FrameworkDetector> EP_NAME = ExtensionPointName.create("com.intellij.framework.detector");
    private final String myDetectorId;
    private final int myDetectorVersion;

    protected FrameworkDetector(String detectorId) {
        this(detectorId, 0);
    }

    protected FrameworkDetector(@NotNull String detectorId, int detectorVersion) {
        if (detectorId == null) {
            FrameworkDetector.$$$reportNull$$$0(0);
        }
        this.myDetectorId = detectorId;
        this.myDetectorVersion = detectorVersion;
    }

    @NotNull
    public abstract FileType getFileType();

    @NotNull
    public abstract ElementPattern<FileContent> createSuitableFilePattern();

    public abstract List<? extends DetectedFrameworkDescription> detect(@NotNull Collection<VirtualFile> var1, @NotNull FrameworkDetectionContext var2);

    public abstract FrameworkType getFrameworkType();

    @Nullable
    public FrameworkType getUnderlyingFrameworkType() {
        return null;
    }

    @NotNull
    public final String getDetectorId() {
        String string = this.myDetectorId;
        if (string == null) {
            FrameworkDetector.$$$reportNull$$$0(1);
        }
        return string;
    }

    public final int getDetectorVersion() {
        return this.myDetectorVersion;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detectorId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/framework/detection/FrameworkDetector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/framework/detection/FrameworkDetector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDetectorId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

