/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl;

import com.intellij.framework.detection.DetectedFrameworkDescription;
import com.intellij.framework.detection.impl.FrameworkDetectorRegistryImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.PersistentHashMap;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;
import gnu.trove.TIntObjectHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DetectedFrameworksData {
    private static final Logger LOG = Logger.getInstance(DetectedFrameworksData.class);
    private PersistentHashMap<Integer, TIntHashSet> myExistentFrameworkFiles;
    private final TIntObjectHashMap<TIntHashSet> myNewFiles;
    private final MultiMap<Integer, DetectedFrameworkDescription> myDetectedFrameworks;
    private final Object myLock = new Object();

    public DetectedFrameworksData(Project project2) {
        this.myDetectedFrameworks = new MultiMap();
        Path file2 = ProjectUtil.getProjectCachePath(project2, FrameworkDetectorRegistryImpl.getDetectionDirPath(), true).resolve("files");
        this.myNewFiles = new TIntObjectHashMap();
        try {
            this.myExistentFrameworkFiles = new PersistentHashMap<Integer, TIntHashSet>(file2, EnumeratorIntegerDescriptor.INSTANCE, new TIntHashSetExternalizer());
        }
        catch (IOException e) {
            LOG.info(e);
            PersistentHashMap.deleteFilesStartingWith(file2.toFile());
            try {
                this.myExistentFrameworkFiles = new PersistentHashMap<Integer, TIntHashSet>(file2, EnumeratorIntegerDescriptor.INSTANCE, new TIntHashSetExternalizer());
            }
            catch (IOException e1) {
                LOG.error(e1);
            }
        }
    }

    public void saveDetected() {
        try {
            this.myExistentFrameworkFiles.close();
        }
        catch (IOException e) {
            LOG.info(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<VirtualFile> retainNewFiles(@NotNull Integer detectorId, @NotNull Collection<? extends VirtualFile> files2) {
        if (detectorId == null) {
            DetectedFrameworksData.$$$reportNull$$$0(0);
        }
        if (files2 == null) {
            DetectedFrameworksData.$$$reportNull$$$0(1);
        }
        Object object = this.myLock;
        synchronized (object) {
            TIntHashSet oldSet = this.myNewFiles.get(detectorId);
            if (oldSet == null) {
                oldSet = new TIntHashSet();
                this.myNewFiles.put(detectorId, oldSet);
            }
            TIntHashSet existentFilesSet = null;
            try {
                existentFilesSet = this.myExistentFrameworkFiles.get(detectorId);
            }
            catch (IOException e) {
                LOG.info(e);
            }
            ArrayList<VirtualFile> newFiles = new ArrayList<VirtualFile>();
            TIntHashSet newSet = new TIntHashSet();
            for (VirtualFile virtualFile2 : files2) {
                int fileId = FileBasedIndex.getFileId(virtualFile2);
                if (existentFilesSet != null && existentFilesSet.contains(fileId)) continue;
                newFiles.add(virtualFile2);
                newSet.add(fileId);
            }
            if (newSet.equals(oldSet)) {
                return Collections.emptyList();
            }
            this.myNewFiles.put(detectorId, newSet);
            return newFiles;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Integer> getDetectorsForDetectedFrameworks() {
        Object object = this.myLock;
        synchronized (object) {
            return new HashSet<Integer>(this.myDetectedFrameworks.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends DetectedFrameworkDescription> updateFrameworksList(Integer detectorId, Collection<? extends DetectedFrameworkDescription> frameworks) {
        Object object = this.myLock;
        synchronized (object) {
            Collection<DetectedFrameworkDescription> oldFrameworks = this.myDetectedFrameworks.remove(detectorId);
            this.myDetectedFrameworks.putValues(detectorId, frameworks);
            if (oldFrameworks != null) {
                frameworks.removeAll(oldFrameworks);
            }
            return frameworks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putExistentFrameworkFiles(Integer id2, Collection<? extends VirtualFile> files2) {
        Object object = this.myLock;
        synchronized (object) {
            TIntHashSet set = null;
            try {
                set = this.myExistentFrameworkFiles.get(id2);
            }
            catch (IOException e) {
                LOG.info(e);
            }
            if (set == null) {
                set = new TIntHashSet();
                try {
                    this.myExistentFrameworkFiles.put(id2, set);
                }
                catch (IOException e) {
                    LOG.info(e);
                }
            }
            for (VirtualFile virtualFile2 : files2) {
                set.add(FileBasedIndex.getFileId(virtualFile2));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "detectorId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "files";
                break;
            }
        }
        objectArray[1] = "com/intellij/framework/detection/impl/DetectedFrameworksData";
        objectArray[2] = "retainNewFiles";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class TIntHashSetExternalizer
    implements DataExternalizer<TIntHashSet> {
        private TIntHashSetExternalizer() {
        }

        @Override
        public void save(@NotNull DataOutput out, TIntHashSet value2) throws IOException {
            if (out == null) {
                TIntHashSetExternalizer.$$$reportNull$$$0(0);
            }
            out.writeInt(value2.size());
            TIntIterator iterator2 = value2.iterator();
            while (iterator2.hasNext()) {
                out.writeInt(iterator2.next());
            }
        }

        @Override
        public TIntHashSet read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                TIntHashSetExternalizer.$$$reportNull$$$0(1);
            }
            int size = in.readInt();
            TIntHashSet set = new TIntHashSet(size);
            while (size-- > 0) {
                set.add(in.readInt());
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/framework/detection/impl/DetectedFrameworksData$TIntHashSetExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

