/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl;

import com.intellij.framework.detection.DetectedFrameworkDescription;
import com.intellij.framework.detection.FrameworkDetectionContext;
import com.intellij.framework.detection.FrameworkDetector;
import com.intellij.framework.detection.impl.FrameworkDetectionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.patterns.ElementPattern;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FrameworkDetectionProcessor {
    public static final Set<String> SKIPPED_DIRECTORIES = ContainerUtil.newHashSet("node_modules");
    private static final Logger LOG = Logger.getInstance(FrameworkDetectionProcessor.class);
    private final ProgressIndicator myProgressIndicator;
    private final MultiMap<FileType, FrameworkDetectorData> myDetectorsByFileType;
    private Set<VirtualFile> myProcessedFiles;
    private final FrameworkDetectionContext myContext;

    public FrameworkDetectionProcessor(ProgressIndicator progressIndicator2, FrameworkDetectionContext context) {
        this.myProgressIndicator = progressIndicator2;
        FrameworkDetector[] detectors = FrameworkDetector.EP_NAME.getExtensions();
        this.myDetectorsByFileType = new MultiMap();
        for (FrameworkDetector detector : detectors) {
            this.myDetectorsByFileType.putValue(detector.getFileType(), new FrameworkDetectorData(detector));
        }
        this.myContext = context;
    }

    public List<? extends DetectedFrameworkDescription> processRoots(List<? extends File> roots) {
        this.myProcessedFiles = new HashSet<VirtualFile>();
        for (File file2 : roots) {
            VirtualFile virtualFile2 = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2);
            if (virtualFile2 == null) continue;
            this.collectSuitableFiles(virtualFile2);
        }
        ArrayList<? extends DetectedFrameworkDescription> result2 = new ArrayList<DetectedFrameworkDescription>();
        for (FrameworkDetectorData data2 : this.myDetectorsByFileType.values()) {
            result2.addAll(data2.myDetector.detect(data2.mySuitableFiles, this.myContext));
        }
        return FrameworkDetectionUtil.removeDisabled(result2);
    }

    private void collectSuitableFiles(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FrameworkDetectionProcessor.$$$reportNull$$$0(0);
        }
        try {
            VfsUtilCore.visitChildrenRecursively(file2, new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

                @Override
                public boolean visitFile(@NotNull VirtualFile file2) {
                    if (file2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    FrameworkDetectionProcessor.this.myProgressIndicator.checkCanceled();
                    return !file2.isDirectory() || !SKIPPED_DIRECTORIES.contains(file2.getName());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/framework/detection/impl/FrameworkDetectionProcessor$1", "visitFile"));
                }
            });
            file2.refresh(false, true);
            VfsUtilCore.visitChildrenRecursively(file2, new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

                @Override
                public boolean visitFile(@NotNull VirtualFile file2) {
                    if (file2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    FrameworkDetectionProcessor.this.myProgressIndicator.checkCanceled();
                    if (file2.isDirectory() && SKIPPED_DIRECTORIES.contains(file2.getName())) {
                        return false;
                    }
                    if (!FrameworkDetectionProcessor.this.myProcessedFiles.add(file2)) {
                        return false;
                    }
                    if (!file2.isDirectory()) {
                        FileType fileType = file2.getFileType();
                        if (FrameworkDetectionProcessor.this.myDetectorsByFileType.containsKey(fileType)) {
                            FrameworkDetectionProcessor.this.myProgressIndicator.setText2(file2.getPresentableUrl());
                            try {
                                FileContentImpl fileContent = new FileContentImpl(file2, file2.contentsToByteArray(false));
                                for (FrameworkDetectorData detector : FrameworkDetectionProcessor.this.myDetectorsByFileType.get(fileType)) {
                                    if (!detector.myFilePattern.accepts(fileContent)) continue;
                                    detector.mySuitableFiles.add(file2);
                                }
                            }
                            catch (IOException e) {
                                LOG.info(e);
                            }
                        }
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/framework/detection/impl/FrameworkDetectionProcessor$2", "visitFile"));
                }
            });
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/framework/detection/impl/FrameworkDetectionProcessor", "collectSuitableFiles"));
    }

    private static class FrameworkDetectorData {
        private final FrameworkDetector myDetector;
        private final ElementPattern<FileContent> myFilePattern;
        private final List<VirtualFile> mySuitableFiles = new ArrayList<VirtualFile>();

        FrameworkDetectorData(FrameworkDetector detector) {
            this.myDetector = detector;
            this.myFilePattern = detector.createSuitableFilePattern();
        }
    }
}

