/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl.exclude;

import com.intellij.framework.FrameworkType;
import com.intellij.framework.detection.impl.FrameworkDetectorRegistry;
import com.intellij.framework.detection.impl.exclude.DetectionExcludesConfigurationImpl;
import com.intellij.framework.detection.impl.exclude.ExcludeListItem;
import com.intellij.framework.detection.impl.exclude.ExcludedFileState;
import com.intellij.framework.detection.impl.exclude.ExcludesConfigurationState;
import com.intellij.framework.detection.impl.exclude.InvalidExcludeListItem;
import com.intellij.framework.detection.impl.exclude.ValidExcludeListItem;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.SortedListModel;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DetectionExcludesConfigurable
implements Configurable {
    private final Project myProject;
    private final DetectionExcludesConfigurationImpl myConfiguration;
    private final SortedListModel<ExcludeListItem> myModel;
    private JPanel myMainPanel;
    private JCheckBox myEnabledDetectionCheckBox;

    public DetectionExcludesConfigurable(@NotNull Project project2, @NotNull DetectionExcludesConfigurationImpl configuration) {
        if (project2 == null) {
            DetectionExcludesConfigurable.$$$reportNull$$$0(0);
        }
        if (configuration == null) {
            DetectionExcludesConfigurable.$$$reportNull$$$0(1);
        }
        this.myProject = project2;
        this.myConfiguration = configuration;
        this.myModel = new SortedListModel<ExcludeListItem>(ExcludeListItem.COMPARATOR);
    }

    @Override
    @Nls
    @NotNull
    public JComponent createComponent() {
        this.myEnabledDetectionCheckBox = new JCheckBox(ProjectBundle.message("checkbox.text.enable.framework.detection", new Object[0]));
        this.myEnabledDetectionCheckBox.setBorder(new EmptyBorder(10, 10, 0, 0));
        JBList<ExcludeListItem> excludesList = new JBList<ExcludeListItem>((ListModel<ExcludeListItem>)this.myModel);
        ColoredListCellRenderer<ExcludeListItem> renderer = new ColoredListCellRenderer<ExcludeListItem>(){
            final JPanel panel = new JPanel(new BorderLayout());
            {
                this.panel.setBorder(JBUI.Borders.empty(2, 10, 2, 0));
                this.panel.add(this);
            }

            @Override
            protected void customizeCellRenderer(@NotNull JList<? extends ExcludeListItem> list2, ExcludeListItem value2, int index, boolean selected2, boolean hasFocus) {
                if (list2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.setIconTextGap(4);
                if (value2 != null) {
                    value2.renderItem(this);
                    this.setBorder(JBUI.Borders.emptyLeft(10));
                }
            }

            @Override
            public Component getListCellRendererComponent(JList<? extends ExcludeListItem> list2, ExcludeListItem value2, int index, boolean selected2, boolean hasFocus) {
                super.getListCellRendererComponent(list2, value2, index, selected2, hasFocus);
                this.panel.setBackground(UIUtil.getListBackground(selected2, hasFocus));
                return this.panel;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/framework/detection/impl/exclude/DetectionExcludesConfigurable$1", "customizeCellRenderer"));
            }
        };
        renderer.setMyBorder(JBUI.Borders.empty());
        excludesList.setCellRenderer((ListCellRenderer<ExcludeListItem>)renderer);
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator(excludesList).setToolbarPosition(ActionToolbarPosition.TOP).setPanelBorder(JBUI.Borders.empty()).disableUpAction().disableDownAction().setAddAction(new AnActionButtonRunnable(){

            @Override
            public void run(AnActionButton button2) {
                DetectionExcludesConfigurable.this.doAddAction(button2);
            }
        });
        this.myMainPanel = new JPanel(new BorderLayout(0, 5));
        this.myMainPanel.add((Component)this.myEnabledDetectionCheckBox, "North");
        final LabeledComponent<JPanel> excludesComponent = LabeledComponent.create(decorator.createPanel(), ProjectBundle.message("label.exclude.from.detection", new Object[0]));
        this.myMainPanel.add(excludesComponent);
        this.myEnabledDetectionCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiUtils.enableChildren(DetectionExcludesConfigurable.this.myEnabledDetectionCheckBox.isSelected(), excludesComponent);
            }
        });
        this.myEnabledDetectionCheckBox.setSelected(true);
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            DetectionExcludesConfigurable.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    private void doAddAction(AnActionButton button2) {
        ArrayList<FrameworkType> types = new ArrayList<FrameworkType>();
        for (FrameworkType frameworkType : FrameworkDetectorRegistry.getInstance().getFrameworkTypes()) {
            if (this.isExcluded(frameworkType)) continue;
            types.add(frameworkType);
        }
        Collections.sort(types, (o1, o2) -> o1.getPresentableName().compareToIgnoreCase(o2.getPresentableName()));
        types.add(0, null);
        ListPopup popup2 = JBPopupFactory.getInstance().createListPopup(new BaseListPopupStep<FrameworkType>("Framework to Exclude", types){

            @Override
            public Icon getIconFor(FrameworkType value2) {
                return value2 != null ? value2.getIcon() : null;
            }

            @Override
            @NotNull
            public String getTextFor(FrameworkType value2) {
                return value2 != null ? value2.getPresentableName() : "All Frameworks...";
            }

            @Override
            public boolean hasSubstep(FrameworkType selectedValue) {
                return selectedValue != null;
            }

            @Override
            public PopupStep onChosen(FrameworkType frameworkType, boolean finalChoice) {
                if (frameworkType == null) {
                    return this.doFinalStep(() -> DetectionExcludesConfigurable.this.chooseDirectoryAndAdd(null));
                }
                return DetectionExcludesConfigurable.this.addExcludedFramework(frameworkType);
            }
        });
        RelativePoint relativePoint = button2.getPreferredPopupPoint();
        if (relativePoint != null) {
            popup2.show(relativePoint);
        } else {
            popup2.showInCenterOf(this.myMainPanel);
        }
    }

    private boolean isExcluded(@NotNull FrameworkType type) {
        if (type == null) {
            DetectionExcludesConfigurable.$$$reportNull$$$0(3);
        }
        for (ExcludeListItem item : this.myModel.getItems()) {
            if (!type.getId().equals(item.getFrameworkTypeId()) || item.getFileUrl() != null) continue;
            return true;
        }
        return false;
    }

    private PopupStep addExcludedFramework(final @NotNull FrameworkType frameworkType) {
        if (frameworkType == null) {
            DetectionExcludesConfigurable.$$$reportNull$$$0(4);
        }
        String projectItem = "In the whole project";
        return new BaseListPopupStep<String>(null, new String[]{"In the whole project", "In directory..."}){

            @Override
            public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                if (selectedValue.equals("In the whole project")) {
                    DetectionExcludesConfigurable.this.addAndRemoveDuplicates(frameworkType, null);
                    return FINAL_CHOICE;
                }
                return this.doFinalStep(() -> DetectionExcludesConfigurable.this.chooseDirectoryAndAdd(frameworkType));
            }
        };
    }

    private void addAndRemoveDuplicates(@Nullable FrameworkType frameworkType, @Nullable VirtualFile file2) {
        Iterator<ExcludeListItem> iterator2 = this.myModel.iterator();
        boolean add = true;
        while (iterator2.hasNext()) {
            ExcludeListItem item = iterator2.next();
            String fileUrl = item.getFileUrl();
            VirtualFile itemFile = fileUrl != null ? VirtualFileManager.getInstance().findFileByUrl(fileUrl) : null;
            String itemTypeId = item.getFrameworkTypeId();
            if (file2 == null) {
                if (frameworkType == null || !frameworkType.getId().equals(itemTypeId)) continue;
                iterator2.remove();
                continue;
            }
            if (itemFile == null) continue;
            if (VfsUtilCore.isAncestor(file2, itemFile, false) && (frameworkType == null || frameworkType.getId().equals(itemTypeId))) {
                iterator2.remove();
            }
            if (!VfsUtilCore.isAncestor(itemFile, file2, false) || itemTypeId != null && (frameworkType == null || !itemTypeId.equals(frameworkType.getId()))) continue;
            add = false;
        }
        if (add) {
            this.myModel.add(new ValidExcludeListItem(frameworkType, file2));
        }
    }

    private void chooseDirectoryAndAdd(@Nullable FrameworkType type) {
        VirtualFile file2;
        FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        descriptor2.setDescription((type != null ? type.getPresentableName() + " framework detection" : "Detection for all frameworks") + " will be disabled in selected directory");
        VirtualFile[] files2 = FileChooser.chooseFiles(descriptor2, this.myMainPanel, this.myProject, this.myProject.getBaseDir());
        VirtualFile virtualFile2 = file2 = files2.length > 0 ? files2[0] : null;
        if (file2 != null) {
            this.addAndRemoveDuplicates(type, file2);
        }
    }

    @Override
    public boolean isModified() {
        return !Comparing.equal(this.computeState(), this.myConfiguration.getActualState());
    }

    @Override
    public void apply() {
        this.myConfiguration.loadState(this.computeState());
    }

    @Nullable
    private ExcludesConfigurationState computeState() {
        ExcludesConfigurationState state = new ExcludesConfigurationState();
        state.setDetectionEnabled(this.myEnabledDetectionCheckBox.isSelected());
        for (ExcludeListItem item : this.myModel.getItems()) {
            String url = item.getFileUrl();
            String typeId = item.getFrameworkTypeId();
            if (url == null) {
                state.getFrameworkTypes().add(typeId);
                continue;
            }
            state.getFiles().add(new ExcludedFileState(url, typeId));
        }
        return state;
    }

    @Override
    public void reset() {
        this.myModel.clear();
        ExcludesConfigurationState state = this.myConfiguration.getActualState();
        this.myEnabledDetectionCheckBox.setSelected(state.isDetectionEnabled());
        for (String typeId : state.getFrameworkTypes()) {
            FrameworkType frameworkType = FrameworkDetectorRegistry.getInstance().findFrameworkType(typeId);
            this.myModel.add(frameworkType != null ? new ValidExcludeListItem(frameworkType, null) : new InvalidExcludeListItem(typeId, null));
        }
        for (ExcludedFileState fileState : state.getFiles()) {
            VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl(fileState.getUrl());
            String typeId = fileState.getFrameworkType();
            if (typeId == null) {
                this.myModel.add(file2 != null ? new ValidExcludeListItem(null, file2) : new InvalidExcludeListItem(null, fileState.getUrl()));
                continue;
            }
            FrameworkType frameworkType = FrameworkDetectorRegistry.getInstance().findFrameworkType(typeId);
            this.myModel.add(frameworkType != null && file2 != null ? new ValidExcludeListItem(frameworkType, file2) : new InvalidExcludeListItem(typeId, fileState.getUrl()));
        }
    }

    @Override
    @Nls
    public String getDisplayName() {
        return ProjectBundle.message("configurable.DetectionExcludesConfigurable.display.name", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/framework/detection/impl/exclude/DetectionExcludesConfigurable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/framework/detection/impl/exclude/DetectionExcludesConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isExcluded";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addExcludedFramework";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

