/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.help.impl;

import com.intellij.help.impl.MacHelpUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.IdeUrlTrackingParametersProvider;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.help.WebHelpProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.URLUtil;
import org.jetbrains.annotations.Nullable;

public class HelpManagerImpl
extends HelpManager {
    private static final ExtensionPointName<WebHelpProvider> WEB_HELP_PROVIDER_EP_NAME = ExtensionPointName.create("com.intellij.webHelpProvider");

    @Override
    public void invokeHelp(@Nullable String id2) {
        id2 = StringUtil.notNullize(id2, "top");
        for (WebHelpProvider provider : WEB_HELP_PROVIDER_EP_NAME.getExtensions()) {
            String url;
            if (!id2.startsWith(provider.getHelpTopicPrefix()) || (url = provider.getHelpPageUrl(id2)) == null) continue;
            BrowserUtil.browse(url);
            return;
        }
        if (MacHelpUtil.isApplicable() && MacHelpUtil.invokeHelp(id2)) {
            return;
        }
        ApplicationInfoEx info = ApplicationInfoEx.getInstanceEx();
        String productVersion = info.getMajorVersion() + "." + info.getMinorVersionMainPart();
        String url = info.getWebHelpUrl();
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        url = url + productVersion + "/?" + URLUtil.encodeURIComponent(id2);
        BrowserUtil.browse(IdeUrlTrackingParametersProvider.getInstance().augmentUrl(url));
    }
}

