/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.help.impl;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class KeymapGenerator
implements ApplicationStarter {
    @Override
    public String getCommandName() {
        return "keymap";
    }

    @Override
    public void main(String @NotNull [] args) {
        if (args == null) {
            KeymapGenerator.$$$reportNull$$$0(0);
        }
        ActionManager actionManager = ActionManager.getInstance();
        StringBuilder xml = new StringBuilder();
        xml.append("<Keymaps>\n");
        for (Keymap keymap2 : KeymapManagerEx.getInstanceEx().getAllKeymaps()) {
            xml.append("  <Keymap name=\"").append(keymap2.getPresentableName()).append("\">\n");
            for (String id2 : keymap2.getActionIdList()) {
                String text2;
                String shortcuts = KeymapUtil.getShortcutsText(keymap2.getShortcuts(id2));
                if (StringUtil.isEmpty(shortcuts)) continue;
                AnAction action2 = actionManager.getAction(id2);
                xml.append("    <Action id=\"").append(id2).append("\">\n");
                THashSet<String> addedShortcuts = new THashSet<String>();
                for (Shortcut shortcut : keymap2.getShortcuts(id2)) {
                    String shortcutText = KeymapUtil.getShortcutText(shortcut);
                    if (!addedShortcuts.add(shortcutText)) continue;
                    xml.append("      <Shortcut>").append(shortcutText).append("</Shortcut>\n");
                }
                if (action2 != null && (text2 = action2.getTemplatePresentation().getText()) != null) {
                    xml.append("      <Text>").append(StringUtil.escapeXmlEntities(text2)).append("</Text>\n");
                }
                xml.append("    </Action>\n");
            }
            xml.append("  </Keymap>\n");
        }
        xml.append("</Keymaps>");
        String path2 = args.length == 2 ? args[1] : PathManager.getHomePath() + File.separator + "AllKeymaps.xml";
        File out = new File(path2);
        try {
            FileUtil.writeToFile(out, xml.toString());
            System.out.println("Saved to: " + out.getAbsolutePath());
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/help/impl/KeymapGenerator", "main"));
    }
}

