/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core;

import com.intellij.history.core.changes.Change;
import com.intellij.history.core.changes.ChangeSet;
import com.intellij.history.core.changes.ChangeVisitor;
import com.intellij.history.core.changes.CreateEntryChange;
import com.intellij.history.core.changes.DeleteChange;
import com.intellij.history.core.changes.PutLabelChange;
import com.intellij.history.core.changes.StructuralChange;
import com.intellij.psi.codeStyle.NameUtil;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class ChangeCollectingVisitor
extends ChangeVisitor {
    private String myPath;
    private final String myProjectId;
    private final Pattern myPattern;
    private ChangeSet myCurrentChangeSet;
    private boolean myExists = true;
    private boolean myDoNotAddAnythingElseFromCurrentChangeSet = false;
    private final LinkedHashSet<ChangeSet> myResult = new LinkedHashSet();

    public ChangeCollectingVisitor(String path2, String projectId, @Nullable String pattern) {
        this.myPath = path2;
        this.myProjectId = projectId;
        this.myPattern = pattern == null ? null : Pattern.compile(NameUtil.buildRegexp(pattern, 0, true, true), 2);
    }

    public List<ChangeSet> getChanges() {
        return new ArrayList<ChangeSet>(this.myResult);
    }

    public String getPath() {
        return this.myPath;
    }

    @Override
    public void begin(ChangeSet c) throws ChangeVisitor.StopVisitingException {
        this.myCurrentChangeSet = c;
    }

    @Override
    public void end(ChangeSet c) throws ChangeVisitor.StopVisitingException {
        this.myCurrentChangeSet = null;
        this.myDoNotAddAnythingElseFromCurrentChangeSet = false;
    }

    @Override
    public void visit(PutLabelChange c) throws ChangeVisitor.StopVisitingException {
        this.doVisit(c);
    }

    @Override
    public void visit(StructuralChange c) throws ChangeVisitor.StopVisitingException {
        this.doVisit(c);
    }

    private void doVisit(Change c) {
        if (this.skippedDueToNonexistence(c)) {
            return;
        }
        this.addIfAffectsAndRevert(c);
    }

    @Override
    public void visit(CreateEntryChange c) throws ChangeVisitor.StopVisitingException {
        if (this.skippedDueToNonexistence(c)) {
            return;
        }
        this.addIfAffectsAndRevert(c);
        if (c.isCreationalFor(this.myPath)) {
            this.myExists = false;
        }
    }

    @Override
    public void visit(DeleteChange c) throws ChangeVisitor.StopVisitingException {
        if (this.skippedDueToNonexistence(c)) {
            if (c.isDeletionOf(this.myPath)) {
                this.addIfAffectsAndRevert(c);
                this.myExists = true;
                this.myDoNotAddAnythingElseFromCurrentChangeSet = true;
            }
        } else {
            this.addIfAffectsAndRevert(c);
        }
    }

    private void addIfAffectsAndRevert(Change c) {
        if (!this.myDoNotAddAnythingElseFromCurrentChangeSet && (c.affectsPath(this.myPath) || c.affectsProject(this.myProjectId)) && (this.myPattern == null || c.affectsMatching(this.myPattern))) {
            this.myResult.add(this.myCurrentChangeSet);
        }
        if (c instanceof StructuralChange) {
            this.myPath = ((StructuralChange)c).revertPath(this.myPath);
        }
    }

    private boolean skippedDueToNonexistence(Change c) {
        if (this.myExists) {
            return false;
        }
        if (c instanceof StructuralChange) {
            this.myPath = ((StructuralChange)c).revertPath(this.myPath);
        }
        return true;
    }
}

