/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core;

import com.intellij.util.io.PagePool;
import com.intellij.util.io.storage.AbstractRecordsTable;
import java.io.File;
import java.io.IOException;

public class LocalHistoryRecordsTable
extends AbstractRecordsTable {
    private static final int VERSION = 4;
    private static final int LAST_ID_OFFSET = 8;
    private static final int FIRST_RECORD_OFFSET = 16;
    private static final int LAST_RECORD_OFFSET = 20;
    private static final int FS_TIMESTAMP_OFFSET = 24;
    private static final int HEADER_SIZE = 32;
    private static final int PREV_RECORD_OFFSET = 16;
    private static final int NEXT_RECORD_OFFSET = 20;
    private static final int TIMESTAMP_OFFSET = 24;
    private static final int RECORD_SIZE = 32;
    private static final byte[] ZEROS = new byte[32];

    public LocalHistoryRecordsTable(File storageFilePath, PagePool pool) throws IOException {
        super(storageFilePath, pool);
    }

    @Override
    protected int getHeaderSize() {
        return 32;
    }

    @Override
    protected int getRecordSize() {
        return 32;
    }

    @Override
    protected int getImplVersion() {
        return 4;
    }

    @Override
    protected byte[] getZeros() {
        return ZEROS;
    }

    public long getLastId() {
        return this.myStorage.getLong(8L);
    }

    public void setLastId(long lastId) {
        this.markDirty();
        this.myStorage.putLong(8L, lastId);
    }

    public void setFirstRecord(int record) {
        this.markDirty();
        this.myStorage.putInt(16L, record);
    }

    public int getFirstRecord() {
        return this.myStorage.getInt(16L);
    }

    public void setLastRecord(int record) {
        this.markDirty();
        this.myStorage.putInt(20L, record);
    }

    public int getLastRecord() {
        return this.myStorage.getInt(20L);
    }

    public void setFSTimestamp(long timestamp) {
        this.markDirty();
        this.myStorage.putLong(24L, timestamp);
    }

    public long getFSTimestamp() {
        return this.myStorage.getLong(24L);
    }

    public void setPrevRecord(int record, int prevRecord) {
        this.markDirty();
        this.myStorage.putInt(this.getOffset(record, 16), prevRecord);
    }

    public int getPrevRecord(int record) {
        return this.myStorage.getInt(this.getOffset(record, 16));
    }

    public void setNextRecord(int record, int nextRecord) {
        this.markDirty();
        this.myStorage.putInt(this.getOffset(record, 20), nextRecord);
    }

    public int getNextRecord(int record) {
        return this.myStorage.getInt(this.getOffset(record, 20));
    }

    public void setTimestamp(int record, long timestamp) {
        this.markDirty();
        this.myStorage.putLong(this.getOffset(record, 24), timestamp);
    }

    public long getTimestamp(int record) {
        return this.myStorage.getLong(this.getOffset(record, 24));
    }
}

