/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;

public class Paths {
    public static final char DELIM = '/';
    private static boolean myIsCaseSensitive;

    public static String getNameOf(String path2) {
        int i = path2.lastIndexOf(47);
        if (i == -1 || path2.length() == 1) {
            return path2;
        }
        return path2.substring(i + 1);
    }

    public static String getParentOf(String path2) {
        int i = path2.lastIndexOf(47);
        if (i == -1) {
            return "";
        }
        if (i == 0) {
            i = 1;
        }
        return path2.substring(0, i);
    }

    public static String appended(String path2, String child2) {
        path2 = Paths.appendParent(path2);
        return path2 + child2;
    }

    public static String renamed(String path2, String newName) {
        return Paths.appended(Paths.getParentOf(path2), newName);
    }

    public static String reparented(String path2, String newParentPath) {
        return Paths.appended(newParentPath, Paths.getNameOf(path2));
    }

    public static String relativeIfUnder(String path2, String root) {
        if (!Paths.isParent(root, path2)) {
            return null;
        }
        if ((path2 = path2.substring(root.length())).length() == 0) {
            return "";
        }
        if (path2.charAt(0) != '/') {
            return null;
        }
        return path2.substring(1);
    }

    public static Iterable<String> split(String path2) {
        int prefixLen = 0;
        if (path2.startsWith("//")) {
            prefixLen = path2.indexOf(47, 2);
            if (prefixLen == -1) {
                prefixLen = path2.length();
            }
        } else if (StringUtil.startsWithChar(path2, '/')) {
            prefixLen = 1;
        }
        Iterable<String> result2 = StringUtil.tokenize(path2.substring(prefixLen), String.valueOf('/'));
        if (prefixLen > 0) {
            result2 = ContainerUtil.concat(Collections.singleton(path2.substring(0, prefixLen)), result2);
        }
        return result2;
    }

    public static boolean isParent(String parent, String path2) {
        if (Paths.equals(parent, path2)) {
            return true;
        }
        parent = Paths.appendParent(parent);
        return myIsCaseSensitive ? path2.startsWith(parent) : StringUtil.startsWithIgnoreCase(path2, parent);
    }

    private static String appendParent(String parent) {
        if (parent.isEmpty()) {
            return parent;
        }
        if (parent.charAt(parent.length() - 1) != '/') {
            parent = parent + '/';
        }
        return parent;
    }

    public static boolean isParentOrChild(String p1, String p2) {
        return Paths.isParent(p1, p2) || Paths.isParent(p2, p1);
    }

    public static boolean equals(String p1, String p2) {
        return myIsCaseSensitive ? p1.equals(p2) : p1.equalsIgnoreCase(p2);
    }

    public static void setCaseSensitive(boolean b) {
        myIsCaseSensitive = b;
    }

    public static boolean isCaseSensitive() {
        return myIsCaseSensitive;
    }

    public static void useSystemCaseSensitivity() {
        myIsCaseSensitive = SystemInfo.isFileSystemCaseSensitive;
    }

    static {
        Paths.useSystemCaseSensitivity();
    }
}

