/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core;

import com.intellij.history.core.Content;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class StoredContent
extends Content {
    private static final int UNAVAILABLE = 0;
    private int myContentId;

    public static StoredContent acquireContent(byte[] bytes) {
        return new StoredContent(StoredContent.getFS().storeUnlinkedContent(bytes));
    }

    public static StoredContent acquireContent(VirtualFile f) {
        return new StoredContent(StoredContent.getFS().acquireContent(f));
    }

    public static StoredContent transientContent(VirtualFile f) {
        return new StoredContent(StoredContent.getFS().getCurrentContentId(f)){

            @Override
            public void release() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void write(DataOutput out) throws IOException {
                throw new UnsupportedOperationException();
            }
        };
    }

    public StoredContent(int contentId) {
        this.myContentId = contentId;
    }

    public StoredContent(DataInput in) throws IOException {
        this.myContentId = DataInputOutputUtil.readINT(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        DataInputOutputUtil.writeINT(out, this.myContentId);
    }

    @Override
    public byte[] getBytes() {
        try {
            if (this.myContentId == 0) {
                return ArrayUtilRt.EMPTY_BYTE_ARRAY;
            }
            return StoredContent.getFS().contentsToByteArray(this.myContentId);
        }
        catch (IOException e) {
            throw new RuntimeException("cannot get stored content", e);
        }
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    private static PersistentFS getFS() {
        return PersistentFS.getInstance();
    }

    public int getContentId() {
        return this.myContentId;
    }

    @Override
    public void release() {
        if (this.myContentId == 0) {
            return;
        }
        StoredContent.getFS().releaseContent(this.myContentId);
        this.myContentId = 0;
    }

    @Override
    public boolean equals(Object o) {
        return this.myContentId == ((StoredContent)o).myContentId;
    }

    public int hashCode() {
        return this.myContentId;
    }
}

