/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.revisions;

import com.intellij.history.core.revisions.CurrentRevision;
import com.intellij.history.core.revisions.Difference;
import com.intellij.history.core.tree.Entry;
import com.intellij.openapi.util.Pair;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class Revision {
    @Nullable
    public String getLabel() {
        return null;
    }

    public int getLabelColor() {
        return -1;
    }

    public abstract long getTimestamp();

    @Nullable
    public Long getChangeSetId() {
        return null;
    }

    @Nullable
    public String getChangeSetName() {
        return null;
    }

    public boolean isLabel() {
        return ((List)this.getAffectedFileNames().first).isEmpty();
    }

    public Pair<List<String>, Integer> getAffectedFileNames() {
        return Pair.create(Collections.emptyList(), 0);
    }

    public abstract Entry findEntry();

    public List<Difference> getDifferencesWith(Revision right) {
        return Entry.getDifferencesBetween(this.findEntry(), right.findEntry(), right instanceof CurrentRevision);
    }
}

