/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.CliResult;
import com.intellij.ide.CommandLineProcessorResult;
import com.intellij.ide.CommandLineWaitingManager;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.lightEdit.LightEditFeatureUsagesUtil;
import com.intellij.ide.lightEdit.LightEditUtil;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.idea.CommandLineArgs;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.application.JBProtocolCommand;
import com.intellij.openapi.application.JetBrainsProtocolHandler;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.platform.CommandLineProjectOpenProcessor;
import com.intellij.pom.Navigatable;
import com.intellij.util.PlatformUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CommandLineProcessor {
    private static final Logger LOG = Logger.getInstance(CommandLineProcessor.class);
    private static final String OPTION_WAIT = "--wait";

    private CommandLineProcessor() {
    }

    @NotNull
    private static CommandLineProcessorResult doOpenFileOrProject(Path file2, boolean shouldWait) {
        OpenProjectTask openProjectOptions = new OpenProjectTask();
        openProjectOptions.checkDirectoryForFileBasedProjects = false;
        Project project2 = ProjectUtil.openOrImport(file2, openProjectOptions);
        if (project2 == null) {
            return CommandLineProcessor.doOpenFile(file2, -1, -1, false, shouldWait);
        }
        return new CommandLineProcessorResult(project2, shouldWait ? CommandLineWaitingManager.getInstance().addHookForProject(project2) : CliResult.OK_FUTURE);
    }

    @NotNull
    private static CommandLineProcessorResult doOpenFile(@NotNull Path ioFile, int line, int column, boolean tempProject, boolean shouldWait) {
        Project project2;
        RecentProjectsManager recentProjectsManager;
        Project[] projects;
        if (ioFile == null) {
            CommandLineProcessor.$$$reportNull$$$0(0);
        }
        VirtualFile file2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.toSystemIndependentName(ioFile.toString()));
        assert (file2 != null);
        Project[] projectArray = projects = tempProject ? new Project[]{} : ProjectUtil.getOpenProjects();
        if (PlatformUtils.isDataGrip() && !tempProject && projects.length == 0 && (recentProjectsManager = RecentProjectsManager.getInstance()).willReopenProjectOnStart() && recentProjectsManager.reopenLastProjectsOnStart()) {
            projects = ProjectUtil.getOpenProjects();
        }
        if (projects.length == 0) {
            project2 = CommandLineProjectOpenProcessor.getInstance().openProjectAndFile(file2, line, column, tempProject);
            if (project2 == null) {
                CommandLineProcessorResult commandLineProcessorResult = CommandLineProcessorResult.createError("No project found to open file in");
                if (commandLineProcessorResult == null) {
                    CommandLineProcessor.$$$reportNull$$$0(1);
                }
                return commandLineProcessorResult;
            }
            return new CommandLineProcessorResult(project2, shouldWait ? CommandLineWaitingManager.getInstance().addHookForFile(file2) : CliResult.OK_FUTURE);
        }
        NonProjectFileWritingAccessProvider.allowWriting(Collections.singletonList(file2));
        project2 = CommandLineProcessor.findBestProject(file2, projects);
        if (LightEdit.owns(project2)) {
            if (LightEdit.openFile(file2)) {
                LightEditFeatureUsagesUtil.logFileOpen(LightEditFeatureUsagesUtil.OpenPlace.CommandLine);
            }
        } else {
            Navigatable navigatable = line > 0 ? new OpenFileDescriptor(project2, file2, line - 1, Math.max(column, 0)) : PsiNavigationSupport.getInstance().createNavigatable(project2, file2, -1);
            ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith(project2)).execute(() -> navigatable.navigate(true));
        }
        return new CommandLineProcessorResult(project2, shouldWait ? CommandLineWaitingManager.getInstance().addHookForFile(file2) : CliResult.OK_FUTURE);
    }

    @NotNull
    private static Project findBestProject(@NotNull VirtualFile file2, @NotNull @NotNull Project @NotNull [] projects) {
        Project project2;
        if (file2 == null) {
            CommandLineProcessor.$$$reportNull$$$0(2);
        }
        if (projects == null) {
            CommandLineProcessor.$$$reportNull$$$0(3);
        }
        for (Project project3 : projects) {
            ProjectFileIndex fileIndex = ProjectFileIndex.getInstance(project3);
            if (!ReadAction.compute(() -> fileIndex.isInContent(file2)).booleanValue()) continue;
            Project project4 = project3;
            if (project4 == null) {
                CommandLineProcessor.$$$reportNull$$$0(4);
            }
            return project4;
        }
        if (LightEditUtil.isLightEditEnabled()) {
            Project project5 = LightEditUtil.getProject();
            if (project5 == null) {
                CommandLineProcessor.$$$reportNull$$$0(5);
            }
            return project5;
        }
        IdeFrame frame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
        if (frame != null && (project2 = frame.getProject()) != null) {
            Project project6 = project2;
            if (project6 == null) {
                CommandLineProcessor.$$$reportNull$$$0(6);
            }
            return project6;
        }
        Project project7 = projects[0];
        if (project7 == null) {
            CommandLineProcessor.$$$reportNull$$$0(7);
        }
        return project7;
    }

    @NotNull
    public static CommandLineProcessorResult processExternalCommandLine(@NotNull List<String> args, @Nullable String currentDirectory) {
        if (args == null) {
            CommandLineProcessor.$$$reportNull$$$0(8);
        }
        StringBuilder logMessage = new StringBuilder();
        logMessage.append("External command line:").append('\n');
        logMessage.append("Dir: ").append(currentDirectory).append('\n');
        for (String arg : args) {
            logMessage.append(arg).append('\n');
        }
        logMessage.append("-----");
        LOG.info(logMessage.toString());
        if (args.isEmpty()) {
            return new CommandLineProcessorResult(null, CliResult.OK_FUTURE);
        }
        String command = args.get(0);
        CommandLineProcessorResult result2 = ApplicationStarter.EP_NAME.computeSafeIfAny(starter2 -> {
            if (!command.equals(starter2.getCommandName())) {
                return null;
            }
            if (starter2.canProcessExternalCommandLine()) {
                LOG.info("Processing command with " + starter2);
                return new CommandLineProcessorResult(null, starter2.processExternalCommandLineAsync(args, currentDirectory));
            }
            return CommandLineProcessorResult.createError("Only one instance of " + ApplicationNamesInfo.getInstance().getProductName() + " can be run at a time.");
        });
        if (result2 != null) {
            CommandLineProcessorResult commandLineProcessorResult = result2;
            if (commandLineProcessorResult == null) {
                CommandLineProcessor.$$$reportNull$$$0(9);
            }
            return commandLineProcessorResult;
        }
        if (command.startsWith("jetbrains://")) {
            JetBrainsProtocolHandler.processJetBrainsLauncherParameters(command);
            ApplicationManager.getApplication().invokeLater(() -> JBProtocolCommand.handleCurrentCommand());
            return new CommandLineProcessorResult(null, CliResult.OK_FUTURE);
        }
        CommandLineProcessorResult projectAndCallback = null;
        int line = -1;
        int column = -1;
        boolean tempProject = false;
        boolean shouldWait = args.contains(OPTION_WAIT);
        for (int i = 0; i < args.size(); ++i) {
            Path file2;
            String arg = args.get(i);
            if (CommandLineArgs.isKnownArgument(arg) || OPTION_WAIT.equals(arg)) continue;
            if (arg.equals("-l") || arg.equals("--line")) {
                if (++i == args.size()) break;
                line = StringUtil.parseInt(args.get(i), -1);
                continue;
            }
            if (arg.equals("-c") || arg.equals("--column")) {
                if (++i == args.size()) break;
                column = StringUtil.parseInt(args.get(i), -1);
                continue;
            }
            if (arg.equals("--temp-project")) {
                tempProject = true;
                continue;
            }
            if (StringUtil.isQuotedString(arg)) {
                arg = StringUtil.unquoteString(arg);
            }
            if (!(file2 = Paths.get(arg, new String[0])).isAbsolute()) {
                Path path2 = file2 = currentDirectory == null ? file2.toAbsolutePath() : Paths.get(currentDirectory, new String[0]).resolve(file2);
            }
            if (!Files.exists(file2 = file2.normalize(), new LinkOption[0])) {
                CommandLineProcessorResult commandLineProcessorResult = CommandLineProcessorResult.createError("Cannot find file '" + file2 + "'");
                if (commandLineProcessorResult == null) {
                    CommandLineProcessor.$$$reportNull$$$0(10);
                }
                return commandLineProcessorResult;
            }
            projectAndCallback = line != -1 || tempProject ? CommandLineProcessor.doOpenFile(file2, line, column, tempProject, shouldWait) : CommandLineProcessor.doOpenFileOrProject(file2, shouldWait);
            if (shouldWait) break;
            column = -1;
            line = -1;
            tempProject = false;
        }
        if (shouldWait && projectAndCallback == null) {
            return new CommandLineProcessorResult(null, CliResult.error(1, "--wait must be supplied with file or project to wait for"));
        }
        CommandLineProcessorResult commandLineProcessorResult = projectAndCallback == null ? new CommandLineProcessorResult(null, CliResult.OK_FUTURE) : projectAndCallback;
        if (commandLineProcessorResult == null) {
            CommandLineProcessor.$$$reportNull$$$0(11);
        }
        return commandLineProcessorResult;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ioFile";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/CommandLineProcessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projects";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/CommandLineProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "doOpenFile";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findBestProject";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "processExternalCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doOpenFile";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findBestProject";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processExternalCommandLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

