/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.CopyPasteSupport;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.CutProvider;
import com.intellij.ide.DataManager;
import com.intellij.ide.PasteProvider;
import com.intellij.ide.PsiCopyPasteManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.copy.CopyHandler;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandler;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyPasteDelegator
implements CopyPasteSupport {
    private static final ExtensionPointName<PasteProvider> EP_NAME = ExtensionPointName.create("com.intellij.filePasteProvider");
    public static final Key<Boolean> SHOW_CHOOSER_KEY = Key.create("show.dirs.chooser");
    private final Project myProject;
    private final JComponent myKeyReceiver;
    private final MyEditable myEditable;

    public CopyPasteDelegator(@NotNull Project project2, @NotNull JComponent keyReceiver) {
        if (project2 == null) {
            CopyPasteDelegator.$$$reportNull$$$0(0);
        }
        if (keyReceiver == null) {
            CopyPasteDelegator.$$$reportNull$$$0(1);
        }
        this.myProject = project2;
        this.myKeyReceiver = keyReceiver;
        this.myEditable = new MyEditable();
    }

    protected PsiElement @NotNull [] getSelectedElements() {
        DataContext dataContext = DataManager.getInstance().getDataContext(this.myKeyReceiver);
        PsiElement[] psiElementArray = ObjectUtils.notNull(LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext), PsiElement.EMPTY_ARRAY);
        if (psiElementArray == null) {
            CopyPasteDelegator.$$$reportNull$$$0(2);
        }
        return psiElementArray;
    }

    private PsiElement @NotNull [] getValidSelectedElements() {
        PsiElement[] selectedElements;
        for (PsiElement element2 : selectedElements = this.getSelectedElements()) {
            if (element2 != null && element2.isValid()) continue;
            if (PsiElement.EMPTY_ARRAY == null) {
                CopyPasteDelegator.$$$reportNull$$$0(3);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        if (selectedElements == null) {
            CopyPasteDelegator.$$$reportNull$$$0(4);
        }
        return selectedElements;
    }

    private void updateView() {
        this.myKeyReceiver.repaint();
    }

    @Override
    public CopyProvider getCopyProvider() {
        return this.myEditable;
    }

    @Override
    public CutProvider getCutProvider() {
        return this.myEditable;
    }

    @Override
    public PasteProvider getPasteProvider() {
        return this.myEditable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyReceiver";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/CopyPasteDelegator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/CopyPasteDelegator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedElements";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidSelectedElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyEditable
    implements CutProvider,
    CopyProvider,
    PasteProvider {
        private MyEditable() {
        }

        @Override
        public void performCopy(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyEditable.$$$reportNull$$$0(0);
            }
            PsiElement[] elements2 = CopyPasteDelegator.this.getValidSelectedElements();
            PsiCopyPasteManager.getInstance().setElements(elements2, true);
            CopyPasteDelegator.this.updateView();
        }

        @Override
        public boolean isCopyEnabled(@NotNull DataContext dataContext) {
            PsiElement[] elements2;
            if (dataContext == null) {
                MyEditable.$$$reportNull$$$0(1);
            }
            return CopyHandler.canCopy(elements2 = CopyPasteDelegator.this.getValidSelectedElements()) || JBIterable.of(elements2).filter(Conditions.instanceOf(PsiNamedElement.class)).isNotEmpty();
        }

        @Override
        public boolean isCopyVisible(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyEditable.$$$reportNull$$$0(2);
            }
            return true;
        }

        @Override
        public void performCut(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyEditable.$$$reportNull$$$0(3);
            }
            PsiElement[] elements2 = CopyPasteDelegator.this.getValidSelectedElements();
            if (MoveHandler.adjustForMove(CopyPasteDelegator.this.myProject, elements2, null) == null) {
                return;
            }
            PsiCopyPasteManager.getInstance().setElements(elements2, false);
            CopyPasteDelegator.this.updateView();
        }

        @Override
        public boolean isCutEnabled(@NotNull DataContext dataContext) {
            PsiElement[] elements2;
            if (dataContext == null) {
                MyEditable.$$$reportNull$$$0(4);
            }
            return (elements2 = CopyPasteDelegator.this.getValidSelectedElements()).length != 0 && MoveHandler.canMove(elements2, null);
        }

        @Override
        public boolean isCutVisible(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyEditable.$$$reportNull$$$0(5);
            }
            return true;
        }

        @Override
        public void performPaste(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyEditable.$$$reportNull$$$0(6);
            }
            if (!this.performDefaultPaste(dataContext)) {
                for (PasteProvider provider : EP_NAME.getExtensionList()) {
                    if (!provider.isPasteEnabled(dataContext)) continue;
                    provider.performPaste(dataContext);
                    break;
                }
            }
        }

        private boolean performDefaultPaste(DataContext dataContext) {
            boolean[] isCopied = new boolean[1];
            PsiElement[] elements2 = PsiCopyPasteManager.getInstance().getElements(isCopied);
            if (elements2 == null) {
                return false;
            }
            return DumbService.getInstance(CopyPasteDelegator.this.myProject).computeWithAlternativeResolveEnabled(() -> {
                block5: {
                    try {
                        Module module2 = LangDataKeys.MODULE.getData(dataContext);
                        PsiElement target2 = this.getPasteTarget(dataContext, module2);
                        if (isCopied[0]) {
                            this.pasteAfterCopy(elements2, module2, target2, true);
                            break block5;
                        }
                        if (MoveHandler.canMove(elements2, target2)) {
                            this.pasteAfterCut(dataContext, elements2, target2);
                            break block5;
                        }
                        Boolean bl = false;
                        return bl;
                    }
                    finally {
                        CopyPasteDelegator.this.updateView();
                    }
                }
                return true;
            });
        }

        private PsiElement getPasteTarget(@NotNull DataContext dataContext, @Nullable Module module2) {
            PsiDirectory[] directories;
            if (dataContext == null) {
                MyEditable.$$$reportNull$$$0(7);
            }
            PsiElement target2 = LangDataKeys.PASTE_TARGET_PSI_ELEMENT.getData(dataContext);
            if (module2 != null && target2 instanceof PsiDirectoryContainer && (directories = ((PsiDirectoryContainer)target2).getDirectories(GlobalSearchScope.moduleScope(module2))).length == 1) {
                return directories[0];
            }
            return target2;
        }

        @Nullable
        private PsiDirectory getTargetDirectory(@Nullable Module module2, @Nullable PsiElement target2) {
            PsiFile containingFile;
            PsiDirectory targetDirectory;
            PsiDirectory psiDirectory = targetDirectory = target2 instanceof PsiDirectory ? (PsiDirectory)target2 : null;
            if (targetDirectory == null && target2 instanceof PsiDirectoryContainer) {
                PsiDirectory[] directories;
                PsiDirectory[] psiDirectoryArray = directories = module2 == null ? ((PsiDirectoryContainer)target2).getDirectories() : ((PsiDirectoryContainer)target2).getDirectories(GlobalSearchScope.moduleScope(module2));
                if (directories.length > 0) {
                    targetDirectory = directories[0];
                    targetDirectory.putCopyableUserData(SHOW_CHOOSER_KEY, directories.length > 1);
                }
            }
            if (targetDirectory == null && target2 != null && (containingFile = target2.getContainingFile()) != null) {
                targetDirectory = containingFile.getContainingDirectory();
            }
            return targetDirectory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void pasteAfterCopy(PsiElement[] elements2, Module module2, PsiElement target2, boolean tryFromFiles) {
            PsiDirectory targetDirectory = elements2.length == 1 && elements2[0] == target2 ? null : this.getTargetDirectory(module2, target2);
            try {
                List<File> files2;
                if (CopyHandler.canCopy(elements2)) {
                    CopyHandler.doCopy(elements2, targetDirectory);
                } else if (tryFromFiles && (files2 = PsiCopyPasteManager.asFileList(elements2)) != null) {
                    PsiManager manager = elements2[0].getManager();
                    PsiElement[] items = (PsiFileSystemItem[])files2.stream().map(file2 -> LocalFileSystem.getInstance().findFileByIoFile((File)file2)).map(file2 -> {
                        if (file2 != null) {
                            return file2.isDirectory() ? manager.findDirectory((VirtualFile)file2) : manager.findFile((VirtualFile)file2);
                        }
                        return null;
                    }).filter(file2 -> file2 != null).toArray(PsiFileSystemItem[]::new);
                    this.pasteAfterCopy(items, module2, target2, false);
                }
            }
            finally {
                if (targetDirectory != null) {
                    targetDirectory.putCopyableUserData(SHOW_CHOOSER_KEY, null);
                }
            }
        }

        private void pasteAfterCut(DataContext dataContext, PsiElement[] elements2, PsiElement target2) {
            MoveHandler.doMove(CopyPasteDelegator.this.myProject, elements2, target2, dataContext, new MoveCallback(){

                @Override
                public void refactoringCompleted() {
                    PsiCopyPasteManager.getInstance().clear();
                }
            });
        }

        @Override
        public boolean isPastePossible(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyEditable.$$$reportNull$$$0(8);
            }
            return true;
        }

        @Override
        public boolean isPasteEnabled(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyEditable.$$$reportNull$$$0(9);
            }
            if (this.isDefaultPasteEnabled(dataContext)) {
                return true;
            }
            for (PasteProvider provider : EP_NAME.getExtensionList()) {
                if (!provider.isPasteEnabled(dataContext)) continue;
                return true;
            }
            return false;
        }

        private boolean isDefaultPasteEnabled(DataContext dataContext) {
            Project project2 = CommonDataKeys.PROJECT.getData(dataContext);
            if (project2 == null) {
                return false;
            }
            if (DumbService.isDumb(project2)) {
                return false;
            }
            PsiElement target2 = LangDataKeys.PASTE_TARGET_PSI_ELEMENT.getData(dataContext);
            if (target2 == null) {
                return false;
            }
            PsiElement[] elements2 = PsiCopyPasteManager.getInstance().getElements(new boolean[]{false});
            if (elements2 == null) {
                return false;
            }
            for (PsiElement element2 : elements2) {
                PsiManager manager = element2.getManager();
                if (manager != null && manager.getProject() == project2) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "dataContext";
            objectArray2[1] = "com/intellij/ide/CopyPasteDelegator$MyEditable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performCopy";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isCopyEnabled";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isCopyVisible";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performCut";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isCutEnabled";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isCutVisible";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performPaste";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getPasteTarget";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isPastePossible";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isPasteEnabled";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

