/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.AppTopics;
import com.intellij.ProjectTopics;
import com.intellij.ide.GeneratedSourceFileChangeTracker;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.Alarm;
import com.intellij.util.SingleAlarm;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public final class GeneratedSourceFileChangeTrackerImpl
extends GeneratedSourceFileChangeTracker {
    private final Project myProject;
    private final SingleAlarm myCheckingQueue;
    private final Set<VirtualFile> myFilesToCheck;
    private final Set<VirtualFile> myEditedGeneratedFiles;
    public static boolean IN_TRACKER_TEST;

    public GeneratedSourceFileChangeTrackerImpl(@NotNull Project project2) {
        if (project2 == null) {
            GeneratedSourceFileChangeTrackerImpl.$$$reportNull$$$0(0);
        }
        this.myFilesToCheck = Collections.synchronizedSet(new HashSet());
        this.myEditedGeneratedFiles = Collections.synchronizedSet(new HashSet());
        this.myProject = project2;
        this.myCheckingQueue = new SingleAlarm(this::checkFiles, 500, Alarm.ThreadToUse.POOLED_THREAD, (Disposable)project2);
    }

    /*
     * WARNING - void declaration
     */
    void waitForAlarm(long timeout, @NotNull TimeUnit timeUnit) throws Exception {
        void timeUnit2;
        if (timeUnit == null) {
            GeneratedSourceFileChangeTrackerImpl.$$$reportNull$$$0(1);
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            throw new IllegalStateException("Must not wait for the alarm under write action");
        }
        this.myCheckingQueue.waitForAllExecuted(timeout, (TimeUnit)timeUnit2);
    }

    /*
     * WARNING - void declaration
     */
    public void cancelAllAndWait(long timeout, @NotNull TimeUnit timeUnit) throws Exception {
        void timeUnit2;
        if (timeUnit == null) {
            GeneratedSourceFileChangeTrackerImpl.$$$reportNull$$$0(2);
        }
        this.myFilesToCheck.clear();
        this.myCheckingQueue.cancelAllRequests();
        this.waitForAlarm(timeout, (TimeUnit)timeUnit2);
    }

    @Override
    public boolean isEditedGeneratedFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            GeneratedSourceFileChangeTrackerImpl.$$$reportNull$$$0(3);
        }
        return this.myEditedGeneratedFiles.contains(file2);
    }

    private static boolean isListenerInactive() {
        return !IN_TRACKER_TEST && ApplicationManager.getApplication().isUnitTestMode();
    }

    private void projectOpened() {
        MessageBusConnection connection = this.myProject.getMessageBus().connect();
        connection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, new FileDocumentManagerListener(){

            @Override
            public void fileContentReloaded(@NotNull VirtualFile file2, @NotNull Document document) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (document == null) {
                    1.$$$reportNull$$$0(1);
                }
                GeneratedSourceFileChangeTrackerImpl.this.myFilesToCheck.remove(file2);
                if (GeneratedSourceFileChangeTrackerImpl.this.myEditedGeneratedFiles.remove(file2)) {
                    EditorNotifications.getInstance(GeneratedSourceFileChangeTrackerImpl.this.myProject).updateNotifications(file2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "document";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/GeneratedSourceFileChangeTrackerImpl$1";
                objectArray[2] = "fileContentReloaded";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, new FileEditorManagerListener(){

            @Override
            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                if (source == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (file2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                GeneratedSourceFileChangeTrackerImpl.this.myEditedGeneratedFiles.remove(file2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "source";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/GeneratedSourceFileChangeTrackerImpl$2";
                objectArray[2] = "fileClosed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, new ModuleRootListener(){

            @Override
            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                GeneratedSourceFileChangeTrackerImpl.this.myFilesToCheck.addAll(GeneratedSourceFileChangeTrackerImpl.this.myEditedGeneratedFiles);
                GeneratedSourceFileChangeTrackerImpl.this.myEditedGeneratedFiles.clear();
                GeneratedSourceFileChangeTrackerImpl.this.myCheckingQueue.cancelAndRequest();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/GeneratedSourceFileChangeTrackerImpl$3", "rootsChanged"));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFiles() {
        VirtualFile[] files2;
        Set<VirtualFile> set = this.myFilesToCheck;
        synchronized (set) {
            files2 = this.myFilesToCheck.toArray(VirtualFile.EMPTY_ARRAY);
            this.myFilesToCheck.clear();
        }
        if (files2.length == 0) {
            return;
        }
        ArrayList newEditedGeneratedFiles = new ArrayList();
        ReadAction.run(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            for (VirtualFile file2 : files2) {
                if (!GeneratedSourcesFilter.isGeneratedSourceByAnyFilter(file2, this.myProject)) continue;
                newEditedGeneratedFiles.add(file2);
            }
        });
        if (!newEditedGeneratedFiles.isEmpty()) {
            this.myEditedGeneratedFiles.addAll(newEditedGeneratedFiles);
            EditorNotifications.getInstance(this.myProject).updateAllNotifications();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeUnit";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/GeneratedSourceFileChangeTrackerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "waitForAlarm";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "cancelAllAndWait";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isEditedGeneratedFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class MyProjectManagerListener
    implements ProjectManagerListener {
        MyProjectManagerListener() {
        }

        @Override
        public void projectOpened(@NotNull Project project2) {
            if (project2 == null) {
                MyProjectManagerListener.$$$reportNull$$$0(0);
            }
            if (GeneratedSourceFileChangeTrackerImpl.isListenerInactive()) {
                return;
            }
            ((GeneratedSourceFileChangeTrackerImpl)GeneratedSourceFileChangeTracker.getInstance(project2)).projectOpened();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/GeneratedSourceFileChangeTrackerImpl$MyProjectManagerListener", "projectOpened"));
        }
    }

    static final class MyDocumentListener
    implements DocumentListener {
        MyDocumentListener() {
        }

        @Override
        public void documentChanged(@NotNull DocumentEvent event) {
            if (event == null) {
                MyDocumentListener.$$$reportNull$$$0(0);
            }
            if (GeneratedSourceFileChangeTrackerImpl.isListenerInactive()) {
                return;
            }
            Project[] openProjects = ProjectUtil.getOpenProjects();
            if (openProjects.length == 0) {
                return;
            }
            VirtualFile file2 = FileDocumentManager.getInstance().getFile(event.getDocument());
            if (file2 == null) {
                return;
            }
            for (Project project2 : ProjectUtil.getOpenProjects()) {
                if (project2.isDisposed()) continue;
                GeneratedSourceFileChangeTrackerImpl fileChangeTracker = (GeneratedSourceFileChangeTrackerImpl)GeneratedSourceFileChangeTracker.getInstance(project2);
                ProjectFileIndex fileIndex = ProjectFileIndex.getInstance(project2);
                if (!fileIndex.isInContent(file2) && !fileIndex.isInLibrary(file2)) continue;
                fileChangeTracker.myFilesToCheck.add(file2);
                fileChangeTracker.myCheckingQueue.cancelAndRequest();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/GeneratedSourceFileChangeTrackerImpl$MyDocumentListener", "documentChanged"));
        }
    }
}

