/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Alarm;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.BooleanSupplier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HelpTooltip {
    private static final Color BACKGROUND_COLOR = JBColor.namedColor("ToolTip.background", new JBColor(0xF7F7F7, 4672076));
    private static final Color SHORTCUT_COLOR = JBColor.namedColor("ToolTip.shortcutForeground", new JBColor(0x787878, 0x999999));
    private static final Color INFO_COLOR = JBColor.namedColor("ToolTip.infoForeground", UIUtil.getContextHelpForeground());
    private static final Color BORDER_COLOR = JBColor.namedColor("ToolTip.borderColor", new JBColor(0xADADAD, 6514025));
    private static final JBValue VGAP = new JBValue.UIInteger("HelpTooltip.verticalGap", 4);
    private static final JBValue MAX_WIDTH = new JBValue.UIInteger("HelpTooltip.maxWidth", 250);
    private static final JBValue X_OFFSET = new JBValue.UIInteger("HelpTooltip.xOffset", 0);
    private static final JBValue Y_OFFSET = new JBValue.UIInteger("HelpTooltip.yOffset", 0);
    private static final JBValue HEADER_FONT_SIZE_DELTA = new JBValue.UIInteger("HelpTooltip.fontSizeDelta", 0);
    private static final JBValue DESCRIPTION_FONT_SIZE_DELTA = new JBValue.UIInteger("HelpTooltip.descriptionSizeDelta", 0);
    private static final JBValue CURSOR_OFFSET = new JBValue.UIInteger("HelpTooltip.mouseCursorOffset", 20);
    private static final String PARAGRAPH_SPLITTER = "<p/?>";
    private static final String TOOLTIP_PROPERTY = "JComponent.helpTooltip";
    private String title;
    private String shortcut;
    private String description;
    private LinkLabel<?> link;
    private boolean neverHide;
    private Alignment alignment = Alignment.CURSOR;
    private BooleanSupplier masterPopupOpenCondition;
    private ComponentPopupBuilder myPopupBuilder;
    private Dimension myPopupSize;
    private JBPopup myPopup;
    private final Alarm popupAlarm = new Alarm();
    private boolean isOverPopup;
    private boolean isMultiline;
    private int myDismissDelay;
    protected MouseAdapter myMouseListener;

    public HelpTooltip setTitle(@Nullable String title) {
        this.title = title;
        return this;
    }

    public HelpTooltip setShortcut(@Nullable String shortcut) {
        this.shortcut = shortcut;
        return this;
    }

    public HelpTooltip setDescription(@Nullable String description) {
        this.description = description;
        return this;
    }

    public HelpTooltip setLink(String linkText, Runnable linkAction) {
        this.link = LinkLabel.create(linkText, () -> {
            this.hidePopup(true);
            linkAction.run();
        });
        return this;
    }

    public HelpTooltip setNeverHideOnTimeout(boolean neverHide) {
        this.neverHide = neverHide;
        return this;
    }

    public HelpTooltip setLocation(Alignment alignment) {
        this.alignment = alignment;
        return this;
    }

    public void installOn(@NotNull JComponent component2) {
        if (component2 == null) {
            HelpTooltip.$$$reportNull$$$0(0);
        }
        this.getDismissDelay();
        this.neverHide = this.neverHide || UIUtil.isHelpButton(component2);
        this.createMouseListeners();
        this.initPopupBuilder();
        component2.putClientProperty(TOOLTIP_PROPERTY, this);
        this.installMouseListeners(component2);
    }

    protected final void getDismissDelay() {
        this.myDismissDelay = Registry.intValue(this.isMultiline ? "ide.helptooltip.full.dismissDelay" : "ide.helptooltip.regular.dismissDelay");
    }

    protected final void createMouseListeners() {
        this.myMouseListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (HelpTooltip.this.myPopup != null && !HelpTooltip.this.myPopup.isDisposed()) {
                    HelpTooltip.this.myPopup.cancel();
                }
                HelpTooltip.this.scheduleShow(e, Registry.intValue("ide.tooltip.initialReshowDelay"));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                HelpTooltip.this.scheduleHide(HelpTooltip.this.link == null, Registry.intValue("ide.tooltip.initialDelay.highlighter"));
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (HelpTooltip.this.myPopup == null || HelpTooltip.this.myPopup.isDisposed()) {
                    HelpTooltip.this.scheduleShow(e, Registry.intValue("ide.tooltip.reshowDelay"));
                }
            }
        };
    }

    private void initPopupBuilder() {
        JPanel tipPanel = this.createTipPanel();
        tipPanel.addMouseListener(this.createIsOverTipMouseListener());
        this.myPopupSize = tipPanel.getPreferredSize();
        this.myPopupBuilder = JBPopupFactory.getInstance().createComponentPopupBuilder(tipPanel, null).setShowBorder(UIManager.getBoolean("ToolTip.paintBorder")).setBorderColor(BORDER_COLOR).setShowShadow(true);
    }

    protected void initPopupBuilder(@NotNull HelpTooltip instance2) {
        if (instance2 == null) {
            HelpTooltip.$$$reportNull$$$0(1);
        }
        instance2.initPopupBuilder();
        this.myPopupSize = instance2.myPopupSize;
        this.myPopupBuilder = instance2.myPopupBuilder;
    }

    @NotNull
    private MouseListener createIsOverTipMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                HelpTooltip.this.isOverPopup = true;
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (HelpTooltip.this.link == null || !HelpTooltip.this.link.getBounds().contains(e.getPoint())) {
                    HelpTooltip.this.isOverPopup = false;
                    HelpTooltip.this.hidePopup(false);
                }
            }
        };
    }

    @NotNull
    protected final JPanel createTipPanel() {
        JPanel tipPanel = new JPanel();
        tipPanel.setLayout(new VerticalLayout(VGAP.get()));
        tipPanel.setBackground(BACKGROUND_COLOR);
        boolean hasTitle = StringUtil.isNotEmpty(this.title);
        boolean hasDescription = StringUtil.isNotEmpty(this.description);
        if (hasTitle) {
            tipPanel.add((Component)new Header(hasDescription), "TOP");
        }
        if (hasDescription) {
            String[] pa = this.description.split(PARAGRAPH_SPLITTER);
            this.isMultiline = pa.length > 1;
            Arrays.stream(pa).filter(p -> !p.isEmpty()).forEach(p -> tipPanel.add((Component)new Paragraph((String)p, hasTitle), "TOP"));
        }
        if (!hasTitle && StringUtil.isNotEmpty(this.shortcut)) {
            JLabel shortcutLabel = new JLabel(this.shortcut);
            shortcutLabel.setFont(HelpTooltip.deriveDescriptionFont(shortcutLabel.getFont(), false));
            shortcutLabel.setForeground(SHORTCUT_COLOR);
            tipPanel.add((Component)shortcutLabel, "TOP");
        }
        if (this.link != null) {
            this.link.setFont(HelpTooltip.deriveDescriptionFont(this.link.getFont(), hasTitle));
            tipPanel.add(this.link, "TOP");
        }
        this.isMultiline = this.isMultiline || StringUtil.isNotEmpty(this.description) && (StringUtil.isNotEmpty(this.title) || this.link != null);
        tipPanel.setBorder(HelpTooltip.textBorder(this.isMultiline));
        JPanel jPanel = tipPanel;
        if (jPanel == null) {
            HelpTooltip.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    private void installMouseListeners(@NotNull JComponent owner) {
        if (owner == null) {
            HelpTooltip.$$$reportNull$$$0(3);
        }
        owner.addMouseListener(this.myMouseListener);
        owner.addMouseMotionListener(this.myMouseListener);
    }

    private void uninstallMouseListeners(@NotNull JComponent owner) {
        if (owner == null) {
            HelpTooltip.$$$reportNull$$$0(4);
        }
        owner.removeMouseListener(this.myMouseListener);
        owner.removeMouseMotionListener(this.myMouseListener);
    }

    public static void dispose(@NotNull Component owner) {
        JComponent component2;
        HelpTooltip instance2;
        if (owner == null) {
            HelpTooltip.$$$reportNull$$$0(5);
        }
        if (owner instanceof JComponent && (instance2 = (HelpTooltip)(component2 = (JComponent)owner).getClientProperty(TOOLTIP_PROPERTY)) != null) {
            instance2.hidePopup(true);
            instance2.uninstallMouseListeners(component2);
            component2.putClientProperty(TOOLTIP_PROPERTY, null);
            instance2.masterPopupOpenCondition = null;
        }
    }

    public static void hide(@NotNull Component owner) {
        HelpTooltip instance2;
        if (owner == null) {
            HelpTooltip.$$$reportNull$$$0(6);
        }
        if (owner instanceof JComponent && (instance2 = (HelpTooltip)((JComponent)owner).getClientProperty(TOOLTIP_PROPERTY)) != null) {
            instance2.hidePopup(true);
        }
    }

    public static void setMasterPopup(@NotNull Component owner, JBPopup master) {
        HelpTooltip instance2;
        if (owner == null) {
            HelpTooltip.$$$reportNull$$$0(7);
        }
        if (owner instanceof JComponent && (instance2 = (HelpTooltip)((JComponent)owner).getClientProperty(TOOLTIP_PROPERTY)) != null && instance2.myPopup != master) {
            instance2.masterPopupOpenCondition = () -> master == null || !master.isVisible();
        }
    }

    public static void setMasterPopupOpenCondition(@NotNull Component owner, @Nullable BooleanSupplier condition2) {
        HelpTooltip instance2;
        if (owner == null) {
            HelpTooltip.$$$reportNull$$$0(8);
        }
        if (owner instanceof JComponent && (instance2 = (HelpTooltip)((JComponent)owner).getClientProperty(TOOLTIP_PROPERTY)) != null) {
            instance2.masterPopupOpenCondition = condition2;
        }
    }

    private void scheduleShow(MouseEvent e, int delay) {
        this.popupAlarm.cancelAllRequests();
        this.popupAlarm.addRequest(() -> {
            if (this.masterPopupOpenCondition == null || this.masterPopupOpenCondition.getAsBoolean()) {
                this.myPopup = this.myPopupBuilder.createPopup();
                Component owner = e.getComponent();
                this.myPopup.show(new RelativePoint(owner, this.alignment.getPointFor(owner, this.myPopupSize, e.getPoint())));
                if (!this.neverHide) {
                    this.scheduleHide(true, this.myDismissDelay);
                }
            }
        }, delay);
    }

    private void scheduleHide(boolean force, int delay) {
        this.popupAlarm.cancelAllRequests();
        this.popupAlarm.addRequest(() -> this.hidePopup(force), delay);
    }

    protected void hidePopup(boolean force) {
        this.popupAlarm.cancelAllRequests();
        if (this.myPopup != null && this.myPopup.isVisible() && (!this.isOverPopup || force)) {
            this.myPopup.cancel();
            this.myPopup = null;
        }
    }

    private static Border textBorder(boolean multiline) {
        Insets i = UIManager.getInsets(multiline ? "HelpTooltip.defaultTextBorderInsets" : "HelpTooltip.smallTextBorderInsets");
        return i != null ? new JBEmptyBorder(i) : JBUI.Borders.empty();
    }

    private static Font deriveHeaderFont(Font font) {
        return font.deriveFont((float)font.getSize() + (float)HEADER_FONT_SIZE_DELTA.get());
    }

    private static Font deriveDescriptionFont(Font font, boolean hasTitle) {
        return hasTitle ? font.deriveFont((float)font.getSize() + (float)DESCRIPTION_FONT_SIZE_DELTA.get()) : HelpTooltip.deriveHeaderFont(font);
    }

    @NotNull
    public static String getShortcutAsHtml(@Nullable String shortcut) {
        String string = StringUtil.isEmpty(shortcut) ? "" : String.format("&nbsp;&nbsp;<font color=\"%s\">%s</font>", ColorUtil.toHtmlColor(SHORTCUT_COLOR), shortcut);
        if (string == null) {
            HelpTooltip.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/HelpTooltip";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/HelpTooltip";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createTipPanel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortcutAsHtml";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "installOn";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "initPopupBuilder";
                break;
            }
            case 2: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "installMouseListeners";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "uninstallMouseListeners";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "dispose";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hide";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setMasterPopup";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setMasterPopupOpenCondition";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class Paragraph
    extends BoundWidthLabel {
        private Paragraph(String text2, boolean hasTitle) {
            this.setForeground(hasTitle ? INFO_COLOR : UIUtil.getToolTipForeground());
            this.setFont(HelpTooltip.deriveDescriptionFont(this.getFont(), hasTitle));
            View v = BasicHTML.createHTMLView(this, String.format("<html>%s</html>", text2));
            float width = v.getPreferredSpan(0);
            HelpTooltip.this.isMultiline = HelpTooltip.this.isMultiline || width > (float)MAX_WIDTH.get();
            this.setText(width > (float)MAX_WIDTH.get() ? String.format("<html><div width=%d>%s</div></html>", MAX_WIDTH.get(), text2) : String.format("<html>%s</html>", text2));
            this.setSizeForWidth(width);
        }
    }

    private class Header
    extends BoundWidthLabel {
        private Header(boolean obeyWidth) {
            this.setFont(HelpTooltip.deriveHeaderFont(this.getFont()));
            this.setForeground(UIUtil.getToolTipForeground());
            if (obeyWidth) {
                View v = BasicHTML.createHTMLView(this, String.format("<html>%s%s</html>", HelpTooltip.this.title, this.getShortcutAsHTML()));
                float width = v.getPreferredSpan(0);
                HelpTooltip.this.isMultiline = HelpTooltip.this.isMultiline || width > (float)MAX_WIDTH.get();
                this.setText(width > (float)MAX_WIDTH.get() ? String.format("<html><div width=%d>%s%s</div></html>", MAX_WIDTH.get(), HelpTooltip.this.title, this.getShortcutAsHTML()) : String.format("<html>%s%s</html>", HelpTooltip.this.title, this.getShortcutAsHTML()));
                this.setSizeForWidth(width);
            } else {
                this.setText(BasicHTML.isHTMLString(HelpTooltip.this.title) ? HelpTooltip.this.title : String.format("<html>%s%s</html>", HelpTooltip.this.title, this.getShortcutAsHTML()));
            }
        }

        private String getShortcutAsHTML() {
            return HelpTooltip.getShortcutAsHtml(HelpTooltip.this.shortcut);
        }
    }

    private static class BoundWidthLabel
    extends JLabel {
        private BoundWidthLabel() {
        }

        private static Collection<View> getRows(@NotNull View root) {
            if (root == null) {
                BoundWidthLabel.$$$reportNull$$$0(0);
            }
            ArrayList<View> rows = new ArrayList<View>();
            BoundWidthLabel.visit(root, rows);
            return rows;
        }

        private static void visit(@NotNull View v, Collection<? super View> result2) {
            String cname;
            if (v == null) {
                BoundWidthLabel.$$$reportNull$$$0(1);
            }
            if ((cname = v.getClass().getCanonicalName()) != null && cname.contains("ParagraphView.Row")) {
                result2.add(v);
            }
            for (int i = 0; i < v.getViewCount(); ++i) {
                BoundWidthLabel.visit(v.getView(i), result2);
            }
        }

        void setSizeForWidth(float width) {
            View v;
            if (width > (float)MAX_WIDTH.get() && (v = (View)this.getClientProperty("html")) != null) {
                width = 0.0f;
                for (View row : BoundWidthLabel.getRows(v)) {
                    float rWidth = row.getPreferredSpan(0);
                    if (!(width < rWidth)) continue;
                    width = rWidth;
                }
                v.setSize(width, v.getPreferredSpan(1));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/HelpTooltip$BoundWidthLabel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getRows";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visit";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum Alignment {
        RIGHT{

            @Override
            public Point getPointFor(Component owner, Dimension popupSize, Point mouseLocation) {
                Dimension size = owner.getSize();
                return new Point(size.width + JBUIScale.scale(5) - X_OFFSET.get(), JBUIScale.scale(1) + Y_OFFSET.get());
            }
        }
        ,
        BOTTOM{

            @Override
            public Point getPointFor(Component owner, Dimension popupSize, Point mouseLocation) {
                Dimension size = owner.getSize();
                return new Point(JBUIScale.scale(1) + X_OFFSET.get(), JBUIScale.scale(5) + size.height - Y_OFFSET.get());
            }
        }
        ,
        HELP_BUTTON{

            @Override
            public Point getPointFor(Component owner, Dimension popupSize, Point mouseLocation) {
                Insets i = ((JComponent)owner).getInsets();
                return new Point(X_OFFSET.get() - JBUIScale.scale(40), i.top + Y_OFFSET.get() - JBUIScale.scale(6) - popupSize.height);
            }
        }
        ,
        CURSOR{

            @Override
            public Point getPointFor(Component owner, Dimension popupSize, Point mouseLocation) {
                Point location2 = mouseLocation.getLocation();
                location2.y += CURSOR_OFFSET.get();
                SwingUtilities.convertPointToScreen(location2, owner);
                Rectangle r = new Rectangle(location2, popupSize);
                ScreenUtil.fitToScreen(r);
                location2 = r.getLocation();
                SwingUtilities.convertPointFromScreen(location2, owner);
                r.setLocation(location2);
                if (r.contains(mouseLocation)) {
                    location2.y = mouseLocation.y - r.height - JBUI.scale(5);
                }
                return location2;
            }
        };


        public abstract Point getPointFor(Component var1, Dimension var2, Point var3);
    }
}

