/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.MyIcon;
import com.intellij.ide.RecentProjectIconHelper;
import com.intellij.ide.RecentProjectIconHelperKt;
import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.IconDeferrer;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Function;
import com.intellij.util.ImageLoader;
import com.intellij.util.io.PathKt;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.net.MalformedURLException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.imgscalr.Scalr;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u000f\u001a\u0004\u0018\u00010\b2\u000b\u0010\u0010\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001d\u0010\u0014\u001a\u0004\u0018\u00010\b2\u000b\u0010\u0010\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0013\u0010\u0015\u001a\u00020\b2\u000b\u0010\u0010\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0011R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0007\u001a\u000f \n*\u0004\u0018\u00010\b0\b\u00a2\u0006\u0002\b\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ide/RecentProjectIconHelper;", "", "()V", "projectIcons", "Lgnu/trove/THashMap;", "", "Lcom/intellij/ide/MyIcon;", "smallAppIcon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "kotlin.jvm.PlatformType", "getSmallAppIcon", "()Ljavax/swing/Icon;", "smallAppIcon$delegate", "Lkotlin/Lazy;", "calculateIcon", "path", "Lorg/jetbrains/annotations/SystemIndependent;", "isDark", "", "getProjectIcon", "getProjectOrAppIcon", "Companion", "intellij.platform.ide.impl"})
public final class RecentProjectIconHelper {
    private final THashMap<String, MyIcon> projectIcons = new THashMap();
    private final Lazy smallAppIcon$delegate = LazyKt.lazy((Function0)smallAppIcon.2.INSTANCE);
    public static final Companion Companion = new Companion(null);

    private final Icon getSmallAppIcon() {
        Lazy lazy = this.smallAppIcon$delegate;
        RecentProjectIconHelper recentProjectIconHelper = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Icon)lazy.getValue();
    }

    @Nullable
    public final Icon getProjectIcon(@NotNull String path2, boolean isDark) {
        Intrinsics.checkParameterIsNotNull((Object)path2, (String)"path");
        MyIcon icon2 = this.projectIcons.get(path2);
        return icon2 != null ? icon2.getIcon() : IconDeferrer.getInstance().defer(EmptyIcon.ICON_16, Pair.create(path2, isDark), (Function)new Function<Pair<String, Boolean>, Icon>(this){
            final /* synthetic */ RecentProjectIconHelper this$0;

            @Nullable
            public final Icon fun(Pair<String, Boolean> it) {
                A a = it.first;
                Intrinsics.checkExpressionValueIsNotNull(a, (String)"it.first");
                String string = (String)a;
                B b = it.second;
                Intrinsics.checkExpressionValueIsNotNull(b, (String)"it.second");
                return RecentProjectIconHelper.access$calculateIcon(this.this$0, string, (Boolean)b);
            }
            {
                this.this$0 = recentProjectIconHelper;
            }
        });
    }

    @NotNull
    public final Icon getProjectOrAppIcon(@NotNull String path2) {
        Intrinsics.checkParameterIsNotNull((Object)path2, (String)"path");
        Icon icon2 = this.getProjectIcon(path2, UIUtil.isUnderDarcula());
        if (icon2 != null) {
            return icon2;
        }
        if (UIUtil.isUnderDarcula() && (icon2 = this.getProjectIcon(path2, false)) != null) {
            return icon2;
        }
        Icon icon3 = this.getSmallAppIcon();
        Intrinsics.checkExpressionValueIsNotNull((Object)icon3, (String)"smallAppIcon");
        return icon3;
    }

    private final Icon calculateIcon(String path2, boolean isDark) {
        Path file2;
        if (!RecentProjectsManagerBase.Companion.isFileSystemPath(path2)) {
            return null;
        }
        Path path3 = file2 = Paths.get(path2, ".idea", isDark ? "icon_dark.png" : "icon.png");
        Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"file");
        BasicFileAttributes basicFileAttributes = PathKt.basicAttributesIfExists((Path)path3);
        if (basicFileAttributes == null) {
            return null;
        }
        BasicFileAttributes fileInfo = basicFileAttributes;
        long timestamp = fileInfo.lastModifiedTime().toMillis();
        MyIcon icon2 = this.projectIcons.get(path2);
        if (icon2 != null) {
            Long l = icon2.getTimestamp();
            if (l != null && l == timestamp) {
                return icon2.getIcon();
            }
        }
        try {
            Icon icon3 = Companion.createIcon(file2);
            if (icon3 == null) {
                return null;
            }
            icon2 = new MyIcon(icon3, timestamp);
            this.projectIcons.put(path2, icon2);
            return icon2.getIcon();
        }
        catch (Exception e) {
            RecentProjectIconHelperKt.access$getLOG$p().error(e);
            return null;
        }
    }

    public static final /* synthetic */ Icon access$calculateIcon(RecentProjectIconHelper $this, String path2, boolean isDark) {
        return $this.calculateIcon(path2, isDark);
    }

    @JvmStatic
    @Nullable
    public static final Icon createIcon(@NotNull Path file2) {
        return Companion.createIcon(file2);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Lcom/intellij/ide/RecentProjectIconHelper$Companion;", "", "()V", "createIcon", "Ljavax/swing/Icon;", "file", "Ljava/nio/file/Path;", "toRetinaAwareIcon", "image", "Ljava/awt/image/BufferedImage;", "intellij.platform.ide.impl"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final Icon createIcon(@NotNull Path file2) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            try {
                Image image = ImageLoader.loadFromUrl(file2.toUri().toURL());
                if (image == null) {
                    return null;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"ImageLoader.loadFromUrl(\u2026).toURL()) ?: return null");
                Image image2 = image;
                int targetSize = UIUtil.isRetina() ? 32 : (int)JBUI.pixScale(16.0f);
                BufferedImage bufferedImage = Scalr.resize((BufferedImage)ImageUtil.toBufferedImage(image2), (Scalr.Method)Scalr.Method.ULTRA_QUALITY, (int)targetSize, (BufferedImageOp[])new BufferedImageOp[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)bufferedImage, (String)"Scalr.resize(ImageUtil.t\u2026LTRA_QUALITY, targetSize)");
                return this.toRetinaAwareIcon(bufferedImage);
            }
            catch (MalformedURLException e) {
                RecentProjectIconHelperKt.access$getLOG$p().debug(e);
                return null;
            }
        }

        private final Icon toRetinaAwareIcon(BufferedImage image) {
            return new Icon(image){
                final /* synthetic */ BufferedImage $image;

                public void paintIcon(@NotNull Component c, @NotNull Graphics g, int x, int y) {
                    Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
                    Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
                    if (UIUtil.isJreHiDPI()) {
                        Graphics graphics = g.create(x, y, this.$image.getWidth(), this.$image.getHeight());
                        if (graphics == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.awt.Graphics2D");
                        }
                        Graphics2D newG = (Graphics2D)graphics;
                        float s = JBUIScale.sysScale();
                        newG.scale(1.0f / s, 1.0f / s);
                        newG.drawImage((Image)this.$image, (int)((float)x / s), (int)((float)y / s), null);
                        newG.scale(1.0, 1.0);
                        newG.dispose();
                    } else {
                        g.drawImage(this.$image, x, y, null);
                    }
                }

                public int getIconWidth() {
                    return UIUtil.isJreHiDPI() ? (int)((float)this.$image.getWidth() / JBUIScale.sysScale()) : this.$image.getWidth();
                }

                public int getIconHeight() {
                    return UIUtil.isJreHiDPI() ? (int)((float)this.$image.getHeight() / JBUIScale.sysScale()) : this.$image.getHeight();
                }
                {
                    this.$image = $captured_local_variable$0;
                }
            };
        }

        private Companion() {
        }

        public static final /* synthetic */ Icon access$toRetinaAwareIcon(Companion $this, BufferedImage image) {
            return $this.toRetinaAwareIcon(image);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

