/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.diagnostic.VMOptions;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.EditCustomVmOptionsAction;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.jna.JnaLoader;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.notification.impl.NotificationFullContent;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.PreloadingActivity;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.JdkBundle;
import com.intellij.util.SystemProperties;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.lang.JavaVersion;
import com.sun.jna.Callback;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Pointer;
import java.io.File;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

final class SystemHealthMonitor
extends PreloadingActivity {
    private static final Logger LOG = Logger.getInstance(SystemHealthMonitor.class);
    private static final NotificationGroup GROUP = new NotificationGroup("System Health", NotificationDisplayType.STICKY_BALLOON, true, null, null, null, PluginManagerCore.CORE_ID);
    private static final String SWITCH_JDK_ACTION = "SwitchBootJdk";
    private static final JavaVersion MIN_RECOMMENDED_JDK = JavaVersion.compose(8, 0, 144, 0, false);

    SystemHealthMonitor() {
    }

    @Override
    public void preload(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            SystemHealthMonitor.$$$reportNull$$$0(0);
        }
        SystemHealthMonitor.checkPluginDirectory();
        SystemHealthMonitor.checkRuntime();
        SystemHealthMonitor.checkReservedCodeCacheSize();
        SystemHealthMonitor.checkSignalBlocking();
        SystemHealthMonitor.startDiskSpaceMonitoring();
    }

    private static void checkPluginDirectory() {
        if (System.getProperty("idea.paths.selector") != null) {
            if (System.getProperty("idea.config.path") != null && System.getProperty("idea.plugins.path") == null) {
                SystemHealthMonitor.showNotification("implicit.plugin.directory.path", null, new Object[0]);
            }
            if (System.getProperty("idea.system.path") != null && System.getProperty("idea.log.path") == null) {
                SystemHealthMonitor.showNotification("implicit.log.directory.path", null, new Object[0]);
            }
        }
    }

    private static void checkRuntime() {
        JdkBundle bootJdk;
        if (JavaVersion.current().ea) {
            SystemHealthMonitor.showNotification("unsupported.jvm.ea.message", null, new Object[0]);
        }
        if (!(bootJdk = JdkBundle.createBoot()).isBundled()) {
            boolean outdatedRuntime;
            boolean bl = outdatedRuntime = bootJdk.getBundleVersion().compareTo(MIN_RECOMMENDED_JDK) < 0;
            if (!SystemInfo.isJetBrainsJvm || outdatedRuntime) {
                JdkBundle bundledJdk;
                boolean validBundledJdk = (SystemInfo.isWindows || SystemInfo.isMac || SystemInfo.isLinux) && (bundledJdk = JdkBundle.createBundled()) != null && bundledJdk.isOperational();
                NotificationAction switchAction = new NotificationAction((Supplier)IdeBundle.messagePointer("action.Anonymous.text.switch", new Object[0])){

                    @Override
                    public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (notification == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        notification.expire();
                        ActionManager.getInstance().getAction(SystemHealthMonitor.SWITCH_JDK_ACTION).actionPerformed(e);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "e";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "notification";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/ide/SystemHealthMonitor$1";
                        objectArray[2] = "actionPerformed";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                String current2 = bootJdk.getBundleVersion().toString();
                if (!SystemInfo.isJetBrainsJvm) {
                    current2 = current2 + " by " + SystemInfo.JAVA_VENDOR;
                }
                if (outdatedRuntime && validBundledJdk) {
                    SystemHealthMonitor.showNotification("outdated.jre.version.message1", switchAction, current2, MIN_RECOMMENDED_JDK);
                } else if (outdatedRuntime) {
                    SystemHealthMonitor.showNotification("outdated.jre.version.message2", null, current2, MIN_RECOMMENDED_JDK);
                } else if (validBundledJdk) {
                    SystemHealthMonitor.showNotification("bundled.jre.version.message", switchAction, current2);
                }
            }
        }
    }

    private static void checkReservedCodeCacheSize() {
        int minReservedCodeCacheSize = 240;
        int reservedCodeCacheSize = VMOptions.readOption(VMOptions.MemoryKind.CODE_CACHE, true);
        if (reservedCodeCacheSize > 0 && reservedCodeCacheSize < minReservedCodeCacheSize) {
            final EditCustomVmOptionsAction vmEditAction = new EditCustomVmOptionsAction();
            NotificationAction action2 = new NotificationAction(IdeBundle.message("vmoptions.edit.action", new Object[0])){

                @Override
                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (notification == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    notification.expire();
                    ActionUtil.performActionDumbAware(vmEditAction, e);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/ide/SystemHealthMonitor$2";
                    objectArray[2] = "actionPerformed";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            SystemHealthMonitor.showNotification("vmoptions.warn.message", vmEditAction.isEnabled() ? action2 : null, reservedCodeCacheSize, minReservedCodeCacheSize);
        }
    }

    private static void checkSignalBlocking() {
        if (SystemInfo.isUnix & JnaLoader.isLoaded()) {
            try {
                Memory sa = new Memory(256L);
                if (LibC.sigaction(2, Pointer.NULL, (Pointer)sa) == 0 && LibC.SIG_IGN.equals((Object)sa.getPointer(0L))) {
                    LibC.signal(2, LibC.Handler.TERMINATE);
                    LOG.info("restored ignored INT handler");
                }
                if (LibC.sigaction(UnixProcessManager.SIGPIPE, Pointer.NULL, (Pointer)sa) == 0 && LibC.SIG_IGN.equals((Object)sa.getPointer(0L))) {
                    LibC.signal(UnixProcessManager.SIGPIPE, LibC.Handler.NO_OP);
                    LOG.info("restored ignored PIPE handler");
                }
            }
            catch (Throwable t) {
                LOG.warn(t);
            }
        }
    }

    private static void showNotification(final @PropertyKey(resourceBundle="messages.IdeBundle") String key, @Nullable NotificationAction action2, Object ... params) {
        boolean ignored = PropertiesComponent.getInstance().isValueSet("ignore." + key);
        LOG.info("issue detected: " + key + (ignored ? " (ignored)" : ""));
        if (ignored) {
            return;
        }
        MyNotification notification = new MyNotification(IdeBundle.message(key, params));
        if (action2 != null) {
            notification.addAction(action2);
        }
        notification.addAction(new NotificationAction(IdeBundle.message("sys.health.acknowledge.action", new Object[0])){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (notification == null) {
                    3.$$$reportNull$$$0(1);
                }
                notification.expire();
                PropertiesComponent.getInstance().setValue("ignore." + key, "true");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/SystemHealthMonitor$3";
                objectArray[2] = "actionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        notification.setImportant(true);
        ApplicationManager.getApplication().invokeLater(() -> Notifications.Bus.notify(notification));
    }

    private static void startDiskSpaceMonitoring() {
        if (SystemProperties.getBooleanProperty("idea.no.system.path.space.monitoring", false)) {
            return;
        }
        final File file2 = new File(PathManager.getSystemPath());
        final AtomicBoolean reported = new AtomicBoolean();
        final ThreadLocal ourFreeSpaceCalculation = new ThreadLocal();
        AppExecutorUtil.getAppScheduledExecutorService().schedule(new Runnable(){
            private static final long LOW_DISK_SPACE_THRESHOLD = 0x3200000L;
            private static final long MAX_WRITE_SPEED_IN_BPS = 524288000L;

            @Override
            public void run() {
                if (!reported.get()) {
                    Future<@Nullable Long> future2 = (Future<Long>)ourFreeSpaceCalculation.get();
                    if (future2 == null) {
                        future2 = ApplicationManager.getApplication().executeOnPooledThread(() -> {
                            long fileUsableSpace = file2.getUsableSpace();
                            while (fileUsableSpace == 0L) {
                                TimeoutUtil.sleep(5000L);
                                fileUsableSpace = file2.getUsableSpace();
                            }
                            return fileUsableSpace;
                        });
                        ourFreeSpaceCalculation.set(future2);
                    }
                    if (!future2.isDone() || future2.isCancelled()) {
                        this.restart(1L);
                        return;
                    }
                    try {
                        Long result2 = future2.get();
                        if (result2 == null) {
                            return;
                        }
                        ourFreeSpaceCalculation.set(null);
                        long usableSpace = result2;
                        long timeout = Math.min(3600L, Math.max(5L, (usableSpace - 0x3200000L) / 524288000L));
                        if (usableSpace < 0x3200000L) {
                            if (ReadAction.compute(() -> NotificationsConfiguration.getNotificationsConfiguration()) == null) {
                                ourFreeSpaceCalculation.set(future2);
                                this.restart(1L);
                                return;
                            }
                            reported.compareAndSet(false, true);
                            SwingUtilities.invokeLater(() -> {
                                String productName = ApplicationNamesInfo.getInstance().getFullProductName();
                                String message = IdeBundle.message("low.disk.space.message", productName);
                                if (usableSpace < 102400L) {
                                    LOG.warn(message + " (" + usableSpace + ")");
                                    Messages.showErrorDialog(message, IdeBundle.message("dialog.title.fatal.configuration.problem", new Object[0]));
                                    reported.compareAndSet(true, false);
                                    this.restart(timeout);
                                } else {
                                    GROUP.createNotification(message, file2.getPath(), NotificationType.ERROR, null).whenExpired(() -> {
                                        reported.compareAndSet(true, false);
                                        this.restart(timeout);
                                    }).notify(null);
                                }
                            });
                        } else {
                            this.restart(timeout);
                        }
                    }
                    catch (Exception ex) {
                        LOG.error(ex);
                    }
                }
            }

            private void restart(long timeout) {
                AppExecutorUtil.getAppScheduledExecutorService().schedule(this, timeout, TimeUnit.SECONDS);
            }
        }, 1L, TimeUnit.SECONDS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/SystemHealthMonitor", "preload"));
    }

    private static class LibC {
        static final Pointer SIG_IGN;

        private LibC() {
        }

        static native int sigaction(int var0, Pointer var1, Pointer var2);

        static native Pointer signal(int var0, Handler var1);

        static {
            Native.register(LibC.class, (NativeLibrary)NativeLibrary.getInstance((String)"c"));
            SIG_IGN = new Pointer(1L);
        }

        static interface Handler
        extends Callback {
            public static final Handler TERMINATE = sig -> System.exit(128 + sig);
            public static final Handler NO_OP = sig -> {};

            public void callback(int var1);
        }
    }

    private static final class MyNotification
    extends Notification
    implements NotificationFullContent {
        MyNotification(@NotNull String content2) {
            if (content2 == null) {
                MyNotification.$$$reportNull$$$0(0);
            }
            super(GROUP.getDisplayId(), "", content2, NotificationType.WARNING);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ide/SystemHealthMonitor$MyNotification", "<init>"));
        }
    }
}

