/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actionMacro;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actionMacro.ActionMacro;
import com.intellij.ide.actionMacro.ActionMacroManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Couple;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ActionMacroConfigurationPanel
implements Disposable {
    private static final String SPLITTER_PROPORTION = "ActionMacroConfigurationPanel.SPLITTER_PROPORTION";
    private Splitter mySplitter;
    private final JList myMacrosList;
    private final JList myMacroActionsList;
    final DefaultListModel myMacrosModel = new DefaultListModel();
    private List<Couple<String>> myRenamingList;

    public ActionMacroConfigurationPanel() {
        this.myMacrosList = new JBList();
        this.myMacroActionsList = new JBList();
        this.myMacrosList.setSelectionMode(0);
        this.myMacroActionsList.setSelectionMode(0);
        this.myMacrosList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selIndex = ActionMacroConfigurationPanel.this.myMacrosList.getSelectedIndex();
                if (selIndex == -1) {
                    ((DefaultListModel)ActionMacroConfigurationPanel.this.myMacroActionsList.getModel()).removeAllElements();
                } else {
                    ActionMacroConfigurationPanel.this.initActionList((ActionMacro)ActionMacroConfigurationPanel.this.myMacrosModel.getElementAt(selIndex));
                }
            }
        });
    }

    public void reset() {
        ActionMacro[] allMacros;
        for (ActionMacro macro : allMacros = ActionMacroManager.getInstance().getAllMacros()) {
            this.myMacrosModel.addElement(macro.clone());
        }
        this.myMacrosList.setModel(this.myMacrosModel);
        ScrollingUtil.ensureSelectionExists(this.myMacrosList);
    }

    public void apply() {
        if (this.myRenamingList != null) {
            for (Couple<String> pair : this.myRenamingList) {
                Keymap[] allKeymaps = KeymapManagerEx.getInstanceEx().getAllKeymaps();
                for (Keymap keymap2 : allKeymaps) {
                    keymap2.removeAllActionShortcuts("Macro." + (String)pair.getSecond());
                    for (Shortcut shortcut : keymap2.getShortcuts("Macro." + (String)pair.getFirst())) {
                        keymap2.addShortcut("Macro." + (String)pair.getSecond(), shortcut);
                    }
                    keymap2.removeAllActionShortcuts("Macro." + (String)pair.getFirst());
                }
            }
        }
        ActionMacroManager manager = ActionMacroManager.getInstance();
        ActionMacro[] macros = manager.getAllMacros();
        HashSet<String> removedIds = new HashSet<String>();
        for (ActionMacro macro1 : macros) {
            removedIds.add(macro1.getActionId());
        }
        manager.removeAllMacros();
        Enumeration newMacros = this.myMacrosModel.elements();
        while (newMacros.hasMoreElements()) {
            ActionMacro macro = (ActionMacro)newMacros.nextElement();
            manager.addMacro(macro);
            removedIds.remove(macro.getActionId());
        }
        manager.registerActions(ActionManager.getInstance());
        for (String id2 : removedIds) {
            Keymap[] allKeymaps = KeymapManagerEx.getInstanceEx().getAllKeymaps();
            for (Keymap keymap3 : allKeymaps) {
                keymap3.removeAllActionShortcuts(id2);
            }
        }
    }

    public boolean isModified() {
        ActionMacro[] allMacros = ActionMacroManager.getInstance().getAllMacros();
        if (allMacros.length != this.myMacrosModel.getSize()) {
            return true;
        }
        for (int i = 0; i < allMacros.length; ++i) {
            ActionMacro macro = allMacros[i];
            ActionMacro newMacro = (ActionMacro)this.myMacrosModel.get(i);
            if (macro.equals(newMacro)) continue;
            return true;
        }
        return false;
    }

    private void initActionList(ActionMacro macro) {
        ActionMacro.ActionDescriptor[] actions;
        DefaultListModel<ActionMacro.ActionDescriptor> actionModel = new DefaultListModel<ActionMacro.ActionDescriptor>();
        for (ActionMacro.ActionDescriptor action2 : actions = macro.getActions()) {
            actionModel.addElement(action2);
        }
        this.myMacroActionsList.setModel(actionModel);
        ScrollingUtil.ensureSelectionExists(this.myMacroActionsList);
    }

    public JPanel getPanel() {
        if (this.mySplitter == null) {
            this.mySplitter = new Splitter(false, 0.5f);
            String value2 = PropertiesComponent.getInstance().getValue(SPLITTER_PROPORTION);
            if (value2 != null) {
                this.mySplitter.setProportion(Float.parseFloat(value2));
            }
            this.mySplitter.setFirstComponent(ToolbarDecorator.createDecorator(this.myMacrosList).setEditAction(new AnActionButtonRunnable(){

                @Override
                public void run(AnActionButton button2) {
                    String newName;
                    int selIndex = ActionMacroConfigurationPanel.this.myMacrosList.getSelectedIndex();
                    if (selIndex == -1) {
                        return;
                    }
                    ActionMacro macro = (ActionMacro)ActionMacroConfigurationPanel.this.myMacrosModel.getElementAt(selIndex);
                    do {
                        if ((newName = Messages.showInputDialog(ActionMacroConfigurationPanel.this.mySplitter, IdeBundle.message("prompt.enter.new.name", new Object[0]), IdeBundle.message("title.rename.macro", new Object[0]), Messages.getQuestionIcon(), macro.getName(), null)) != null && !macro.getName().equals(newName)) continue;
                        return;
                    } while (!this.canRenameMacro(newName));
                    if (ActionMacroConfigurationPanel.this.myRenamingList == null) {
                        ActionMacroConfigurationPanel.this.myRenamingList = new ArrayList();
                    }
                    ActionMacroConfigurationPanel.this.myRenamingList.add(Couple.of(macro.getName(), newName));
                    macro.setName(newName);
                    ActionMacroConfigurationPanel.this.myMacrosList.repaint();
                }

                private boolean canRenameMacro(String name) {
                    Enumeration elements2 = ActionMacroConfigurationPanel.this.myMacrosModel.elements();
                    while (elements2.hasMoreElements()) {
                        ActionMacro macro = (ActionMacro)elements2.nextElement();
                        if (!macro.getName().equals(name)) continue;
                        if (Messages.showYesNoDialog(IdeBundle.message("message.macro.exists", name), IdeBundle.message("title.macro.name.already.used", new Object[0]), Messages.getWarningIcon()) != 0) {
                            return false;
                        }
                        ActionMacroConfigurationPanel.this.myMacrosModel.removeElement(macro);
                        break;
                    }
                    return true;
                }
            }).disableAddAction().disableUpDownActions().createPanel());
            this.mySplitter.setSecondComponent(ToolbarDecorator.createDecorator(this.myMacroActionsList).setRemoveAction(new AnActionButtonRunnable(){

                @Override
                public void run(AnActionButton button2) {
                    int macrosSelectedIndex = ActionMacroConfigurationPanel.this.myMacrosList.getSelectedIndex();
                    if (macrosSelectedIndex != -1) {
                        ActionMacro macro = (ActionMacro)ActionMacroConfigurationPanel.this.myMacrosModel.getElementAt(macrosSelectedIndex);
                        macro.deleteAction(ActionMacroConfigurationPanel.this.myMacroActionsList.getSelectedIndex());
                    }
                    ListUtil.removeSelectedItems(ActionMacroConfigurationPanel.this.myMacroActionsList);
                }
            }).disableAddAction().disableUpDownActions().createPanel());
        }
        return this.mySplitter;
    }

    @Override
    public void dispose() {
        PropertiesComponent.getInstance().setValue(SPLITTER_PROPORTION, Float.toString(this.mySplitter.getProportion()));
    }
}

