/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.Animator;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.RootPaneContainer;

class ChangeLAFAnimator {
    private float myAlpha = 1.0f;
    private final Map<JLayeredPane, JComponent> myMap;
    private final Animator myAnimator = new Animator("ChangeLAF", 60, 800, false){

        @Override
        public void resume() {
            ChangeLAFAnimator.this.doPaint();
            super.resume();
        }

        @Override
        public void paintNow(int frame, int totalFrames, int cycle) {
            ChangeLAFAnimator.this.myAlpha = 1.0f - (float)(1.0 - Math.cos(Math.PI * (double)frame / (double)totalFrames)) / 2.0f;
            ChangeLAFAnimator.this.doPaint();
        }

        @Override
        protected void paintCycleEnd() {
            if (!this.isDisposed()) {
                Disposer.dispose(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose() {
            try {
                super.dispose();
                for (Map.Entry entry : ChangeLAFAnimator.this.myMap.entrySet()) {
                    JLayeredPane layeredPane = (JLayeredPane)entry.getKey();
                    layeredPane.remove((Component)entry.getValue());
                    layeredPane.revalidate();
                    layeredPane.repaint();
                }
            }
            finally {
                ChangeLAFAnimator.this.myMap.clear();
            }
        }
    };

    static ChangeLAFAnimator showSnapshot() {
        return new ChangeLAFAnimator();
    }

    private ChangeLAFAnimator() {
        Window[] windows = Window.getWindows();
        this.myMap = new LinkedHashMap<JLayeredPane, JComponent>();
        for (Window window : windows) {
            if (!(window instanceof RootPaneContainer) || !window.isShowing()) continue;
            Rectangle bounds2 = window.getBounds();
            RootPaneContainer rootPaneContainer = (RootPaneContainer)((Object)window);
            final JLayeredPane layeredPane = rootPaneContainer.getLayeredPane();
            final BufferedImage image = ImageUtil.createImage(window.getGraphicsConfiguration(), bounds2.width, bounds2.height, 2);
            Graphics imageGraphics = image.getGraphics();
            GraphicsUtil.setupAntialiasing(imageGraphics);
            ((RootPaneContainer)((Object)window)).getRootPane().paint(imageGraphics);
            JComponent imageLayer = new JComponent(){

                @Override
                public void updateUI() {
                }

                @Override
                public void paint(Graphics g) {
                    g = g.create();
                    ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, ChangeLAFAnimator.this.myAlpha));
                    UIUtil.drawImage(g, (Image)image, 0, 0, (ImageObserver)this);
                }

                @Override
                public Rectangle getBounds() {
                    return layeredPane.getBounds();
                }
            };
            imageLayer.setSize(layeredPane.getSize());
            layeredPane.add((Component)imageLayer, JLayeredPane.DRAG_LAYER);
            this.myMap.put(layeredPane, imageLayer);
        }
        this.doPaint();
    }

    void hideSnapshotWithAnimation() {
        this.myAnimator.resume();
    }

    private void doPaint() {
        for (Map.Entry<JLayeredPane, JComponent> entry : this.myMap.entrySet()) {
            if (!entry.getKey().isShowing()) continue;
            entry.getValue().revalidate();
            entry.getValue().repaint();
        }
    }
}

