/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class CloseAllEditorsAction
extends AnAction
implements DumbAware {
    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            CloseAllEditorsAction.$$$reportNull$$$0(0);
        }
        Project project2 = e.getData(CommonDataKeys.PROJECT);
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.executeCommand(project2, () -> {
            VirtualFile[] openFiles;
            EditorWindow window = e.getData(EditorWindow.DATA_KEY);
            if (window != null) {
                VirtualFile[] files2;
                for (VirtualFile file2 : files2 = window.getFiles()) {
                    window.closeFile(file2);
                }
                return;
            }
            FileEditorManagerEx fileEditorManager = FileEditorManagerEx.getInstanceEx(project2);
            VirtualFile selectedFile = fileEditorManager.getSelectedFiles()[0];
            for (VirtualFile openFile2 : openFiles = fileEditorManager.getSiblings(selectedFile)) {
                fileEditorManager.closeFile(openFile2);
            }
        }, IdeBundle.message("command.close.all.editors", new Object[0]), null);
    }

    @Override
    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            CloseAllEditorsAction.$$$reportNull$$$0(1);
        }
        Presentation presentation = event.getPresentation();
        EditorWindow editorWindow = event.getData(EditorWindow.DATA_KEY);
        if (editorWindow != null && editorWindow.inSplitter()) {
            presentation.setText(IdeBundle.messagePointer("action.close.all.editors.in.tab.group", new Object[0]));
        } else {
            presentation.setText(IdeBundle.messagePointer("action.close.all.editors", new Object[0]));
        }
        Project project2 = event.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            presentation.setEnabled(false);
            return;
        }
        presentation.setEnabled(FileEditorManager.getInstance(project2).getSelectedFiles().length > 0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/CloseAllEditorsAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

