/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class CloseAllEditorsButActiveAction
extends AnAction
implements DumbAware {
    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile[] siblings;
        if (e == null) {
            CloseAllEditorsButActiveAction.$$$reportNull$$$0(0);
        }
        Project project2 = e.getData(CommonDataKeys.PROJECT);
        FileEditorManagerEx fileEditorManager = FileEditorManagerEx.getInstanceEx(project2);
        EditorWindow window = e.getData(EditorWindow.DATA_KEY);
        if (window != null) {
            window.closeAllExcept(e.getData(CommonDataKeys.VIRTUAL_FILE));
            return;
        }
        VirtualFile selectedFile = fileEditorManager.getSelectedFiles()[0];
        for (VirtualFile sibling : siblings = fileEditorManager.getSiblings(selectedFile)) {
            if (Comparing.equal(selectedFile, sibling)) continue;
            fileEditorManager.closeFile(sibling);
        }
    }

    @Override
    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            CloseAllEditorsButActiveAction.$$$reportNull$$$0(1);
        }
        Presentation presentation = event.getPresentation();
        Project project2 = event.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            presentation.setEnabled(false);
            return;
        }
        FileEditorManagerEx fileEditorManager = FileEditorManagerEx.getInstanceEx(project2);
        EditorWindow window = event.getData(EditorWindow.DATA_KEY);
        if (window != null) {
            presentation.setEnabled(window.getFiles().length > 1);
            return;
        }
        if (fileEditorManager.getSelectedFiles().length == 0) {
            presentation.setEnabled(false);
            return;
        }
        VirtualFile selectedFile = fileEditorManager.getSelectedFiles()[0];
        VirtualFile[] siblings = fileEditorManager.getSiblings(selectedFile);
        presentation.setEnabled(siblings.length > 1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/CloseAllEditorsButActiveAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

