/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.CloseEditorsActionBase;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.HashSet;

public class CloseAllUnpinnedEditorsAction
extends CloseEditorsActionBase {
    @Override
    protected boolean isFileToClose(EditorComposite editor, EditorWindow window) {
        return !window.isFilePinned(editor.getFile());
    }

    @Override
    protected String getPresentationText(boolean inSplitter) {
        if (inSplitter) {
            return IdeBundle.message("action.close.all.unpinned.editors.in.tab.group", new Object[0]);
        }
        return IdeBundle.message("action.close.all.unpinned.editors", new Object[0]);
    }

    @Override
    protected boolean isActionEnabled(Project project2, AnActionEvent event) {
        ArrayList<Pair<EditorComposite, EditorWindow>> filesToClose = this.getFilesToClose(event);
        if (filesToClose.isEmpty()) {
            return false;
        }
        HashSet<EditorWindow> checked = new HashSet<EditorWindow>();
        boolean hasPinned = false;
        boolean hasUnpinned = false;
        for (Pair<EditorComposite, EditorWindow> pair : filesToClose) {
            EditorWindow window = (EditorWindow)pair.second;
            if (!checked.add(window)) continue;
            for (EditorWithProviderComposite e : window.getEditors()) {
                if (e.isPinned()) {
                    hasPinned = true;
                    continue;
                }
                hasUnpinned = true;
            }
            if (!hasPinned && event.isFromContextMenu() || !hasUnpinned) continue;
            return true;
        }
        return false;
    }
}

