/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.copy.CopyHandler;
import org.jetbrains.annotations.NotNull;

public class CopyElementAction
extends AnAction {
    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        PsiElement[] elements2;
        PsiDirectory defaultTargetDirectory;
        DataContext dataContext;
        Project project2;
        if (e == null) {
            CopyElementAction.$$$reportNull$$$0(0);
        }
        if ((project2 = CommonDataKeys.PROJECT.getData(dataContext = e.getDataContext())) == null) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(project2, () -> PsiDocumentManager.getInstance(project2).commitAllDocuments(), "", null);
        Editor editor = CommonDataKeys.EDITOR.getData(dataContext);
        PsiElement targetPsiElement = LangDataKeys.TARGET_PSI_ELEMENT.getData(dataContext);
        PsiDirectory psiDirectory = defaultTargetDirectory = targetPsiElement instanceof PsiDirectory ? (PsiDirectory)targetPsiElement : null;
        if (editor != null) {
            PsiElement aElement = CopyElementAction.getTargetElement(editor, project2);
            PsiFile file2 = PsiDocumentManager.getInstance(project2).getPsiFile(editor.getDocument());
            if (file2 == null) {
                return;
            }
            elements2 = new PsiElement[]{aElement};
            if (aElement == null || !CopyHandler.canCopy(elements2)) {
                elements2 = new PsiElement[]{file2};
            }
        } else {
            elements2 = LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext);
        }
        this.doCopy(elements2, defaultTargetDirectory);
    }

    protected void doCopy(PsiElement[] elements2, PsiDirectory defaultTargetDirectory) {
        CopyHandler.doCopy(elements2, defaultTargetDirectory);
    }

    @Override
    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            CopyElementAction.$$$reportNull$$$0(1);
        }
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        Project project2 = CommonDataKeys.PROJECT.getData(dataContext);
        presentation.setEnabled(false);
        if (project2 == null) {
            return;
        }
        Editor editor = CommonDataKeys.EDITOR.getData(dataContext);
        if (editor != null) {
            this.updateForEditor(dataContext, presentation);
        } else {
            this.updateForToolWindow(dataContext, presentation);
        }
    }

    protected void updateForEditor(DataContext dataContext, Presentation presentation) {
        boolean result2;
        Editor editor = CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            presentation.setVisible(false);
            return;
        }
        Project project2 = CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 == null) {
            return;
        }
        PsiFile file2 = PsiDocumentManager.getInstance(project2).getPsiFile(editor.getDocument());
        PsiElement element2 = CopyElementAction.getTargetElement(editor, project2);
        Ref<String> actionName = new Ref<String>();
        boolean bl = result2 = element2 != null && CopyHandler.canCopy(new PsiElement[]{element2}, actionName);
        if (!result2 && file2 != null) {
            result2 = CopyHandler.canCopy(new PsiElement[]{file2}, actionName);
        }
        presentation.setEnabled(result2);
        presentation.setVisible(true);
        if (!actionName.isNull()) {
            presentation.setText(actionName.get());
        }
    }

    protected void updateForToolWindow(DataContext dataContext, Presentation presentation) {
        PsiElement[] elements2 = LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext);
        Ref<String> actionName = new Ref<String>();
        presentation.setEnabled(elements2 != null && CopyHandler.canCopy(elements2, actionName));
        if (!actionName.isNull()) {
            presentation.setText(actionName.get());
        }
    }

    private static PsiElement getTargetElement(Editor editor, Project project2) {
        int offset = editor.getCaretModel().getOffset();
        PsiFile file2 = PsiDocumentManager.getInstance(project2).getPsiFile(editor.getDocument());
        if (file2 == null) {
            return null;
        }
        PsiElement element2 = file2.findElementAt(offset);
        if (element2 == null) {
            element2 = file2;
        }
        return element2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/CopyElementAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

