/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.CopyReferenceFQNTransferable;
import com.intellij.ide.actions.CopyReferenceUtil;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyReferenceAction
extends DumbAwareAction {
    public static final DataFlavor ourFlavor = FileCopyPasteUtil.createJvmDataFlavor(CopyReferenceFQNTransferable.class);

    public CopyReferenceAction() {
        this.setEnabledInModalContext(true);
        this.setInjectedContext(true);
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        boolean enabled;
        if (e == null) {
            CopyReferenceAction.$$$reportNull$$$0(0);
        }
        boolean plural = false;
        boolean paths = false;
        DataContext dataContext = e.getDataContext();
        Editor editor = CommonDataKeys.EDITOR.getData(dataContext);
        if (editor != null && FileDocumentManager.getInstance().getFile(editor.getDocument()) != null) {
            enabled = true;
        } else {
            List<PsiElement> elements2 = this.getPsiElements(dataContext, editor);
            enabled = !elements2.isEmpty();
            plural = elements2.size() > 1;
            paths = elements2.stream().allMatch(el -> el instanceof PsiFileSystemItem && CopyReferenceUtil.getQualifiedNameFromProviders(el) == null);
        }
        e.getPresentation().setEnabled(enabled);
        if (ActionPlaces.isPopupPlace(e.getPlace())) {
            e.getPresentation().setVisible(enabled);
        } else {
            e.getPresentation().setVisible(true);
        }
        e.getPresentation().setText(paths ? (plural ? IdeBundle.message("copy.relative.paths", new Object[0]) : IdeBundle.message("copy.relative.path", new Object[0])) : (plural ? IdeBundle.message("copy.references", new Object[0]) : IdeBundle.message("copy.reference", new Object[0])));
        if (paths) {
            e.getPresentation().setEnabledAndVisible(false);
        }
    }

    @NotNull
    protected List<PsiElement> getPsiElements(DataContext dataContext, Editor editor) {
        List<PsiElement> list2 = CopyReferenceUtil.getElementsToCopy(editor, dataContext);
        if (list2 == null) {
            CopyReferenceAction.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            CopyReferenceAction.$$$reportNull$$$0(2);
        }
        DataContext dataContext = e.getDataContext();
        Editor editor = CommonDataKeys.EDITOR.getData(dataContext);
        Project project2 = CommonDataKeys.PROJECT.getData(dataContext);
        List<PsiElement> elements2 = this.getPsiElements(dataContext, editor);
        String copy2 = this.getQualifiedName(editor, elements2);
        if (copy2 != null) {
            CopyPasteManager.getInstance().setContents(new CopyReferenceFQNTransferable(copy2));
            CopyReferenceUtil.setStatusBarText(project2, IdeBundle.message("message.reference.to.fqn.has.been.copied", copy2));
        } else if (editor != null && project2 != null) {
            Document document = editor.getDocument();
            PsiFile file2 = PsiDocumentManager.getInstance(project2).getCachedPsiFile(document);
            if (file2 != null) {
                String toCopy = CopyReferenceUtil.getFileFqn(file2) + ":" + (editor.getCaretModel().getLogicalPosition().line + 1);
                CopyPasteManager.getInstance().setContents(new StringSelection(toCopy));
                CopyReferenceUtil.setStatusBarText(project2, toCopy + " has been copied");
            }
            return;
        }
        CopyReferenceUtil.highlight(editor, project2, elements2);
    }

    protected String getQualifiedName(Editor editor, List<PsiElement> elements2) {
        return CopyReferenceUtil.doCopy(elements2, editor);
    }

    public static boolean doCopy(PsiElement element2, Project project2) {
        return CopyReferenceAction.doCopy(Collections.singletonList(element2), project2);
    }

    private static boolean doCopy(List<? extends PsiElement> elements2, @Nullable Project project2) {
        String toCopy = CopyReferenceUtil.doCopy(elements2, null);
        CopyPasteManager.getInstance().setContents(new CopyReferenceFQNTransferable(toCopy));
        CopyReferenceUtil.setStatusBarText(project2, IdeBundle.message("message.reference.to.fqn.has.been.copied", toCopy));
        return true;
    }

    @Nullable
    public static String elementToFqn(@Nullable PsiElement element2) {
        return CopyReferenceUtil.elementToFqn(element2, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/CopyReferenceAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/CopyReferenceAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface VirtualFileQualifiedNameProvider {
        public static final ExtensionPointName<VirtualFileQualifiedNameProvider> EP_NAME = ExtensionPointName.create("com.intellij.virtualFileQualifiedNameProvider");

        @Nullable
        public String getQualifiedName(@NotNull Project var1, @NotNull VirtualFile var2);
    }
}

