/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.daemon.impl.IdentifierUtil;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.ide.actions.CopyReferenceAction;
import com.intellij.ide.actions.QualifiedNameProviderUtil;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyReferenceUtil {
    static void highlight(Editor editor, Project project2, List<? extends PsiElement> elements2) {
        HighlightManager highlightManager = HighlightManager.getInstance(project2);
        EditorColorsManager manager = EditorColorsManager.getInstance();
        TextAttributes attributes = manager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        if (elements2.size() == 1 && editor != null && project2 != null) {
            PsiElement element2 = elements2.get(0);
            PsiElement nameIdentifier = IdentifierUtil.getNameIdentifier(element2);
            if (nameIdentifier != null) {
                highlightManager.addOccurrenceHighlights(editor, new PsiElement[]{nameIdentifier}, attributes, true, null);
            } else {
                PsiReference reference2 = TargetElementUtil.findReference(editor, editor.getCaretModel().getOffset());
                if (reference2 != null) {
                    highlightManager.addOccurrenceHighlights(editor, new PsiReference[]{reference2}, attributes, true, null);
                } else if (element2 != PsiDocumentManager.getInstance(project2).getCachedPsiFile(editor.getDocument())) {
                    highlightManager.addOccurrenceHighlights(editor, new PsiElement[]{element2}, attributes, true, null);
                }
            }
        }
    }

    @NotNull
    static List<PsiElement> getElementsToCopy(@Nullable Editor editor, DataContext dataContext) {
        PsiElement[] psiElements;
        PsiReference reference2;
        ArrayList elements2 = new ArrayList();
        if (editor != null && (reference2 = TargetElementUtil.findReference(editor)) != null) {
            ContainerUtil.addIfNotNull(elements2, reference2.getElement());
        }
        if (elements2.isEmpty() && (psiElements = LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext)) != null) {
            Collections.addAll(elements2, psiElements);
        }
        if (elements2.isEmpty()) {
            ContainerUtil.addIfNotNull(elements2, CommonDataKeys.PSI_ELEMENT.getData(dataContext));
        }
        if (elements2.isEmpty() && editor == null) {
            Project project2 = CommonDataKeys.PROJECT.getData(dataContext);
            VirtualFile[] files2 = CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
            if (project2 != null && files2 != null) {
                for (VirtualFile file2 : files2) {
                    ContainerUtil.addIfNotNull(elements2, PsiManager.getInstance(project2).findFile(file2));
                }
            }
        }
        List<PsiElement> list2 = ContainerUtil.mapNotNull(elements2, element2 -> element2 instanceof PsiFile && !((PsiFile)element2).getViewProvider().isPhysical() ? null : CopyReferenceUtil.adjustElement(element2));
        if (list2 == null) {
            CopyReferenceUtil.$$$reportNull$$$0(0);
        }
        return list2;
    }

    static PsiElement adjustElement(PsiElement element2) {
        PsiElement adjustedElement = QualifiedNameProviderUtil.adjustElementToCopy(element2);
        return adjustedElement != null ? adjustedElement : element2;
    }

    static void setStatusBarText(Project project2, String message) {
        StatusBarEx statusBar;
        if (project2 != null && (statusBar = (StatusBarEx)WindowManager.getInstance().getStatusBar(project2)) != null) {
            statusBar.setInfo(message);
        }
    }

    @Nullable
    static String getQualifiedNameFromProviders(@Nullable PsiElement element2) {
        if (element2 == null) {
            return null;
        }
        return DumbService.getInstance(element2.getProject()).computeWithAlternativeResolveEnabled(() -> QualifiedNameProviderUtil.getQualifiedName(element2));
    }

    static String doCopy(List<? extends PsiElement> elements2, @Nullable Editor editor) {
        if (elements2.isEmpty()) {
            return null;
        }
        ArrayList<String> fqns = new ArrayList<String>();
        for (PsiElement psiElement : elements2) {
            String fqn = CopyReferenceUtil.elementToFqn(psiElement, editor);
            if (fqn == null) {
                return null;
            }
            fqns.add(fqn);
        }
        return StringUtil.join(fqns, "\n");
    }

    @Nullable
    static String elementToFqn(@Nullable PsiElement element2, @Nullable Editor editor) {
        PsiReference reference2;
        String result2 = CopyReferenceUtil.getQualifiedNameFromProviders(element2);
        if (result2 != null) {
            return result2;
        }
        if (editor != null && (reference2 = TargetElementUtil.findReference(editor, editor.getCaretModel().getOffset())) != null && (result2 = CopyReferenceUtil.getQualifiedNameFromProviders(reference2.resolve())) != null) {
            return result2;
        }
        if (element2 instanceof PsiFile) {
            return FileUtil.toSystemIndependentName(CopyReferenceUtil.getFileFqn((PsiFile)element2));
        }
        if (element2 instanceof PsiDirectory) {
            return FileUtil.toSystemIndependentName(CopyReferenceUtil.getVirtualFileFqn(((PsiDirectory)element2).getVirtualFile(), element2.getProject()));
        }
        return null;
    }

    @NotNull
    static String getFileFqn(PsiFile file2) {
        VirtualFile virtualFile2 = file2.getVirtualFile();
        return virtualFile2 == null ? file2.getName() : CopyReferenceUtil.getVirtualFileFqn(virtualFile2, file2.getProject());
    }

    @NotNull
    public static String getVirtualFileFqn(@NotNull VirtualFile virtualFile2, @NotNull Project project2) {
        String scratchRelativePath;
        VirtualFile scratchRootVirtualFile;
        VirtualFile virtualFile3;
        if (virtualFile2 == null) {
            CopyReferenceUtil.$$$reportNull$$$0(1);
        }
        if (project2 == null) {
            CopyReferenceUtil.$$$reportNull$$$0(2);
        }
        for (CopyReferenceAction.VirtualFileQualifiedNameProvider virtualFileQualifiedNameProvider : CopyReferenceAction.VirtualFileQualifiedNameProvider.EP_NAME.getExtensionList()) {
            String qualifiedName = virtualFileQualifiedNameProvider.getQualifiedName(project2, virtualFile2);
            if (qualifiedName == null) continue;
            String string = qualifiedName;
            if (string == null) {
                CopyReferenceUtil.$$$reportNull$$$0(3);
            }
            return string;
        }
        Module module2 = ProjectFileIndex.getInstance(project2).getModuleForFile(virtualFile2, false);
        if (module2 != null) {
            for (VirtualFile root : ModuleRootManager.getInstance(module2).getContentRoots()) {
                String relativePath = VfsUtilCore.getRelativePath(virtualFile2, root);
                if (relativePath == null) continue;
                String string = relativePath;
                if (string == null) {
                    CopyReferenceUtil.$$$reportNull$$$0(4);
                }
                return string;
            }
        }
        if ((virtualFile3 = project2.getBaseDir()) == null) {
            String string = virtualFile2.getPath();
            if (string == null) {
                CopyReferenceUtil.$$$reportNull$$$0(5);
            }
            return string;
        }
        String relativePath = VfsUtilCore.getRelativePath(virtualFile2, virtualFile3);
        if (relativePath != null) {
            String string = relativePath;
            if (string == null) {
                CopyReferenceUtil.$$$reportNull$$$0(6);
            }
            return string;
        }
        RootType rootType = RootType.forFile(virtualFile2);
        if (rootType != null && (scratchRootVirtualFile = VfsUtil.findFileByIoFile(new File(ScratchFileService.getInstance().getRootPath(rootType)), false)) != null && (scratchRelativePath = VfsUtilCore.getRelativePath(virtualFile2, scratchRootVirtualFile)) != null) {
            String string = scratchRelativePath;
            if (string == null) {
                CopyReferenceUtil.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = virtualFile2.getPath();
        if (string == null) {
            CopyReferenceUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/CopyReferenceUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsToCopy";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/CopyReferenceUtil";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFileFqn";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFileFqn";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

