/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateInDirectoryActionBase;
import com.intellij.ide.actions.ElementCreator;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.WriteActionAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CreateElementActionBase
extends CreateInDirectoryActionBase
implements WriteActionAware {
    protected CreateElementActionBase() {
    }

    protected CreateElementActionBase(@Nls(capitalization=Nls.Capitalization.Title) String text2, @Nls(capitalization=Nls.Capitalization.Sentence) String description, Icon icon2) {
        super(text2, description, icon2);
    }

    protected CreateElementActionBase(Supplier<String> dynamicText, Supplier<String> dynamicDescription, Icon icon2) {
        super(dynamicText, dynamicDescription, icon2);
    }

    @Deprecated
    protected PsiElement @NotNull [] invokeDialog(Project project2, PsiDirectory directory) {
        if (PsiElement.EMPTY_ARRAY == null) {
            CreateElementActionBase.$$$reportNull$$$0(0);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    protected void invokeDialog(@NotNull Project project2, @NotNull PsiDirectory directory, @NotNull Consumer<PsiElement[]> elementsConsumer) {
        if (project2 == null) {
            CreateElementActionBase.$$$reportNull$$$0(1);
        }
        if (directory == null) {
            CreateElementActionBase.$$$reportNull$$$0(2);
        }
        if (elementsConsumer == null) {
            CreateElementActionBase.$$$reportNull$$$0(3);
        }
        elementsConsumer.accept(this.invokeDialog(project2, directory));
    }

    protected abstract PsiElement @NotNull [] create(@NotNull String var1, PsiDirectory var2) throws Exception;

    @Nls(capitalization=Nls.Capitalization.Title)
    protected abstract String getErrorTitle();

    @Deprecated
    protected String getCommandName() {
        return "";
    }

    @Nls
    protected abstract String getActionName(PsiDirectory var1, String var2);

    @Override
    public final void actionPerformed(@NotNull AnActionEvent e) {
        IdeView view;
        if (e == null) {
            CreateElementActionBase.$$$reportNull$$$0(4);
        }
        if ((view = this.getIdeView(e)) == null) {
            return;
        }
        Project project2 = e.getProject();
        PsiDirectory dir = view.getOrChooseDirectory();
        if (dir == null || project2 == null) {
            return;
        }
        this.invokeDialog(project2, dir, createdElements -> {
            for (PsiElement createdElement : createdElements) {
                view.selectElement(createdElement);
            }
        });
    }

    @Nullable
    protected IdeView getIdeView(@NotNull AnActionEvent e) {
        if (e == null) {
            CreateElementActionBase.$$$reportNull$$$0(5);
        }
        return e.getData(LangDataKeys.IDE_VIEW);
    }

    public static String filterMessage(String message) {
        if (message == null) {
            return null;
        }
        String ioExceptionPrefix = "java.io.IOException:";
        message = StringUtil.trimStart(message, "java.io.IOException:");
        return message;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/CreateElementActionBase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsConsumer";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeDialog";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/CreateElementActionBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invokeDialog";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getIdeView";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class MyInputValidator
    extends ElementCreator
    implements InputValidator {
        private final PsiDirectory myDirectory;
        private PsiElement[] myCreatedElements;

        public MyInputValidator(Project project2, PsiDirectory directory) {
            super(project2, CreateElementActionBase.this.getErrorTitle());
            this.myCreatedElements = PsiElement.EMPTY_ARRAY;
            this.myDirectory = directory;
        }

        public PsiDirectory getDirectory() {
            return this.myDirectory;
        }

        @Override
        public boolean checkInput(String inputString) {
            return true;
        }

        @Override
        public PsiElement[] create(@NotNull String newName) throws Exception {
            if (newName == null) {
                MyInputValidator.$$$reportNull$$$0(0);
            }
            return CreateElementActionBase.this.create(newName, this.myDirectory);
        }

        @Override
        public boolean startInWriteAction() {
            return CreateElementActionBase.this.startInWriteAction();
        }

        @Override
        public String getActionName(String newName) {
            return CreateElementActionBase.this.getActionName(this.myDirectory, newName);
        }

        @Override
        public boolean canClose(String inputString) {
            this.myCreatedElements = this.tryCreate(inputString);
            return this.myCreatedElements.length > 0;
        }

        public final PsiElement[] getCreatedElements() {
            return this.myCreatedElements;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/ide/actions/CreateElementActionBase$MyInputValidator", "create"));
        }
    }
}

