/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.ide.ui.newItemPopup.NewItemPopupUtil;
import com.intellij.ide.ui.newItemPopup.NewItemSimplePopupPanel;
import com.intellij.idea.ActionsBundle;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import java.awt.event.InputEvent;
import java.io.File;
import java.util.List;
import java.util.StringTokenizer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateFileAction
extends CreateElementActionBase
implements DumbAware {
    public CreateFileAction() {
        super(ActionsBundle.messagePointer("action.NewFile.text", new Object[0]), IdeBundle.messagePointer("action.create.new.file.description", new Object[0]), AllIcons.FileTypes.Text);
    }

    public CreateFileAction(@Nls(capitalization=Nls.Capitalization.Title) String text2, @Nls(capitalization=Nls.Capitalization.Sentence) String description, Icon icon2) {
        super(text2, description, icon2);
    }

    public CreateFileAction(Supplier<String> dynamicText, Supplier<String> dynamicDescription, Icon icon2) {
        super(dynamicText, dynamicDescription, icon2);
    }

    @Override
    public boolean isDumbAware() {
        return CreateFileAction.class.equals(this.getClass());
    }

    @Override
    protected PsiElement @NotNull [] invokeDialog(Project project2, PsiDirectory directory) {
        if (PsiElement.EMPTY_ARRAY == null) {
            CreateFileAction.$$$reportNull$$$0(0);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @Override
    protected void invokeDialog(@NotNull Project project2, @NotNull PsiDirectory directory, @NotNull Consumer<PsiElement[]> elementsConsumer) {
        if (project2 == null) {
            CreateFileAction.$$$reportNull$$$0(1);
        }
        if (directory == null) {
            CreateFileAction.$$$reportNull$$$0(2);
        }
        if (elementsConsumer == null) {
            CreateFileAction.$$$reportNull$$$0(3);
        }
        MyValidator validator2 = new MyValidator(project2, directory);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            try {
                elementsConsumer.accept(((CreateElementActionBase.MyInputValidator)validator2).create("test"));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else if (Experiments.getInstance().isFeatureEnabled("show.create.new.element.in.popup")) {
            this.createLightWeightPopup(validator2, elementsConsumer).showCenteredInCurrentWindow(project2);
        } else {
            Messages.showInputDialog(project2, IdeBundle.message("prompt.enter.new.file.name", new Object[0]), IdeBundle.message("title.new.file", new Object[0]), null, null, (InputValidator)validator2);
            elementsConsumer.accept(validator2.getCreatedElements());
        }
    }

    private JBPopup createLightWeightPopup(CreateElementActionBase.MyInputValidator validator2, Consumer<PsiElement[]> consumer) {
        NewItemSimplePopupPanel contentPanel2 = new NewItemSimplePopupPanel();
        JTextField nameField = contentPanel2.getTextField();
        JBPopup popup2 = NewItemPopupUtil.createNewItemPopup(IdeBundle.message("title.new.file", new Object[0]), contentPanel2, nameField);
        contentPanel2.setApplyAction(event -> {
            String name = nameField.getText();
            if (validator2.checkInput(name) && validator2.canClose(name)) {
                popup2.closeOk((InputEvent)event);
                consumer.accept(validator2.getCreatedElements());
            } else {
                String errorMessage = validator2 instanceof InputValidatorEx ? ((InputValidatorEx)((Object)validator2)).getErrorText(name) : LangBundle.message("incorrect.name", new Object[0]);
                contentPanel2.setError(errorMessage);
            }
        });
        return popup2;
    }

    @Override
    protected PsiElement @NotNull [] create(@NotNull String newName, PsiDirectory directory) throws Exception {
        if (newName == null) {
            CreateFileAction.$$$reportNull$$$0(4);
        }
        MkDirs mkdirs = new MkDirs(newName, directory);
        PsiElement[] psiElementArray = new PsiElement[]{WriteAction.compute(() -> mkdirs.directory.createFile(this.getFileName(mkdirs.newName)))};
        if (psiElementArray == null) {
            CreateFileAction.$$$reportNull$$$0(5);
        }
        return psiElementArray;
    }

    public static PsiDirectory findOrCreateSubdirectory(@NotNull PsiDirectory parent, @NotNull String subdirName) {
        PsiDirectory sub;
        if (parent == null) {
            CreateFileAction.$$$reportNull$$$0(6);
        }
        if (subdirName == null) {
            CreateFileAction.$$$reportNull$$$0(7);
        }
        return (sub = parent.findSubdirectory(subdirName)) == null ? WriteAction.compute(() -> parent.createSubdirectory(subdirName)) : sub;
    }

    @Override
    protected String getActionName(PsiDirectory directory, String newName) {
        return IdeBundle.message("progress.creating.file", directory.getVirtualFile().getPresentableUrl(), File.separator, newName);
    }

    @Override
    protected String getErrorTitle() {
        return IdeBundle.message("title.cannot.create.file", new Object[0]);
    }

    protected String getFileName(String newName) {
        if (this.getDefaultExtension() == null || FileUtilRt.getExtension(newName).length() > 0) {
            return newName;
        }
        return newName + "." + this.getDefaultExtension();
    }

    @Nullable
    protected String getDefaultExtension() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/CreateFileAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsConsumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subdirName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeDialog";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/CreateFileAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invokeDialog";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateSubdirectory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class MyValidator
    extends CreateElementActionBase.MyInputValidator
    implements InputValidatorEx {
        private String myErrorText;

        public MyValidator(Project project2, PsiDirectory directory) {
            super(CreateFileAction.this, project2, directory);
        }

        @Override
        public boolean checkInput(String inputString) {
            StringTokenizer tokenizer = new StringTokenizer(inputString, "\\/");
            VirtualFile vFile = this.getDirectory().getVirtualFile();
            boolean firstToken = true;
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if ((token.equals(".") || token.equals("..")) && !tokenizer.hasMoreTokens()) {
                    this.myErrorText = IdeBundle.message("error.invalid.file.name", token);
                    return false;
                }
                if (vFile != null) {
                    if (firstToken && "~".equals(token)) {
                        VirtualFile userHomeDir = VfsUtil.getUserHomeDir();
                        if (userHomeDir == null) {
                            this.myErrorText = IdeBundle.message("error.user.home.directory.not.found", new Object[0]);
                            return false;
                        }
                        vFile = userHomeDir;
                    } else if ("..".equals(token)) {
                        VirtualFile parent = vFile.getParent();
                        if (parent == null) {
                            this.myErrorText = IdeBundle.message("error.invalid.directory", vFile.getPresentableUrl() + File.separatorChar + "..");
                            return false;
                        }
                        vFile = parent;
                    } else if (!".".equals(token)) {
                        VirtualFile child2 = vFile.findChild(token);
                        if (child2 != null) {
                            if (!child2.isDirectory()) {
                                this.myErrorText = IdeBundle.message("error.file.with.name.already.exists", token);
                                return false;
                            }
                            if (!tokenizer.hasMoreTokens()) {
                                this.myErrorText = IdeBundle.message("error.directory.with.name.already.exists", token);
                                return false;
                            }
                        }
                        vFile = child2;
                    }
                }
                if (FileTypeManager.getInstance().isFileIgnored(CreateFileAction.this.getFileName(token))) {
                    this.myErrorText = IdeBundle.message("warning.create.directory.with.ignored.name", token);
                    return true;
                }
                firstToken = false;
            }
            this.myErrorText = null;
            return true;
        }

        @Override
        public String getErrorText(String inputString) {
            return this.myErrorText;
        }

        @Override
        public PsiElement[] create(@NotNull String newName) throws Exception {
            if (newName == null) {
                MyValidator.$$$reportNull$$$0(0);
            }
            return super.create(newName);
        }

        @Override
        public boolean canClose(String inputString) {
            if (inputString.length() == 0) {
                return super.canClose(inputString);
            }
            PsiDirectory psiDirectory = this.getDirectory();
            Project project2 = psiDirectory.getProject();
            FileType fileType = FileTypeChooser.getKnownFileTypeOrAssociate(psiDirectory.getVirtualFile(), CreateFileAction.this.getFileName(inputString), project2);
            if (fileType == null) {
                return false;
            }
            return super.canClose(CreateFileAction.this.getFileName(inputString));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/ide/actions/CreateFileAction$MyValidator", "create"));
        }
    }

    public static class MkDirs {
        public final String newName;
        public final PsiDirectory directory;

        public MkDirs(@NotNull String newName, @NotNull PsiDirectory directory) {
            if (newName == null) {
                MkDirs.$$$reportNull$$$0(0);
            }
            if (directory == null) {
                MkDirs.$$$reportNull$$$0(1);
            }
            if (SystemInfo.isWindows) {
                newName = newName.replace('\\', '/');
            }
            if (newName.contains("/")) {
                List<String> subDirs = StringUtil.split(newName, "/");
                newName = subDirs.remove(subDirs.size() - 1);
                boolean firstToken = true;
                for (String dir : subDirs) {
                    if (firstToken && "~".equals(dir)) {
                        VirtualFile userHomeDir = VfsUtil.getUserHomeDir();
                        if (userHomeDir == null) {
                            throw new IncorrectOperationException("User home directory not found");
                        }
                        PsiDirectory directory1 = directory.getManager().findDirectory(userHomeDir);
                        if (directory1 == null) {
                            throw new IncorrectOperationException("User home directory not found");
                        }
                        directory = directory1;
                    } else if ("..".equals(dir)) {
                        PsiDirectory parentDirectory = directory.getParentDirectory();
                        if (parentDirectory == null) {
                            throw new IncorrectOperationException("Not a valid directory");
                        }
                        directory = parentDirectory;
                    } else if (!".".equals(dir)) {
                        directory = CreateFileAction.findOrCreateSubdirectory(directory, dir);
                    }
                    firstToken = false;
                }
            }
            this.newName = newName;
            this.directory = directory;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "newName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "directory";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/actions/CreateFileAction$MkDirs";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

