/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.CreateFileAction;
import com.intellij.ide.actions.CreateFromTemplateAction;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.actions.CreateFromTemplateActionBase;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.apache.velocity.runtime.parser.ParseException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CreateFileFromTemplateAction
extends CreateFromTemplateAction<PsiFile> {
    public CreateFileFromTemplateAction(@Nls(capitalization=Nls.Capitalization.Title) String text2, @Nls(capitalization=Nls.Capitalization.Sentence) String description, Icon icon2) {
        super(text2, description, icon2);
    }

    public CreateFileFromTemplateAction(@NotNull Supplier<String> dynamicText, @NotNull Supplier<String> dynamicDescription, Icon icon2) {
        if (dynamicText == null) {
            CreateFileFromTemplateAction.$$$reportNull$$$0(0);
        }
        if (dynamicDescription == null) {
            CreateFileFromTemplateAction.$$$reportNull$$$0(1);
        }
        super(dynamicText, dynamicDescription, icon2);
    }

    protected PsiFile createFileFromTemplate(String name, FileTemplate template, PsiDirectory dir) {
        return CreateFileFromTemplateAction.createFileFromTemplate(name, template, dir, this.getDefaultTemplateProperty(), true);
    }

    @Nullable
    public static PsiFile createFileFromTemplate(@Nullable String name, @NotNull FileTemplate template, @NotNull PsiDirectory dir, @Nullable String defaultTemplateProperty, boolean openFile2) {
        if (template == null) {
            CreateFileFromTemplateAction.$$$reportNull$$$0(2);
        }
        if (dir == null) {
            CreateFileFromTemplateAction.$$$reportNull$$$0(3);
        }
        return CreateFileFromTemplateAction.createFileFromTemplate(name, template, dir, defaultTemplateProperty, openFile2, Collections.emptyMap());
    }

    @Nullable
    public static PsiFile createFileFromTemplate(@Nullable String name, @NotNull FileTemplate template, @NotNull PsiDirectory dir, @Nullable String defaultTemplateProperty, boolean openFile2, @NotNull Map<String, String> liveTemplateDefaultValues) {
        if (template == null) {
            CreateFileFromTemplateAction.$$$reportNull$$$0(4);
        }
        if (dir == null) {
            CreateFileFromTemplateAction.$$$reportNull$$$0(5);
        }
        if (liveTemplateDefaultValues == null) {
            CreateFileFromTemplateAction.$$$reportNull$$$0(6);
        }
        if (name != null) {
            CreateFileAction.MkDirs mkdirs = new CreateFileAction.MkDirs(name, dir);
            name = mkdirs.newName;
            dir = mkdirs.directory;
        }
        Project project2 = dir.getProject();
        try {
            PsiFile psiFile = FileTemplateUtil.createFromTemplate(template, name, FileTemplateManager.getInstance(dir.getProject()).getDefaultProperties(), dir).getContainingFile();
            SmartPsiElementPointer<PsiFile> pointer = SmartPointerManager.getInstance(project2).createSmartPsiElementPointer(psiFile);
            VirtualFile virtualFile2 = psiFile.getVirtualFile();
            if (virtualFile2 != null) {
                if (openFile2) {
                    if (template.isLiveTemplateEnabled()) {
                        CreateFromTemplateActionBase.startLiveTemplate(psiFile, liveTemplateDefaultValues);
                    } else {
                        FileEditorManager.getInstance(project2).openFile(virtualFile2, true);
                    }
                }
                if (defaultTemplateProperty != null) {
                    PropertiesComponent.getInstance(project2).setValue(defaultTemplateProperty, template.getName());
                }
                return pointer.getElement();
            }
        }
        catch (ParseException e) {
            throw new IncorrectOperationException("Error parsing Velocity template: " + e.getMessage(), e);
        }
        catch (IncorrectOperationException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error(e);
        }
        return null;
    }

    @Override
    protected PsiFile createFile(String name, String templateName, PsiDirectory dir) {
        FileTemplate template = FileTemplateManager.getInstance(dir.getProject()).getInternalTemplate(templateName);
        return this.createFileFromTemplate(name, template, dir);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicDescription";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "liveTemplateDefaultValues";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/CreateFileFromTemplateAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createFileFromTemplate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

